/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.compilation.CompilationErrorInfo;
import oracle.javatools.db.compilation.CompilationResults;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DateDataType;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.dictionary.DictionaryQueries;
import oracle.javatools.db.execute.PlSqlWrapper;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.IndextypeBuilder;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.ora.OracleTriggerBuilder;
import oracle.javatools.db.ora.PlSqlSourceBuilder;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.db.plsql.PlSqlIdentifier;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.driver.OracleConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseImpl
extends BaseOracleDatabase {
    public static final String BUILTIN_INDEXTYPE_SCHEMA_CTXSYS = "CTXSYS";
    public static final String BUILTIN_INDEXTYPE_SCHEMA_EFXSYS = "EFXSYS";
    public static final String BUILTIN_INDEXTYPE_SCHEMA_MDSYS = "MDSYS";
    public static final String BUILTIN_INDEXTYPE_SCHEMA_ORDSYS = "ORDSYS";
    public static final String BUILTIN_INDEXTYPE_SCHEMA_SYS = "SYS";
    public static final String BUILTIN_INDEXTYPE_SCHEMA_XDB = "XDB";
    public static final String[] BUILTIN_INDEXTYPE_SCHEMA_NAMES = new String[]{"CTXSYS", "EFXSYS", "MDSYS", "ORDSYS", "SYS", "XDB"};
    private static final Map<String, Map<String, Indextype[]>> s_builtinIndextypes = new HashMap<String, Map<String, Indextype[]>>();
    private static final String ERRORS_QUERY = "SELECT /*OracleDatabaseImpl.ALL_ERRORS_QUERY*/\n       A.OWNER, A.TYPE, A.NAME,        A.LINE, A.POSITION, REPLACE(A.TEXT, CHR(10), ' ') TEXT, 'ERROR' ATTRIBUTE FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ";
    private static final String ERRORS_QUERY_10G = "SELECT /*OracleDatabaseImpl.ALL_ERRORS_QUERY_10G*/\n       A.OWNER, A.TYPE, A.NAME,        A.LINE, A.POSITION, REPLACE(A.TEXT, CHR(10), ' ') TEXT, A.ATTRIBUTE FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ";
    private static final String SET_WARNINGS_FLAG = "BEGIN /*OracleDatabaseImpl.ALL_SET_WARNINGS_FLAG*/\n       DBMS_WARNING.ADD_WARNING_SETTING_CAT( ?, ? , ? ); END;";
    private static final String ENABLE_DEBUG = "ALTER /*OracleDatabaseImpl.ALL_ENABLE_DEBUG*/\n       SESSION SET PLSQL_DEBUG = TRUE";
    private static final String DISABLE_DEBUG = "ALTER /*OracleDatabaseImpl.ALL_DISABLE_DEBUG*/\n       SESSION SET PLSQL_DEBUG = FALSE";
    private static final String PARTITIONING_QUERY = "SELECT /*OracleDatabaseImpl.ALL_PARTITIONING_QUERY*/\n       VALUE FROM V$OPTION WHERE PARAMETER='Partitioning'";
    private static final String TEST_SQL_STMT = "declare cols integer; cid  integer; tab dbms_sql.desc_tab;begin cid := dbms_sql.open_cursor; dbms_sql.parse(cid,?,dbms_sql.native); dbms_sql.describe_columns(cid,cols,tab); dbms_sql.close_cursor(cid);exception when others then ? := dbms_sql.last_error_position; ? := sqlerrm; dbms_sql.close_cursor(cid);end;";
    private Boolean m_partitioning;
    private Boolean m_debugInfo;
    private boolean m_rolesChecked;
    private static String s_api_version = null;

    OracleDatabaseImpl(String storeName, String connName, Connection conn) {
        super(storeName, connName, conn);
    }

    public Boolean isConnectionClosed(SQLException sqe) {
        boolean retval = false;
        if (sqe != null) {
            this.getLogger().info(DBArb.format((int)432, (Object)this.getName()));
            retval = sqe.getErrorCode() == 17008;
        }
        return retval;
    }

    protected void reconnected(Connection c) {
        super.reconnected(c);
        this.setSQLTraceOnIfReqd(c);
        this.m_rolesChecked = false;
    }

    @Override
    public DictionaryQueries getDictionaryQueries() {
        if (!this.m_rolesChecked) {
            this.m_rolesChecked = true;
            this.hasRole("DBA");
        }
        return super.getDictionaryQueries();
    }

    public boolean supportsJava() {
        return false;
    }

    public boolean supportsPartitioning() {
        if (this.m_partitioning == null) {
            this.checkPartitioning();
        }
        return this.m_partitioning;
    }

    @Deprecated
    public final String getNLSSessionValue(String parameter) {
        return this.getSessionParameterValue(parameter);
    }

    private void checkPartitioning() {
        final QueryWrapper wrap = this.newQueryWrapper(PARTITIONING_QUERY, new Object[0]);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        OracleDatabaseImpl.this.m_partitioning = Boolean.valueOf(rs.getString(1));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException(ex);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Could not query whether database " + this.getConnectionName() + " supports partitioning", dbe);
            this.m_partitioning = Boolean.FALSE;
        }
    }

    @Override
    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("TRIGGER", (DBObjectBuilder)new OracleTriggerBuilder(this));
        this.registerBuilder("FUNCTION", (DBObjectBuilder)new PlSqlSourceBuilder(this, "FUNCTION"));
        this.registerBuilder("PROCEDURE", (DBObjectBuilder)new PlSqlSourceBuilder(this, "PROCEDURE"));
        this.registerBuilder("PACKAGE", (DBObjectBuilder)new PlSqlSourceBuilder(this, "PACKAGE"));
        this.registerBuilder("INDEXTYPE", (DBObjectBuilder)new IndextypeBuilder(this));
    }

    protected boolean hasRole(String role) {
        boolean retval = false;
        try {
            Collection cachedRoles;
            Schema currSchema = this.getDefaultSchema();
            if (currSchema != null && (cachedRoles = (Collection)currSchema.getProperty("USER_ROLES")) != null) {
                retval = cachedRoles.contains(role);
            }
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Couldn't determine user roles: " + dbe.getMessage());
        }
        return retval;
    }

    protected boolean hasPrivilege(String priv) {
        boolean retval = false;
        try {
            Collection cachedPrivs;
            Schema currSchema = this.getDefaultSchema();
            if (currSchema != null && (cachedPrivs = (Collection)currSchema.getProperty("USER_PRIVS")) != null) {
                retval = cachedPrivs.contains(priv);
            }
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Couldn't determine user privs: " + dbe.getMessage());
        }
        return retval;
    }

    public void close() {
        super.close();
    }

    public CompilationResults submitDatabaseSource(String schemaName, String source) {
        ArrayList<String> sources = new ArrayList<String>();
        sources.add(source);
        return this.submitDatabaseSources(schemaName, sources).get(0);
    }

    public List<CompilationResults> submitDatabaseSources(String schemaName, List<String> sources) {
        int i;
        ArrayList<CompilationResults> results = new ArrayList();
        ArrayList<PlSqlIdentifier> ids = new ArrayList<PlSqlIdentifier>();
        CompilationResults[] failedSubmits = new CompilationResults[sources.size()];
        this.setCompilerOptions();
        String requiredSchema = this.getUserName();
        if (ModelUtil.hasLength((String)schemaName)) {
            requiredSchema = schemaName;
        }
        for (i = 0; i < sources.size(); ++i) {
            CompilationResults cr;
            String source = sources.get(i);
            PlSqlInterrogator pi = PlSqlInterrogator.findOrCreate((String)source);
            String name = this.getInternalName(pi.getName());
            if (ModelUtil.hasLength((String)pi.getSchemaName()) && ModelUtil.areDifferent((Object)requiredSchema, (Object)pi.getSchemaName()) || !ModelUtil.hasLength((String)pi.getSchemaName()) && ModelUtil.areDifferent((Object)requiredSchema, (Object)this.getUserName())) {
                name = this.getExternalName(requiredSchema) + "." + this.getExternalName(name);
                source = pi.getRenamedSource(name, true);
                pi = PlSqlInterrogator.findOrCreate((String)source);
            }
            source = "CREATE OR REPLACE\n" + pi.getRoot().getSource();
            PlSqlIdentifier id = pi.getPlSqlIdentifier(requiredSchema, true);
            ids.add(id);
            try {
                PlSqlWrapper wrap = new PlSqlWrapper((Database)this, source, new Object[0]);
                wrap.executePlSql(new PlSqlWrapper.PlSqlRunnable(){});
                continue;
            }
            catch (InvalidSQLException e) {
                cr = new CompilationResults();
                cr.setSubmitFailed(true);
                cr.addError(new CompilationErrorInfo(1, 1, e.getMessage()));
                failedSubmits[i] = cr;
                continue;
            }
            catch (DBException e) {
                cr = new CompilationResults();
                cr.setSubmitFailed(true);
                cr.addError(new CompilationErrorInfo(1, 1, e.getMessage()));
                failedSubmits[i] = cr;
            }
        }
        results = this.getCompilationResults(ids);
        for (i = 0; i < sources.size(); ++i) {
            if (failedSubmits[i] == null) continue;
            results.remove(i);
            results.add(i, failedSubmits[i]);
        }
        return results;
    }

    public void setCompilerOptions() {
        Boolean debugInfo;
        GlobalSettings settings = GlobalSettings.getInstance();
        PlSqlCompilerOptions opts = settings == null ? null : settings.getPlSqlCompilerOptions();
        Boolean bl = debugInfo = opts == null ? Boolean.FALSE : Boolean.valueOf(opts.isGeneratePlSqlDebugInfo());
        if (ModelUtil.areDifferent((Object)this.m_debugInfo, (Object)debugInfo)) {
            this.m_debugInfo = debugInfo;
            this.generateDebugInfo();
        }
        this.setWarningFlags(opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDebugInfo() {
        Connection conn;
        Connection connection = conn = this.getConnection();
        synchronized (connection) {
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                stmt.executeUpdate(this.m_debugInfo != false ? ENABLE_DEBUG : DISABLE_DEBUG);
            }
            catch (SQLException sqlEx) {
                while (sqlEx != null) {
                    DBLog.log((String)sqlEx.getLocalizedMessage(), (Object[])new Object[0]);
                    sqlEx = sqlEx.getNextException();
                }
            }
            catch (Exception ex) {
                DBLog.logStackTrace((Throwable)ex);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWarningFlags(PlSqlCompilerOptions opts) {
        if (this.getDatabaseVersion() >= 100 && opts != null) {
            Connection conn;
            Connection connection = conn = this.getConnection();
            synchronized (connection) {
                CallableStatement stmt = null;
                try {
                    stmt = conn.prepareCall(SET_WARNINGS_FLAG);
                    for (PlSqlCompilerOptions.WarningCategory category : PlSqlCompilerOptions.WarningCategory.values()) {
                        PlSqlCompilerOptions.WarningValue value = opts.getWarningValue(category);
                        if (value == null) continue;
                        stmt.setString(1, category.name());
                        stmt.setString(2, value.name());
                        stmt.setString(3, "SESSION");
                        stmt.execute();
                    }
                }
                catch (SQLException sqlEx) {
                    while (sqlEx != null) {
                        DBLog.log((String)sqlEx.getLocalizedMessage(), (Object[])new Object[0]);
                        sqlEx = sqlEx.getNextException();
                    }
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
        }
    }

    private String getErrorQuery() {
        return this.getDatabaseVersion() >= 100 ? ERRORS_QUERY_10G : ERRORS_QUERY;
    }

    public void testSQLStatement(final String sql) throws DBException {
        PlSqlWrapper wrap = new PlSqlWrapper((Database)this, TEST_SQL_STMT, new Object[]{sql});
        wrap.executePlSql(new PlSqlWrapper.PlSqlRunnable(){

            public void prepareCall(CallableStatement cs) throws SQLException, DBException {
                cs.registerOutParameter(2, 4);
                cs.registerOutParameter(3, 12);
            }

            public void processCall(CallableStatement cs) throws SQLException, DBException {
                int errorPosition = cs.getInt(2);
                String errorMessage = cs.getString(3);
                if (errorPosition > 0) {
                    throw new InvalidSQLException(sql, errorMessage, Integer.valueOf(errorPosition));
                }
            }
        });
    }

    public List<CompilationResults> getCompilationResults(List<PlSqlIdentifier> plsqlIds) {
        ArrayList<CompilationResults> retval = new ArrayList<CompilationResults>();
        final HashMap<PlSqlIdentifier, CompilationResults> map = new HashMap<PlSqlIdentifier, CompilationResults>();
        ArrayList<QueryWrapper> wrappers = new ArrayList<QueryWrapper>();
        for (PlSqlIdentifier plsqlID : plsqlIds) {
            QueryWrapper wrap = new QueryWrapper((Database)this, this.getErrorQuery(), new Object[]{plsqlID.getName(), plsqlID.getPlsqlType() == null ? null : plsqlID.getPlsqlType().toString(), plsqlID.getSchemaName()});
            wrappers.add(wrap);
            map.put(plsqlID, new CompilationResults());
        }
        try {
            if (wrappers.size() > 0) {
                final QueryWrapper wrap = QueryWrapper.union((QueryWrapper[])wrappers.toArray(new QueryWrapper[wrappers.size()]));
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            while (rs.next()) {
                                String schema = rs.getString("OWNER");
                                String type = rs.getString("TYPE");
                                String name = rs.getString("NAME");
                                PlSqlIdentifier id = new PlSqlIdentifier(name, schema, PlSqlIdentifier.PlSqlType.valueOf((String)type.replaceAll(" ", "_")));
                                CompilationResults cr = (CompilationResults)map.get(id);
                                CompilationErrorInfo info = new CompilationErrorInfo(rs.getInt("LINE"), rs.getInt("POSITION"), rs.getString("TEXT"), "WARNING".equals(rs.getString("ATTRIBUTE")));
                                cr.addError(info);
                            }
                        }
                        catch (SQLException ex) {
                            wrap.throwDBException(ex);
                        }
                    }
                };
                wrap.executeQuery(r);
                for (PlSqlIdentifier plsqlID : plsqlIds) {
                    retval.add((CompilationResults)map.get(plsqlID));
                }
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        return retval;
    }

    public static String[] listBuiltInIndextypeSchemas(Class providerClass) {
        HashSet<String> schemas = new HashSet<String>();
        while (providerClass != null && !providerClass.equals(Object.class)) {
            Map<String, Indextype[]> indextypeMap = s_builtinIndextypes.get(providerClass.getName());
            if (indextypeMap != null) {
                schemas.addAll(indextypeMap.keySet());
            }
            providerClass = providerClass.getSuperclass();
        }
        return schemas.toArray(new String[schemas.size()]);
    }

    public static Indextype[] listBuiltInIndextypes(Class providerClass, String schemaName) {
        if (OracleDatabaseImpl.isBuiltInIndextypeSchema(schemaName)) {
            while (providerClass != null && !providerClass.equals(Object.class)) {
                Indextype[] indextypes;
                Map<String, Indextype[]> indextypeMap = s_builtinIndextypes.get(providerClass.getName());
                if (indextypeMap != null && (indextypes = indextypeMap.get(schemaName)) != null) {
                    return indextypes;
                }
                providerClass = providerClass.getSuperclass();
            }
        }
        return new Indextype[0];
    }

    protected static void registerBuiltInIndextypes(Class providerClass, String schemaName, String[] indextypeNames) {
        Indextype[] its = new Indextype[indextypeNames.length];
        Schema schema = new Schema(schemaName);
        for (int i = 0; i < indextypeNames.length; ++i) {
            its[i] = new Indextype(indextypeNames[i], schema);
            its[i].setID((DBObjectID)new ReferenceID((DBObject)its[i]));
        }
        Map<String, Indextype[]> indextypeMap = s_builtinIndextypes.get(providerClass.getName());
        if (indextypeMap == null) {
            indextypeMap = new HashMap<String, Indextype[]>();
            s_builtinIndextypes.put(providerClass.getName(), indextypeMap);
        }
        indextypeMap.put(schemaName, its);
    }

    private static boolean isBuiltInIndextypeSchema(String schemaName) {
        for (String name : BUILTIN_INDEXTYPE_SCHEMA_NAMES) {
            if (!name.equals(schemaName)) continue;
            return true;
        }
        return false;
    }

    public static String getAPIVersionForSQLTrace() {
        String ade_view_root;
        if (s_api_version == null && ModelUtil.hasLength((String)(ade_view_root = System.getenv("ADE_VIEW_ROOT")))) {
            FileReader fr = null;
            try {
                fr = new FileReader(ade_view_root + "/ade_info.vmd");
            }
            catch (FileNotFoundException e) {
                return null;
            }
            BufferedReader br = new BufferedReader(fr);
            String record = null;
            try {
                while ((record = br.readLine()) != null) {
                    if (record.startsWith("VIEW_LABEL")) {
                        s_api_version = record.substring(record.indexOf(" ")).trim();
                    }
                    if (!record.startsWith("VIEW_TRANS_NAME")) continue;
                    String txn = record.substring(record.indexOf(" ")).trim();
                    if (ModelUtil.areDifferent((Object)txn, (Object)"NONE")) {
                        s_api_version = s_api_version + "/" + txn;
                    }
                    break;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return s_api_version;
    }

    public static void setAPIVersionForSQLTrace(String v) {
        s_api_version = v;
    }

    private void setSQLTraceOnIfReqd(Connection c) {
        String dbSqlTraceProp = System.getProperty("db-sqltrace");
        if (ModelUtil.hasLength((String)dbSqlTraceProp)) {
            String[] actualConnParts = new String[]{};
            if (c instanceof OracleConnection) {
                Properties p = ((OracleConnection)c).getProperties();
                String s = (String)p.get("database") + ":" + ((String)p.get("user")).toLowerCase();
                actualConnParts = s.split(":");
            }
            String[] propParts = dbSqlTraceProp.split(",");
            boolean doThisConnection = false;
            String activity = null;
            block4: for (int i = 0; i < propParts.length && !doThisConnection; ++i) {
                int j;
                String[] propSubParts = propParts[i].split(":");
                activity = propSubParts[0];
                String[] propConnParts = new String[4];
                for (j = 0; j < propSubParts.length - 1 && j < propConnParts.length; ++j) {
                    propConnParts[j] = propSubParts[j + 1];
                }
                while (j < 4) {
                    propConnParts[j] = "";
                    ++j;
                }
                propConnParts[3] = propConnParts[3].toLowerCase();
                doThisConnection = true;
                for (j = 0; j < actualConnParts.length && j < 4; ++j) {
                    if (propConnParts[j].equals("")) continue;
                    if (j == 0) {
                        String shorter = propConnParts[j].length() > actualConnParts[j].length() ? actualConnParts[j] : propConnParts[j];
                        String longer = propConnParts[j].length() > actualConnParts[j].length() ? propConnParts[j] : actualConnParts[j];
                        shorter = shorter + '.';
                        if ((longer = longer + '.').startsWith(shorter)) continue;
                        doThisConnection = false;
                        continue block4;
                    }
                    if (propConnParts[j].equals(actualConnParts[j])) continue;
                    doThisConnection = false;
                    continue block4;
                }
            }
            if (doThisConnection) {
                StatementWrapper x = new StatementWrapper((Database)this, new String[]{"ALTER SESSION SET SQL_TRACE=TRUE"});
                try {
                    x.execute();
                }
                catch (DBException e) {
                    // empty catch block
                }
                String query = "SELECT /* :DB-API:" + this.getUserName() + ":" + activity + ":" + OracleDatabaseImpl.getAPIVersionForSQLTrace() + ":" + " */ 1 FROM DUAL";
                QueryWrapper y = new QueryWrapper((Database)this, query);
                try {
                    QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                        public void processResultSet(ResultSet rs) throws DBException {
                        }
                    };
                    y.executeQuery(r);
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
        }
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        Registerer() {
        }

        public void registerDataTypes(DataTypeRegistry dtr) {
            NumericDataType.MinMaxValue MIN_MAX_FLOAT = new NumericDataType.MinMaxValue("1.0e-130", "9.9999999999999999999999999999999999999e+125", 2);
            NumericDataType.MinMaxValue MIN_MAX_INT = new NumericDataType.MinMaxValue("-99999999999999999999999999999999999999", "99999999999999999999999999999999999999", 0);
            OracleNumberDataType DATATYPE_NUMBER = new OracleNumberDataType(1);
            NumericDataType DATATYPE_FLOAT = new NumericDataType(1, "FLOAT", "FLOAT[(<precision>)]", 1L, 126L, new Long(126L), false, null, MIN_MAX_FLOAT);
            CharacterDataType DATATYPE_VARCHAR2 = new CharacterDataType(1, "VARCHAR2", "VARCHAR2(<size>)", 1L, 4000L, 20L, true, null);
            CharacterDataType DATATYPE_CHAR = new CharacterDataType(1, "CHAR", "CHAR[(<size>)]", 1L, 2000L, 1L, false, null);
            CharacterDataType DATATYPE_LONG = new CharacterDataType(1, "LONG", 1L, Integer.MAX_VALUE);
            BinaryDataType DATATYPE_RAW = new BinaryDataType(1, "RAW", "RAW(<size>)", 1L, 2000L, 20L, true, null);
            BinaryDataType DATATYPE_LONG_RAW = new BinaryDataType(1, "LONG RAW", 1L, Integer.MAX_VALUE);
            PredefinedDataType DATATYPE_ROWID = new PredefinedDataType(1, "ROWID");
            DateDataType DATATYPE_DATE = new DateDataType(1, "DATE");
            dtr.registerDataType((DataType)DATATYPE_CHAR, OracleDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dtr.registerDataType((DataType)DATATYPE_DATE, OracleDatabaseImpl.class, JdbcDatabase.ANSI_DATE);
            dtr.registerDataType((DataType)DATATYPE_FLOAT, OracleDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)DATATYPE_LONG, OracleDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dtr.registerDataType((DataType)DATATYPE_LONG_RAW, OracleDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class, JdbcDatabase.ANSI_NUMERIC);
            dtr.registerDataType((DataType)DATATYPE_RAW, OracleDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_ROWID, OracleDatabaseImpl.class, JdbcDatabase.ANSI_REAL);
            dtr.registerDataType((DataType)DATATYPE_VARCHAR2, OracleDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dtr.registerSynonym("CHARACTER", (DataType)DATATYPE_CHAR, OracleDatabaseImpl.class);
            dtr.registerSynonym("CHAR VARYING", (DataType)DATATYPE_VARCHAR2, OracleDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER VARYING", (DataType)DATATYPE_VARCHAR2, OracleDatabaseImpl.class);
            dtr.registerSynonym("LONG VARCHAR", (DataType)DATATYPE_LONG, OracleDatabaseImpl.class);
            dtr.registerSynonym("VARCHAR", (DataType)DATATYPE_VARCHAR2, OracleDatabaseImpl.class);
            dtr.registerSynonym("DEC", (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            dtr.registerSynonym("DECIMAL", (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            dtr.registerSynonym("NUMERIC", (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            NumericDataType SYNONYM_INT = new NumericDataType(1, "INT", MIN_MAX_INT);
            NumericDataType SYNONYM_INTEGER = new NumericDataType(1, "INTEGER", MIN_MAX_INT);
            NumericDataType SYNONYM_SMALLINT = new NumericDataType(1, "SMALLINT", MIN_MAX_INT);
            NumericDataType SYNONYM_REAL = new NumericDataType(1, "REAL", MIN_MAX_FLOAT);
            NumericDataType SYNONYM_DOUBLE_PRECISION = new NumericDataType(1, "DOUBLE PRECISION", MIN_MAX_FLOAT);
            dtr.registerSynonym((DataType)SYNONYM_INT, (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_INTEGER, (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_SMALLINT, (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_REAL, (DataType)DATATYPE_FLOAT, OracleDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_DOUBLE_PRECISION, (DataType)DATATYPE_FLOAT, OracleDatabaseImpl.class);
        }
    }
}

