/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.db.ora.Oracle10gR2XE;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.Oracle11gR2;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleDatabaseLiteDescriptor;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.OracleLite10gR3;
import oracle.javatools.util.ModelUtil;

public class OracleDatabaseFactory
extends BaseDatabaseCreator {
    private static boolean s_autocommit = true;
    private Map<String, DatabaseDescriptor> m_descriptors = new HashMap<String, DatabaseDescriptor>();
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*";

    public OracleDatabaseFactory() {
        this.registerProviderClass(OracleLite.class, DBArb.getString((int)424), (DataTypeRegistry.Registerer)new OracleLite.OracleLiteRegisterer());
        this.registerProviderClass(OracleLite10gR3.class, DBArb.getString((int)425), null);
        this.registerProviderClass(OracleDatabaseImpl.class, null, (DataTypeRegistry.Registerer)new OracleDatabaseImpl.Registerer());
        this.registerProviderClass(Oracle8.class, null, (DataTypeRegistry.Registerer)new Oracle8.Registerer());
        this.registerProviderClass(Oracle8i.class, 389, (DataTypeRegistry.Registerer)new Oracle8i.Registerer());
        this.registerProviderClass(Oracle9i.class, null, (DataTypeRegistry.Registerer)new Oracle9i.Registerer());
        this.registerProviderClass(Oracle9iR2.class, 391, (DataTypeRegistry.Registerer)new Oracle9iR2.Registerer());
        this.registerProviderClass(Oracle10g.class, 392, (DataTypeRegistry.Registerer)new Oracle10g.Registerer());
        this.registerProviderClass(Oracle10gR2.class, 393, (DataTypeRegistry.Registerer)new Oracle10gR2.Registerer());
        this.registerProviderClass(Oracle10gR2XE.class, 394, (DataTypeRegistry.Registerer)new Oracle10gR2XE.Registerer());
        this.registerProviderClass(Oracle11g.class, 396, (DataTypeRegistry.Registerer)new Oracle11g.Registerer());
        this.registerProviderClass(Oracle11gR2.class, 397, (DataTypeRegistry.Registerer)new Oracle11gR2.Registerer());
    }

    public DatabaseDescriptor getDatabaseDescriptorImpl(Database db) {
        if (db instanceof OracleDatabaseImpl) {
            return new OracleDatabaseDescriptor<OracleDatabaseImpl>((OracleDatabaseImpl)db, null, null);
        }
        return super.getDatabaseDescriptorImpl(db);
    }

    public DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (OracleDatabase.class.isAssignableFrom(providerClass)) {
            OracleDatabaseDescriptor descriptor = this.m_descriptors.get(providerClass.getName());
            if (descriptor == null) {
                descriptor = OracleLite.class.isAssignableFrom(providerClass) ? new OracleDatabaseLiteDescriptor(providerClass) : new OracleDatabaseDescriptor(providerClass);
                this.m_descriptors.put(providerClass.getName(), descriptor);
            }
            return descriptor;
        }
        return null;
    }

    public Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        BaseOracleDatabase db = null;
        switch (OracleDatabaseFactory.getType(conn)) {
            case 1: {
                db = new OracleLite(connStore, connName, conn);
                break;
            }
            case 3: {
                db = new OracleLite10gR3(connStore, connName, conn);
                break;
            }
            case 81: {
                db = new Oracle8(connStore, connName, conn);
                break;
            }
            case 82: {
                db = new Oracle8i(connStore, connName, conn);
                break;
            }
            case 91: {
                db = new Oracle9i(connStore, connName, conn);
                break;
            }
            case 92: {
                db = new Oracle9iR2(connStore, connName, conn);
                break;
            }
            case 100: {
                db = new Oracle10g(connStore, connName, conn);
                break;
            }
            case 102: {
                db = new Oracle10gR2(connStore, connName, conn);
                break;
            }
            case 101: {
                db = new Oracle10gR2XE(connStore, connName, conn);
                break;
            }
            case 110: {
                db = new Oracle11g(connStore, connName, conn);
                break;
            }
            case 112: {
                db = new Oracle11gR2(connStore, connName, conn);
                break;
            }
            default: {
                db = null;
            }
        }
        if (db != null) {
            this.initDB((Database)db);
        }
        return db;
    }

    private void initDB(Database db) {
        ConnectionWrapper wrap = new ConnectionWrapper(db, DBArb.getString((int)433));
        try {
            wrap.run(new ConnectionWrapper.SQLRunnable(wrap){

                public void run() throws SQLException {
                    this.getConnection().setAutoCommit(s_autocommit);
                }
            });
        }
        catch (DBException dbe) {
            DBLog.getLogger((Object)((Object)this)).warning(dbe.getMessage());
        }
    }

    public static void setDefaultAutocommit(boolean autocommit) {
        s_autocommit = autocommit;
    }

    public static boolean isDefaultAutocommit() {
        return s_autocommit;
    }

    public static boolean isOracleDatabase(Connection conn) {
        int type = OracleDatabaseFactory.getType(conn);
        return type > -1 && type <= 112;
    }

    private static boolean isExpressEdition(String ver) {
        return ver.indexOf("Express Edition") >= 0;
    }

    private static int getType(Connection conn) {
        int type = -1;
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                if (ModelUtil.hasLength((String)dbName)) {
                    if (dbName.startsWith("Oracle Lite") || dbName.startsWith("Oracle9i Lite")) {
                        type = 1;
                    } else if (dbName.startsWith("Personal Oracle") || dbName.startsWith("Oracle") && !dbName.startsWith("Oracle Rdb") && !dbName.startsWith("Oracle Business Intelligence")) {
                        type = 0;
                        String ver = dmd.getDatabaseProductVersion();
                        int[] version = OracleDatabaseFactory.getOracleMajorMinorVersion(ver);
                        if (version != null && version.length == 2) {
                            int major = version[0];
                            int minor = version[1];
                            if (major < 8) {
                                type = 0;
                            } else if (major == 8) {
                                type = minor >= 1 ? 82 : 81;
                            } else if (major == 9) {
                                type = minor >= 2 ? 92 : 91;
                            } else if (major == 10) {
                                type = minor < 2 ? 100 : (OracleDatabaseFactory.isExpressEdition(ver) ? 101 : 102);
                            } else if (major >= 11) {
                                type = minor < 2 ? 110 : 112;
                            }
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return type;
    }

    public static int[] getOracleMajorMinorVersion(String dbVersion) {
        if (ModelUtil.hasLength((String)dbVersion)) {
            String num;
            Pattern pattern = Pattern.compile(VERSION_PATTERN);
            Matcher matcher = pattern.matcher(dbVersion);
            String string = num = matcher.find() ? matcher.group() : null;
            if (ModelUtil.hasLength((String)num)) {
                int major = 8;
                int minor = 0;
                int idx = num.indexOf(46);
                if (idx != -1) {
                    try {
                        major = Integer.parseInt(num.substring(0, idx));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    int start = idx + 1;
                    idx = num.indexOf(46, start);
                    if (idx != -1) {
                        try {
                            minor = Integer.parseInt(num.substring(start, idx));
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                }
                return new int[]{major, minor};
            }
        }
        return null;
    }
}

