/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.TimeStampTZDataType;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.resource.OracleTypesBundle;

public class Oracle9i
extends Oracle8i {
    protected static final DataTypeAttribute fractionalPrecision = new DataTypeAttribute("scale", 161, 0L, LONG_9, LONG_6, false);

    Oracle9i(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        private static final String[] XDB_INDEXTYPES = new String[]{"PATH_INDEX", "XDBHI_IDTYP"};

        Registerer() {
        }

        protected void registerDataTypes(DataTypeRegistry dtr) {
            DataTypeAttribute unit = new DataTypeAttribute("unit", 164, new String[]{"BYTE", "CHAR"}, null, false, false);
            DataTypeAttribute timeZone = new DataTypeAttribute("time_zone", 160, new String[]{"TIME ZONE", "LOCAL TIME ZONE"}, null, false, false);
            TimeStampTZDataType DATATYPE_TIMESTAMP_TZ = new TimeStampTZDataType(1, "TIMESTAMP", "TIMESTAMP[(<scale>)][ WITH <time_zone>]", new DataTypeAttribute[]{fractionalPrecision, timeZone});
            CharacterDataType DATATYPE_CHAR = new CharacterDataType(1, "CHAR", "CHAR[(<size>[ <unit>])]", 1L, 2000L, 1L, false, new DataTypeAttribute[]{unit});
            CharacterDataType DATATYPE_VARCHAR2 = new CharacterDataType(1, "VARCHAR2", "VARCHAR2(<size>[ <unit>])", 1L, 4000L, 20L, true, new DataTypeAttribute[]{unit});
            dtr.registerDataType((DataType)DATATYPE_CHAR, Oracle9i.class);
            dtr.registerDataType((DataType)DATATYPE_VARCHAR2, Oracle9i.class);
            dtr.registerDataType((DataType)DATATYPE_TIMESTAMP_TZ, Oracle9i.class);
            dtr.registerSynonym("CHARACTER", (DataType)DATATYPE_CHAR, Oracle9i.class);
            dtr.registerSynonym("CHAR VARYING", (DataType)DATATYPE_VARCHAR2, Oracle9i.class);
            dtr.registerSynonym("CHARACTER VARYING", (DataType)DATATYPE_VARCHAR2, Oracle9i.class);
            dtr.registerSynonym("VARCHAR", (DataType)DATATYPE_VARCHAR2, Oracle9i.class);
        }

        protected static void registerSysTypes(DataTypeRegistry dtr, Class providerClass) {
            Schema sys = Oracle8i.getBuiltInSchema("SYS");
            Oracle8i.registerComplexType(dtr, providerClass, sys, OracleTypesBundle.get("TYPE_DBURITYPE_NAME"), OracleTypesBundle.get("TYPE_DBURITYPE_SPEC"));
            Oracle8i.registerComplexType(dtr, providerClass, sys, OracleTypesBundle.get("TYPE_HTTPURITYPE_NAME"), OracleTypesBundle.get("TYPE_HTTPURITYPE_SPEC"));
            Oracle8i.registerComplexType(dtr, providerClass, sys, OracleTypesBundle.get("TYPE_URITYPE_NAME"), OracleTypesBundle.get("TYPE_URITYPE_SPEC"));
            Oracle8i.registerComplexType(dtr, providerClass, sys, OracleTypesBundle.get("TYPE_XDBURITYPE_NAME"), OracleTypesBundle.get("TYPE_XDBURITYPE_SPEC"));
            Oracle8i.registerComplexType(dtr, providerClass, sys, OracleTypesBundle.get("TYPE_XMLTYPE_NAME"), OracleTypesBundle.get("TYPE_XMLTYPE_SPEC"));
            Oracle8i.registerComplexType(dtr, providerClass, sys, OracleTypesBundle.get("TYPE_ANYDATA_NAME"), OracleTypesBundle.get("TYPE_ANYDATA_SPEC"));
            Oracle8i.registerComplexType(dtr, providerClass, sys, OracleTypesBundle.get("TYPE_ANYDATASET_NAME"), OracleTypesBundle.get("TYPE_ANYDATASET_SPEC"));
            Oracle8i.registerComplexType(dtr, providerClass, sys, OracleTypesBundle.get("TYPE_ANYTYPE_NAME"), OracleTypesBundle.get("TYPE_ANYTYPE_SPEC"));
        }

        protected void registerComplexTypes(DataTypeRegistry dtr) {
            long millis = System.currentTimeMillis();
            Schema mdsys = Oracle8i.getBuiltInSchema("MDSYS");
            Schema ordsys = Oracle8i.getBuiltInSchema("ORDSYS");
            Registerer.registerSysTypes(dtr, Oracle9i.class);
            Oracle8i.registerComplexType(dtr, Oracle9i.class, ordsys, OracleTypesBundle.get("TYPE_ORDDOC_NAME"), OracleTypesBundle.get("TYPE_ORDDOC_SPEC"));
            Oracle8i.registerComplexType(dtr, Oracle9i.class, ordsys, OracleTypesBundle.get("TYPE_ORDIMAGESIGNATURE_NAME"), OracleTypesBundle.get("TYPE_ORDIMAGESIGNATURE_SPEC"));
            millis = System.currentTimeMillis() - millis;
            DBLog.log((String)"Registering Oracle9i built in complex types {0}ms", (Object[])new Object[]{Long.toString(millis)});
        }

        static {
            OracleDatabaseImpl.registerBuiltInIndextypes(Oracle9i.class, "XDB", XDB_INDEXTYPES);
        }
    }
}

