/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleTablespaceBuilder;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.db.ora.RecycledObjectBuilder;
import oracle.javatools.db.ora.resource.OracleTypesBundle;

public class Oracle10g
extends Oracle9iR2 {
    Oracle10g(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("RECYCLEBIN", (DBObjectBuilder)new RecycledObjectBuilder(this));
        this.registerBuilder("TABLESPACE", (DBObjectBuilder)new OracleTablespaceBuilder(this));
    }

    protected void finishDelete(Schema schema, SchemaObject[] objs) {
        super.finishDelete(schema, (SystemObject[])objs);
        ArrayList<SchemaObject> undropped = new ArrayList<SchemaObject>();
        for (SchemaObject so : objs) {
            if (!(so instanceof RecycledObject)) continue;
            try {
                String name = ((RecycledObject)so).getOriginalName();
                String type = ((RecycledObject)so).getOriginalType();
                SchemaObject ud = this.getObject(type, schema, name);
                if (ud == null) continue;
                undropped.add(ud);
            }
            catch (DBException dbe) {
                DBLog.logStackTrace((Throwable)dbe);
            }
        }
        if (undropped.size() > 0) {
            this.fireObjectsAdded(schema, undropped.toArray(new SchemaObject[undropped.size()]));
        }
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        private static final String[] XDB_INDEXTYPES = new String[]{"XDBHI_IDTYP", "XMLINDEX"};
        private static final String[] EFXSYS_INDEXTYPES = new String[]{"EXPFILTER"};

        Registerer() {
        }

        protected void registerDataTypes(DataTypeRegistry dtr) {
            dtr.registerDataType((DataType)new NumericDataType(1, "BINARY_DOUBLE", new NumericDataType.MinMaxValue("2.3e-308", "1.79e+308", 2)), Oracle10g.class);
            dtr.registerDataType((DataType)new NumericDataType(1, "BINARY_FLOAT", new NumericDataType.MinMaxValue("1.2e-38", "3.4e+38", 2)), Oracle10g.class);
        }

        protected void registerComplexTypes(DataTypeRegistry dtr) {
            long millis = System.currentTimeMillis();
            Schema mdsys = Oracle8i.getBuiltInSchema("MDSYS");
            Schema ordsys = Oracle8i.getBuiltInSchema("ORDSYS");
            Oracle8i.registerComplexType(dtr, Oracle10g.class, mdsys, OracleTypesBundle.get("TYPE_SDO_GEORASTER_NAME"), OracleTypesBundle.get("TYPE_SDO_GEORASTER_SPEC"));
            Oracle8i.registerComplexType(dtr, Oracle10g.class, ordsys, OracleTypesBundle.get("TYPE_SI_AVERAGECOLOR_NAME"), OracleTypesBundle.get("TYPE_SI_AVERAGECOLOR_SPEC"));
            Oracle8i.registerComplexType(dtr, Oracle10g.class, ordsys, OracleTypesBundle.get("TYPE_SI_COLOR_NAME"), OracleTypesBundle.get("TYPE_SI_COLOR_SPEC"));
            Oracle8i.registerComplexType(dtr, Oracle10g.class, ordsys, OracleTypesBundle.get("TYPE_SI_COLORHISTOGRAM_NAME"), OracleTypesBundle.get("TYPE_SI_COLORHISTOGRAM_SPEC"));
            Oracle8i.registerComplexType(dtr, Oracle10g.class, ordsys, OracleTypesBundle.get("TYPE_SI_FEATURELIST_NAME"), OracleTypesBundle.get("TYPE_SI_FEATURELIST_SPEC"));
            Oracle8i.registerComplexType(dtr, Oracle10g.class, ordsys, OracleTypesBundle.get("TYPE_SI_POSITIONALCOLOR_NAME"), OracleTypesBundle.get("TYPE_SI_POSITIONALCOLOR_SPEC"));
            Oracle8i.registerComplexType(dtr, Oracle10g.class, ordsys, OracleTypesBundle.get("TYPE_SI_STILLIMAGE_NAME"), OracleTypesBundle.get("TYPE_SI_STILLIMAGE_SPEC"));
            Oracle8i.registerComplexType(dtr, Oracle10g.class, ordsys, OracleTypesBundle.get("TYPE_SI_TEXTURE_NAME"), OracleTypesBundle.get("TYPE_SI_TEXTURE_SPEC"));
            millis = System.currentTimeMillis() - millis;
            DBLog.log((String)"Registering Oracle10g built in complex types {0}ms", (Object[])new Object[]{Long.toString(millis)});
        }

        static {
            OracleDatabaseImpl.registerBuiltInIndextypes(Oracle10g.class, "EFXSYS", EFXSYS_INDEXTYPES);
            OracleDatabaseImpl.registerBuiltInIndextypes(Oracle10g.class, "XDB", XDB_INDEXTYPES);
        }
    }
}

