/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleQueryWrapper;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.util.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializedViewLogBuilder
extends OracleDBObjectBuilder<MaterializedViewLog> {
    MaterializedViewLogBuilder(BaseOracleDatabase db) {
        super(db, "MATERIALIZED VIEW LOG");
    }

    public MaterializedViewLog createObject(String name, Schema schema, DBObjectID id) {
        MaterializedViewLog obj = new MaterializedViewLog(name, schema);
        obj.setID(id);
        return obj;
    }

    private static Boolean parseBoolean(String s) {
        return "Y".equals(s.trim()) || "YES".equals(s.trim()) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean canBuildComponents() {
        return true;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"masterTableID", "logTable", "rowidLogged", "primaryKeyLogged", "objectIdLogged", "sequenceLogged", "newValues", "cache", "parallel", "OracleStorageProperties"})
    public void fillInBaseProperties(final MaterializedViewLog log) throws DBException {
        final QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_OBJECT_QUERY*/\n       L.MASTER, L.LOG_TABLE, L.ROWIDS, L.PRIMARY_KEY, \n       L.OBJECT_ID, L.SEQUENCE, L.INCLUDE_NEW_VALUES, \n       T.CACHE, T.DEGREE \nFROM SYS.ALL_SNAPSHOT_LOGS L, \n     SYS.ALL_TABLES T \nWHERE T.TABLE_NAME = L.LOG_TABLE \nAND   T.OWNER = L.LOG_OWNER \nAND   L.LOG_OWNER = ''{0}'' AND L.MASTER = ''{1}''", log.getSchema(), log);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                block10: {
                    try {
                        if (!rs.next()) break block10;
                        int index = 1;
                        SchemaObject obj = null;
                        String masterTableName = rs.getString(index++);
                        try {
                            obj = MaterializedViewLogBuilder.this.getDatabase().getObject("TABLE", log.getSchema(), masterTableName);
                        }
                        catch (DBException e) {
                            return;
                        }
                        if (obj == null) {
                            try {
                                obj = MaterializedViewLogBuilder.this.getDatabase().getObject("MATERIALIZED VIEW", log.getSchema(), masterTableName);
                            }
                            catch (DBException e) {
                                return;
                            }
                        }
                        if (obj != null) {
                            log.setMasterTableID(obj.getID());
                        }
                        log.setLogTable(rs.getString(index++));
                        log.setRowidLogged(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        log.setPrimaryKeyLogged(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        log.setObjectIdLogged(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        log.setSequenceLogged(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        log.setNewValues(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        log.setCache(MaterializedViewLogBuilder.parseBoolean(rs.getString(index++)));
                        String sParallel = rs.getString(index++).trim();
                        if ("DEFAULT".equals(sParallel)) {
                            log.setParallel(0);
                        } else {
                            log.setParallel(Integer.valueOf(sParallel).intValue());
                        }
                    }
                    catch (SQLException ex) {
                        wrap.throwDBException(ex);
                    }
                }
            }
        };
        wrap.executeQuery(r);
        final QueryWrapper wrap2 = this.newQueryWrapper(this.getTableQuery(), log.getSchema(), log.getLogTable());
        QueryWrapper.QueryRunnable r2 = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        OracleStorageProperties osp = OracleTableBuilder.getSegmentAttributeProperties(rs, MaterializedViewLogBuilder.this.getDatabase());
                        log.setProperty("OracleStorageProperties", (Object)osp);
                    }
                }
                catch (SQLException ex) {
                    wrap2.throwDBException((DBObject)log, ex);
                }
            }
        };
        wrap2.executeQuery(r2);
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"columnIDs"}, depends={"masterTableID"})
    public void fillInColumns(final MaterializedViewLog log) throws DBException {
        final QueryWrapper colsWrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_COLUMNS_QUERY*/\n       TC.COLUMN_NAME\nFROM   ALL_SNAPSHOT_LOGS MVL\n,      ALL_TAB_COLS TC\nWHERE  TC.OWNER = MVL.LOG_OWNER\nAND    TC.TABLE_NAME = MVL.LOG_TABLE\nAND    MVL.LOG_OWNER = ? \nAND    MVL.MASTER = ?\nAND EXISTS ( SELECT 1\n             FROM   ALL_TAB_COLS TC2\n             ,      ALL_TABLES T\n             WHERE  T.OWNER = TC.OWNER\n             AND    TC2.OWNER = TC.OWNER\n             AND    TC2.TABLE_NAME = MVL.MASTER\n             AND    TC2.COLUMN_NAME = TC.COLUMN_NAME )\nAND NOT EXISTS ( SELECT 1\n                 FROM   ALL_CONS_COLUMNS CC\n                 ,      ALL_CONSTRAINTS C\n                 WHERE  C.CONSTRAINT_NAME = CC.CONSTRAINT_NAME\n                 AND    C.CONSTRAINT_TYPE = 'P'\n                 AND    C.OWNER = TC.OWNER\n                 AND    CC.OWNER = TC.OWNER\n                 AND    C.TABLE_NAME = MVL.MASTER\n                 AND    CC.COLUMN_NAME = TC.COLUMN_NAME)\nORDER BY TC.COLUMN_ID\n", log.getSchema(), log);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    ArrayList<NameBasedID> columnIDs = new ArrayList<NameBasedID>();
                    while (rs.next()) {
                        NameBasedID refID = new NameBasedID("COLUMN", rs.getString(1), log.getMasterTableID());
                        columnIDs.add(refID);
                    }
                    log.setColumnIDs(columnIDs.toArray(new DBObjectID[columnIDs.size()]));
                }
                catch (SQLException sqe) {
                    colsWrap.throwDBException(sqe);
                }
            }
        };
        colsWrap.executeQuery(r);
    }

    private String getTableQuery() {
        String query = null;
        switch (this.getDatabase().getDatabaseVersion()) {
            case 1: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_OLITE_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING,\n       null BUFFER_POOL, null COMPRESSION, null DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            case 0: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE7_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, null LOGGING, null BUFFER_POOL, null COMPRESSION, 1 DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            case 81: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_ORACLE8_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, null COMPRESSION, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
                break;
            }
            default: {
                query = "SELECT /*OracleDictionaryQueries.ALL_TABLE_PROPERTIES_QUERY(ALL_TABLES)*/\n       TABLESPACE_NAME, PCT_FREE, PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENTS, MAX_EXTENTS, PCT_INCREASE,\n       FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL, COMPRESSION, DEGREE\nFROM  SYS.ALL_TABLES\nWHERE OWNER = ? AND TABLE_NAME = ?";
            }
        }
        return query;
    }

    public static String getCandidateTablesQuery() {
        return "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_CANDIDATE_TABLES_QUERY*/\n       T.TABLE_NAME \n,      DECODE(MV.MVIEW_NAME,null,'TABLE','MATERIALIZED VIEW') OBJECT_TYPE\n,     (SELECT O.OBJECT_ID\n       FROM   ALL_OBJECTS O \n       WHERE  O.OWNER = T.OWNER \n       AND    O.OBJECT_TYPE = 'TABLE' \n       AND    O.OBJECT_NAME = T.TABLE_NAME) OBJECT_ID \nFROM   ALL_TABLES T \n,      ALL_MVIEWS MV\nWHERE  T.OWNER = ? \nAND    T.TEMPORARY = 'N' \nAND    T.NESTED = 'NO' \nAND    T.IOT_NAME IS NULL \nAND    T.SECONDARY = 'N'\nAND    MV.MVIEW_NAME (+) = T.TABLE_NAME\nAND    MV.OWNER (+) = T.OWNER\nAND    NOT EXISTS (SELECT 1 \n                   FROM   ALL_SNAPSHOT_LOGS L   \n                   WHERE  (L.MASTER = T.TABLE_NAME OR \n                           L.LOG_TABLE = T.TABLE_NAME) \n                   AND    L.LOG_OWNER = T.OWNER) \nAND    NOT EXISTS (SELECT 1 \n                   FROM   ALL_EXTERNAL_TABLES E \n                   WHERE  E.TABLE_NAME = T.TABLE_NAME \n                   AND    E.OWNER = T.OWNER)\nORDER BY 1";
    }

    public static String getMVLForTableQuery() {
        return "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_QUERY*/\n       L.MASTER, 'MATERIALIZED VIEW LOG', NULL\nFROM SYS.ALL_SNAPSHOT_LOGS L\nWHERE L.LOG_OWNER = ? AND L.MASTER LIKE ?\n";
    }

    public static String getMasterTableFromLogTable(DBObjectProvider pro, Schema schema, String logTableName) {
        if (pro instanceof BaseOracleDatabase) {
            String masterTableName;
            MaterializedViewLog mvl;
            BaseOracleDatabase db = (BaseOracleDatabase)pro;
            if (logTableName.indexOf("MLOG$_") == 0 && (mvl = (MaterializedViewLog)db.findObject("MATERIALIZED VIEW LOG", schema, masterTableName = logTableName.replace("MLOG$_", ""))) != null && logTableName.equals(mvl.getLogTable())) {
                return masterTableName;
            }
            final Holder holder = new Holder();
            final OracleQueryWrapper wrap = new OracleQueryWrapper(db, "SELECT /*OracleDictionaryQueries.ALL_MVIEW_LOG_DEF_QUERY*/\n       UNIQUE MASTER, ROWIDS, PRIMARY_KEY, FILTER_COLUMNS FROM SYS.ALL_SNAPSHOT_LOGS WHERE LOG_OWNER = ? AND LOG_TABLE = ?", schema, logTableName);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            holder.set((Object)rs.getString(1));
                        }
                    }
                    catch (SQLException ex) {
                        wrap.throwDBException(ex);
                    }
                }
            };
            try {
                wrap.executeQuery(r);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Error querying mviewlog table for " + logTableName, dbe);
            }
            return (String)holder.get();
        }
        return null;
    }
}

