/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatabaseLinkBuilder
extends OracleDBObjectBuilder<DatabaseLink> {
    DatabaseLinkBuilder(BaseOracleDatabase db) {
        super(db, "DATABASE LINK");
    }

    public DatabaseLink createObject(String name, Schema schema, DBObjectID id) {
        DatabaseLink dbl = new DatabaseLink(name, schema, id);
        dbl.setPublic(this.getDatabase().isPublicSchema(schema));
        return dbl;
    }

    protected void fillInObject(final DatabaseLink dblink) throws DBException {
        final QueryWrapper wrap = this.newQueryWrapper(this.getQuery(), dblink, dblink.getSchema());
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    if (rs.next()) {
                        String username = rs.getString(1);
                        if ("CURRENT_USER".equals(username)) {
                            dblink.setCurrentUser(true);
                        } else {
                            dblink.setUsername(username);
                        }
                        String host = rs.getString(2);
                        dblink.setHost(host);
                        String created = rs.getString(3);
                        dblink.setCreated(created);
                        String authusr = rs.getString(4);
                        if (authusr != null) {
                            dblink.setShared(true);
                            dblink.setAuthentificationUsername(authusr);
                        }
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)dblink, ex);
                }
            }
        };
        wrap.executeQuery(r);
    }

    private String getQuery() {
        return "WITH API AS (SELECT ? NAME \n             ,      (SELECT SUBSTR(GLOBAL_NAME,INSTR(GLOBAL_NAME,'.')) FROM GLOBAL_NAME) GNAME\n             ,      DBL2.DB_LINK\n             ,      DBL2.OWNER\n             ,      TO_CHAR(DBMS_METADATA.GET_XML('DB_LINK',DBL2.DB_LINK,DBL2.OWNER)) XML\n             FROM   ALL_DB_LINKS DBL2)\nSELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_QUERY*/\n       DBL.USERNAME, DBL.HOST, DBL.CREATED,\n       DECODE(INSTR(A.XML,'<AUTHUSR>'),0,NULL,\n              SUBSTR(A.XML,INSTR(A.XML,'<AUTHUSR>')+9,\n              INSTR(A.XML,'</AUTHUSR>')-INSTR(A.XML,'<AUTHUSR>')-9)) AUTHUSR\nFROM  API A\n,     ALL_DB_LINKS DBL\nWHERE DBL.OWNER = A.OWNER\nAND   DBL.DB_LINK = A.DB_LINK\nAND   DBL.OWNER = ?\nAND   ( DBL.DB_LINK = A.NAME OR DBL.DB_LINK = A.NAME||A.GNAME )";
    }
}

