/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DBSourceBuilder<T extends AbstractBuildableObject>
extends OracleDBObjectBuilder<T> {
    DBSourceBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
    }

    protected abstract String getQuery();

    protected final String getSource(SourceObject src) throws DBException {
        return this.getSourceImpl(src, false);
    }

    protected final String getBodySource(SpecPlSql src) throws DBException {
        return this.getSourceImpl((SourceObject)src, true);
    }

    private final String getSourceImpl(final SourceObject src, boolean body) throws DBException {
        if (body && !(src instanceof SpecPlSql)) {
            throw new IllegalArgumentException("Cannot query for the body of an object that has no body");
        }
        final StringBuffer buf = new StringBuffer();
        String type = this.getObjectType() + (body ? " BODY" : "");
        final QueryWrapper wrap = this.newQueryWrapper(this.getQuery(), type, src.getSchema(), src);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String line = rs.getString(1);
                        if (line != null) {
                            buf.append(line);
                            if (line.endsWith("\n")) continue;
                            buf.append('\n');
                            continue;
                        }
                        buf.append('\n');
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException((DBObject)src, ex);
                }
            }
        };
        wrap.executeQuery(r);
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }
}

