/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;
import oracle.javatools.db.mysql.MySQL5;
import oracle.javatools.db.mysql.MySQLColumnValidator;
import oracle.javatools.db.mysql.MySQLConstraintValidator;
import oracle.javatools.db.mysql.MySQLDDLGenerator;
import oracle.javatools.db.mysql.MySQLDatabase;
import oracle.javatools.db.mysql.MySQLIndexValidator;
import oracle.javatools.db.property.PropertyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDatabaseDescriptor<T extends MySQLDatabase>
extends JdbcDatabaseDescriptor<T> {
    public static final int MAX_NAME_LENGTH = 255;
    public static final char QUOTE_IDENTIFIER = '`';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ACCESSIBLE", "ADD", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ASENSITIVE", "BEFORE", "BETWEEN", "BIGINT", "BINARY", "BLOB", "BOTH", "BY", "CALL", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONDITION", "CONNECTION", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE  CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR  DATABASE", "DATABASES", "DAY_HOUR", "DAY_MICROSECOND", "DAY_MINUTE", "DAY_SECOND", "DEC", "DECIMAL", "DECLARE ", "DEFAULT", "DELAYED", "DELETE  DESC", "DESCRIBE", "DETERMINISTIC", "DISTINCT", "DISTINCTROW", "DIV", "DOUBLE", "DROP", "DUAL", "EACH", "ELSE", "ELSEIF", "ENCLOSED", "ESCAPED", "EXISTS", "EXIT", "EXPLAIN", "FALSE", "FETCH", "FLOAT", "FLOAT4", "FLOAT8", "FOR", "FORCE", "FOREIGN", "FROM", "FULLTEXT", "GOTO", "GRANT", "GROUP", "HAVING", "HIGH_PRIORITY", "HOUR_MICROSECOND", "HOUR_MINUTE", "HOUR_SECOND", "IF", "IGNORE", "IN", "INDEX", "INFILE", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT3", "INT4", "INT8", "INTEGER", "INTERVAL", "INTO", "IS", "ITERATE", "JOIN", "KEY", "KEYS", "KILL", "LABEL", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LINEAR", "LINES", "LOAD", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", "LONGBLOB", "LONGTEXT", "LOOP", "LOW_PRIORITY", "MASTER_SSL_VERIFY_SERVER_CERT", "MATCH", "MEDIUMBLOB", "MEDIUMINT", "MEDIUMTEXT", "MIDDLEINT", "MINUTE_MICROSECOND", "MINUTE_SECOND", "MOD", "MODIFIES", "NATURAL", "NOT", "NO_WRITE_TO_BINLOG", "NULL", "NUMERIC", "ON", "OPTIMIZE", "OPTION", "OPTIONALLY", "OR", "ORDER", "OUT", "OUTER", "OUTFILE", "PRECISION", "PRIMARY", "PROCEDURE", "PURGE", "RANGE", "READ", "READS", "READ_ONLY", "READ_WRITE", "REAL", "REFERENCES", "REGEXP", "RELEASE", "RENAME", "REPEAT", "REPLACE", "REQUIRE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "RLIKE", "SCHEMA", "SCHEMAS", "SECOND_MICROSECOND", "SELECT", "SENSITIVE", "SEPARATOR", "SET", "SHOW", "SMALLINT", "SPATIAL", "SPECIFIC", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIG_RESULT", "SQL_CALC_FOUND_ROWS", "SQL_SMALL_RESULT", "SSL", "STARTING", "STRAIGHT_JOIN", "TABLE", "TERMINATED", "THEN", "TINYBLOB", "TINYINT", "TINYTEXT", "TO", "TRAILING", "TRIGGER", "TRUE", "UNDO", "UNION", "UNIQUE", "UNLOCK", "UNSIGNED", "UPDATE", "UPGRADE", "USAGE", "USE", "USING", "UTC_DATE", "UTC_TIME", "UTC_TIMESTAMP", "VALUES", "VARBINARY", "VARCHAR", "VARCHARACTER", "VARYING", "WHEN", "WHERE", "WHILE", "WITH", "WRITE", "XOR", "YEAR_MONTH", "ZEROFILL"));

    public MySQLDatabaseDescriptor(Class<? extends T> clz) {
        super(clz);
    }

    @Override
    public int getCasePolicy() {
        return 3;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('`');
    }

    @Override
    public int getMaxNameLength(String type) {
        return 255;
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        if ("CONSTRAINT".equals(type) && "PRIMARY".equals(name)) {
            return;
        }
        MySQLDatabaseDescriptor.validateIdentifier((String)name, (char)'`', (int)255, (String)"_$", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy());
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        v.put("INDEX", new MySQLIndexValidator(pro));
        v.put("COLUMN", new MySQLColumnValidator(pro));
        v.put("CONSTRAINT", new MySQLConstraintValidator(pro));
        return v;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new MySQLDDLGenerator(pro);
    }

    @Override
    public String getDatabaseType() {
        return "MySQL";
    }

    @Override
    public int getDatabaseVersion() {
        int retval = 0;
        Class clz = this.getDatabaseClass();
        if (MySQL5.class.isAssignableFrom(clz)) {
            retval = 1;
        }
        return retval;
    }

    @Override
    public List<PropertyInitializer> getPropertyInitializers(DBObjectProvider pro) {
        List<PropertyInitializer> pdpList = super.getPropertyInitializers(pro);
        pdpList.add(new MySQLDefaultsInitializer(pro));
        return pdpList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MySQLDefaultsInitializer
    extends PropertyInitializer {
        private static String[] s_names = new String[]{"name"};
        private static String[] s_empty = new String[0];

        MySQLDefaultsInitializer(DBObjectProvider pro) {
            super(pro);
        }

        public String[] getPropertyNames(Class<? extends DBObject> clz) {
            if (PKConstraint.class.isAssignableFrom(clz)) {
                return s_names;
            }
            return s_empty;
        }

        public Object getPropertyInitialValue(DBObject obj, String propertyName) throws PropertyInitializer.InitializationVeto {
            String retval = null;
            if (obj instanceof PKConstraint && "name".equals(propertyName)) {
                retval = "PRIMARY";
            }
            return retval;
        }
    }
}

