/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import oracle.javatools.db.marshal.PartialParseCompleteException;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SingleElementHandler
extends DefaultHandler {
    private String m_targetElement;
    private StringBuilder m_buff;

    public SingleElementHandler(String elemName) {
        if (!ModelUtil.hasLength((String)elemName)) {
            throw new IllegalArgumentException("SingleElementHandler must have an element name");
        }
        this.m_targetElement = elemName;
    }

    public void startElement(String nsURI, String localName, String qName, Attributes attributes) {
        if (this.m_targetElement.equals(localName)) {
            this.m_buff = new StringBuilder();
        }
    }

    public void characters(char[] text, int s, int l) throws SAXException {
        if (this.m_buff != null) {
            this.m_buff.append(new String(text, s, l));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.m_buff != null) {
            throw new PartialParseCompleteException();
        }
    }

    public String getValue() {
        return this.m_buff == null ? null : this.m_buff.toString();
    }

    public boolean wasElementFound() {
        return this.m_buff != null;
    }
}

