/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.marshal.PartialParseCompleteException;
import oracle.javatools.db.marshal.PartialParseUnsupportedException;
import oracle.javatools.db.marshal.SingleElementHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBObjectXMLHandler {
    private static final String UTF8_ENCODING = "UTF-8";
    private String m_namespace;

    public DBObjectXMLHandler(String namespace) {
        this.m_namespace = namespace;
    }

    public final String getNamespace() {
        return this.m_namespace;
    }

    protected String getEncoding() {
        return UTF8_ENCODING;
    }

    public final void write(DBObject obj, OutputStream out) throws IOException {
        this.write(obj, new OutputStreamWriter(out, this.getEncoding()));
    }

    public abstract void write(DBObject var1, Writer var2) throws IOException;

    public final DBObject read(InputStream in, DBObjectProvider pro) throws IOException {
        return this.read(new InputStreamReader(in, this.getEncoding()), pro);
    }

    public abstract DBObject read(Reader var1, DBObjectProvider var2) throws IOException;

    public final DBObject readInfo(InputStream in, DBObjectProvider pro) throws IOException, PartialParseUnsupportedException {
        return this.readInfo(new InputStreamReader(in, this.getEncoding()), pro);
    }

    public DBObject readInfo(Reader reader, DBObjectProvider pro) throws IOException, PartialParseUnsupportedException {
        throw new PartialParseUnsupportedException();
    }

    public final Map<String, Object> readPropertyValues(InputStream in, Collection<String> propPaths, DBObjectProvider pro) throws IOException, PartialParseUnsupportedException {
        return this.readPropertyValues(new InputStreamReader(in, this.getEncoding()), propPaths, pro);
    }

    public Map<String, Object> readPropertyValues(Reader reader, Collection<String> propPaths, DBObjectProvider pro) throws IOException, PartialParseUnsupportedException {
        throw new PartialParseUnsupportedException();
    }

    protected final String readElementValue(Reader reader, String elementName) throws IOException {
        SingleElementHandler handler = new SingleElementHandler(elementName);
        this.read(reader, handler, true);
        return handler.getValue();
    }

    protected final void read(Reader reader, DefaultHandler helper, boolean allowPartialParse) throws IOException {
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            SAXParser parser = f.newSAXParser();
            parser.parse(new InputSource(reader), helper);
        }
        catch (PartialParseCompleteException e) {
            if (!allowPartialParse) {
                throw new IllegalStateException("parser quit after name and id but we didn't request that.");
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Error parsing file: " + e.getMessage());
        }
        catch (SAXException e) {
            IOException ioe = new IOException("Error parsing file: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }
}

