/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.jdbc.JdbcRelationBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTableBuilder<T extends Table>
extends JdbcRelationBuilder<T> {
    public JdbcTableBuilder(JdbcDatabase db, String catalog) {
        super(db, catalog, "TABLE");
    }

    @Override
    public void fillInObject(Table object) throws DBException {
        super.fillInObject((Relation)object);
        this.buildIndexes(object);
    }

    @Override
    protected T createRelation(Schema schema, String name) {
        Table table = new Table(name, schema);
        table.setProperty("TableType", (Object)Table.TableType.NORMAL);
        return (T)table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildIndexes(Table table) throws DBException {
        HashMap<String, Index> idxMap = new HashMap<String, Index>();
        String schemaName = this.isUseSchema() && table.getSchema() != null ? table.getSchema().getName() : null;
        String catalogName = null;
        ResultSet rs = null;
        try {
            DatabaseMetaData dmd = this.getConnection().getMetaData();
            String tableName = this.getNameForDriver(table.getName());
            rs = dmd.getIndexInfo(catalogName, this.getNameForDriver(schemaName), tableName, false, false);
            while (rs.next()) {
                if (tableName == null && !rs.getString(3).equals(table.getName())) continue;
                boolean isUnique = !rs.getBoolean(4);
                String indexName = rs.getString(6);
                if (rs.getInt(7) == 0 || table.getConstraint(indexName) != null) continue;
                String colName = rs.getString(9);
                String ascDesc = rs.getString(10);
                Index index = (Index)idxMap.get(indexName);
                if (index == null) {
                    index = new Index(indexName, table);
                    idxMap.put(indexName, index);
                }
                index.setIndexType(isUnique ? Index.IndexType.UNIQUE : Index.IndexType.NORMAL);
                Column col = table.getColumn(colName);
                if (col == null) continue;
                if (ascDesc != null) {
                    ascDesc = ascDesc.equals("A") ? "ASC" : "DESC";
                }
                ColumnUsage colUsage = new ColumnUsage(col.getID());
                colUsage.setProvider((DBObjectProvider)this.getProvider());
                IndexObject io = new IndexObject((SQLFragment)colUsage, ascDesc);
                index.addColumnExpression(io);
            }
        }
        catch (SQLException ex) {
            if (!JdbcDDLDatabase.isUnsupportedOperation(ex)) {
                throw new DBException(null, "Error building object", (Throwable)ex);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
                rs = null;
            }
        }
        Collection values = idxMap.values();
        Index[] indexes = values.toArray(new Index[values.size()]);
        Arrays.sort(indexes, DBUtil.getNameComparator());
        table.setIndexes(indexes);
    }
}

