/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.Column;
import oracle.javatools.db.Relation;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.OldDBObjectDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;

public class ViewDiffer
extends OldDBObjectDiffer {
    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        boolean result = super.diff(a, b, rs, dc);
        boolean same = rs.isSame();
        SQLQuery sqa = a != null ? ((SQLQueryOwner)a).getSQLQuery() : null;
        SQLQuery sqb = b != null ? ((SQLQueryOwner)b).getSQLQuery() : null;
        String sqaText = sqa != null ? sqa.toString() : "";
        String sqbText = sqb != null ? sqb.toString() : "";
        boolean querySame = this.diffQuery(sqaText, sqbText);
        ResultSet prs = new ResultSet(rs, querySame, (Object)sqa, (Object)sqb, "SQLQuery");
        DisplayProps.setAVal(prs, sqaText);
        DisplayProps.setBVal(prs, sqbText);
        Column[] aCols = a != null ? ((Relation)a).getColumns() : null;
        Column[] bCols = b != null ? ((Relation)b).getColumns() : null;
        ResultSet crs = dc.getEngine().diff((Object[])this.toString(aCols), (Object[])this.toString(bCols)).getResult();
        crs.setName("columns");
        rs.addToMap("columns", crs);
        rs.setSame(same && querySame && crs.isSame());
        return result;
    }

    private String[] toString(Column[] cols) {
        String[] retval = new String[cols == null ? 0 : cols.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = cols[i] == null ? null : cols[i].getName();
        }
        return retval;
    }

    protected boolean isIgnoredProperty(String name) {
        return name.equals("SQLQuery") || name.equals("columns");
    }

    private boolean diffQuery(String a, String b) {
        a = a.replaceAll("\\s", "");
        b = b.replaceAll("\\s", "");
        return a.equalsIgnoreCase(b);
    }
}

