/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ListDiffer;
import oracle.javatools.db.diff.OldDBObjectDiffer;
import oracle.javatools.db.diff.ResultSet;

public class TriggerDiffer
extends OldDBObjectDiffer {
    static final String[] NOREFS = new String[]{null, null};

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        DiffEngine savede = dc.getEngine();
        DiffEngine trgde = new DiffEngine(savede);
        trgde.registerListDiffer((Differ)new ListDiffer(), DBObjectID.class);
        trgde.registerListDiffer((Differ)new ListDiffer(), String.class);
        dc.setEngine(trgde);
        super.diff(a, b, rs, dc);
        dc.setEngine(savede);
        boolean same = rs.isSame();
        String aTableName = this.getTableName((Trigger)a);
        String bTableName = this.getTableName((Trigger)b);
        boolean sameTableID = aTableName.equals(bTableName);
        if (dc.isTreeRequired() || !sameTableID) {
            ResultSet r = new ResultSet(rs, sameTableID, a, b, "tableID");
            DisplayProps.setAVal(r, aTableName);
            DisplayProps.setBVal(r, bTableName);
        }
        rs.setSame(same &= sameTableID);
        return true;
    }

    protected boolean isIgnoredProperty(String name) {
        return "referenceNames".equals(name) || "tableID".equals(name);
    }

    private String getTableName(Trigger t) {
        String name = "";
        try {
            DBObjectID tableID;
            DBObjectID dBObjectID = tableID = t != null ? t.getTableID() : null;
            if (tableID != null) {
                DBObject table;
                name = tableID instanceof ReferenceID ? ((ReferenceID)tableID).getName() : ((table = tableID.resolveID()) != null ? table.getName() : "");
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return name;
    }
}

