/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.OldDBObjectDiffer;
import oracle.javatools.db.diff.ResultSet;

public class SynonymDiffer
extends OldDBObjectDiffer {
    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        boolean result = super.diff(a, b, rs, dc);
        boolean same = rs.isSame();
        assert (null == a || a instanceof Synonym);
        assert (null == b || b instanceof Synonym);
        try {
            DBObjectID arefID = null;
            DBObjectID brefID = null;
            DBObject arefObj = null;
            DBObject brefObj = null;
            Schema arefSchema = null;
            Schema brefSchema = null;
            String arefObjName = "";
            String brefObjName = "";
            String arefSchemaName = "";
            String brefSchemaName = "";
            boolean isDangling = false;
            if (null != a) {
                arefID = ((Synonym)a).getReference();
                isDangling = DBUtil.isDangling((DBObjectID)arefID);
                DBObject dBObject = arefObj = arefID == null ? null : arefID.resolveID();
                if (null != arefObj && arefObj instanceof SchemaObject) {
                    arefSchema = ((SchemaObject)arefObj).getSchema();
                    arefObjName = arefObj.getName();
                    arefSchemaName = arefSchema.getName();
                } else if (arefID instanceof ReferenceID) {
                    arefObjName = ((ReferenceID)arefID).getName();
                    arefSchemaName = ((ReferenceID)arefID).getSchemaName();
                }
            }
            if (null != b) {
                brefID = ((Synonym)b).getReference();
                isDangling |= DBUtil.isDangling((DBObjectID)brefID);
                DBObject dBObject = brefObj = brefID == null ? null : brefID.resolveID();
                if (null != brefObj && brefObj instanceof SchemaObject) {
                    brefSchema = ((SchemaObject)brefObj).getSchema();
                    brefObjName = brefObj.getName();
                    brefSchemaName = brefSchema.getName();
                } else if (brefID instanceof ReferenceID) {
                    brefObjName = ((ReferenceID)brefID).getName();
                    brefSchemaName = ((ReferenceID)brefID).getSchemaName();
                }
            }
            ResultSet r1 = new ResultSet(rs, arefSchemaName.equals(brefSchemaName), a, b, "ReferencedSchema");
            DisplayProps.setAVal(r1, arefSchemaName);
            DisplayProps.setBVal(r1, brefSchemaName);
            ResultSet r2 = new ResultSet(rs, arefObjName.equals(brefObjName), a, b, "ReferencedRelation");
            DisplayProps.setAVal(r2, arefObjName);
            DisplayProps.setBVal(r2, brefObjName);
            same = same && r1.isSame() && r2.isSame();
        }
        catch (DBException dbe) {
            DBLog.logStackTrace((Throwable)dbe);
        }
        rs.setSame(same);
        return result;
    }

    protected boolean isIgnoredProperty(String name) {
        return name.equals("reference");
    }
}

