/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.OldSQLFragmentDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.util.ModelUtil;

public class IndexObjectDiffer
extends OldSQLFragmentDiffer {
    public boolean diff(Object a, Object b) {
        assert (null != a || null != b);
        assert (null == a || a instanceof IndexObject);
        assert (null == b || b instanceof IndexObject);
        ResultSet rs = new ResultSet(null, a, b, null, "MAP");
        DiffEngine de = new DiffEngine();
        DiffContext dc = new DiffContext(de, rs);
        return this.diff(a, b, rs, dc);
    }

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        return this.diff(a, b, rs, dc, false);
    }

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc, boolean iws) {
        assert (null != a || null != b);
        assert (null == a || a instanceof IndexObject);
        assert (null == b || b instanceof IndexObject);
        assert ("MAP".equals(rs.getType()));
        super.diff(a, b, rs, dc, iws);
        boolean same = rs.isSame();
        String aOrder = null;
        String bOrder = null;
        boolean oneNull = false;
        if (null == a) {
            oneNull = true;
        } else {
            aOrder = ((IndexObject)a).getOrder();
        }
        if (null == b) {
            oneNull = true;
        } else {
            bOrder = ((IndexObject)b).getOrder();
        }
        if (oneNull) {
            same = false;
            ResultSet rOrder = new ResultSet(rs, false, a, b, "order".toString());
            DisplayProps.setAVal(rOrder, aOrder);
            DisplayProps.setBVal(rOrder, bOrder);
        } else {
            same = same && ModelUtil.areEqual((Object)aOrder, (Object)bOrder);
            ResultSet rOrder = new ResultSet(rs, same, a, b, "order".toString());
            DisplayProps.setAVal(rOrder, aOrder);
            DisplayProps.setBVal(rOrder, bOrder);
        }
        rs.setSame(same);
        return true;
    }
}

