/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.diff.ColumnConstraintDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.GenericArrayDiffer;
import oracle.javatools.db.diff.ResultSet;

public class FKConstraintDiffer
extends ColumnConstraintDiffer {
    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        boolean result = super.diff(a, b, rs, dc);
        boolean same = rs.isSame();
        assert (null == a || a instanceof FKConstraint);
        assert (null == b || b instanceof FKConstraint);
        FKRefDesc aRefDesc = new FKRefDesc((FKConstraint)a);
        FKRefDesc bRefDesc = new FKRefDesc((FKConstraint)b);
        String arefRelName = aRefDesc.getRefRelName();
        String brefRelName = bRefDesc.getRefRelName();
        String arefSchemaName = aRefDesc.getRefSchemaName();
        String brefSchemaName = bRefDesc.getRefSchemaName();
        String arefConName = aRefDesc.getRefConName();
        String brefConName = bRefDesc.getRefConName();
        String[] arefColNames = aRefDesc.getRefColNames();
        String[] brefColNames = bRefDesc.getRefColNames();
        ResultSet r1 = new ResultSet(rs, arefSchemaName.equals(brefSchemaName), a, b, "ReferencedSchema");
        DisplayProps.setAVal(r1, arefSchemaName);
        DisplayProps.setBVal(r1, brefSchemaName);
        ResultSet r2 = new ResultSet(rs, arefRelName.equals(brefRelName), a, b, "ReferencedRelation");
        DisplayProps.setAVal(r2, arefRelName);
        DisplayProps.setBVal(r2, brefRelName);
        ResultSet r3 = new ResultSet(rs, arefConName.equals(brefConName), a, b, "ReferencedConstraintName");
        DisplayProps.setAVal(r3, arefConName);
        DisplayProps.setBVal(r3, brefConName);
        ResultSet r4 = new ResultSet(rs, a, b, "ReferencedColumn", "LIST");
        GenericArrayDiffer gad = new GenericArrayDiffer();
        boolean diffRes = gad.diff((Object)arefColNames, (Object)brefColNames, r4, dc);
        same = same && r1.isSame() && r2.isSame() && r3.isSame() && r4.isSame();
        rs.setSame(same);
        return result;
    }

    protected boolean isIgnoredProperty(String name) {
        return name.equals("referenceID");
    }

    public static class FKRefDesc {
        private String m_refSchemaName = "";
        private String m_refRelName = "";
        private String m_refConName = "";
        private String[] m_refColNames;

        public FKRefDesc(FKConstraint fk) {
            if (null != fk) {
                DBObjectID refID = fk.getReferenceID();
                if (refID instanceof ReferenceID) {
                    DBObjectID parentDbOid = refID.getParent();
                    if (parentDbOid instanceof ReferenceID) {
                        ReferenceID parentID = (ReferenceID)parentDbOid;
                        this.m_refSchemaName = parentID == null ? null : parentID.getSchemaName();
                        this.m_refRelName = parentID == null ? null : parentID.getName();
                        this.m_refConName = ((ReferenceID)refID).getName();
                        this.m_refColNames = ((ReferenceID)refID).getChildObjectNames();
                    }
                } else {
                    try {
                        UniqueConstraint refCon = (UniqueConstraint)refID.resolveID();
                        if (null != refCon) {
                            Relation rel = refCon.getRelation();
                            Schema schema = rel.getSchema();
                            this.m_refSchemaName = schema.getName();
                            this.m_refRelName = rel.getName();
                            this.m_refConName = refCon.getName();
                            List<Column> cols = ColumnConstraintDiffer.getColumns((ColumnConstraint)refCon);
                            this.m_refColNames = new String[cols.size()];
                            for (int i = 0; i < this.m_refColNames.length; ++i) {
                                Column c = cols.get(i);
                                this.m_refColNames[i] = c == null ? null : c.getName();
                            }
                        }
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                }
            }
        }

        public String getRefSchemaName() {
            return this.m_refSchemaName;
        }

        public String getRefRelName() {
            return this.m_refRelName;
        }

        public String getRefConName() {
            return this.m_refConName;
        }

        public String[] getRefColNames() {
            return this.m_refColNames;
        }
    }
}

