/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.Properties;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.OldDBObjectDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.WhereObject;

public class DeclarativeSQLQueryDiffer
extends OldDBObjectDiffer {
    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        assert (null != a || null != b);
        assert (null == a || a instanceof SQLQuery);
        assert (null == b || b instanceof SQLQuery);
        assert ("MAP".equals(rs.getType()));
        boolean attrsSame = this.diffAttributes((SQLQuery)a, (SQLQuery)b, rs, dc);
        Properties aprops = new Properties(a);
        Properties bprops = new Properties(b);
        aprops.remove("Children");
        bprops.remove("Children");
        boolean listsSame = this.diffLists(a, aprops, b, bprops, rs, dc);
        rs.setSame(attrsSame && listsSame);
        return true;
    }

    private boolean diffAttributes(SQLQuery a, SQLQuery b, ResultSet rs, DiffContext dc) {
        WhereObject awo = null != a ? a.getWhereObject() : null;
        WhereObject bwo = null != b ? b.getWhereObject() : null;
        boolean sameWhereObject = false;
        sameWhereObject = null != awo ? awo.equals((Object)bwo) : null == bwo;
        ResultSet r = new ResultSet(rs, sameWhereObject, (Object)awo, (Object)bwo, "WhereObject");
        DisplayProps.setAVal(r, String.valueOf(awo));
        DisplayProps.setBVal(r, String.valueOf(bwo));
        GroupByObject agbo = null != a ? a.getGroupByObject() : null;
        GroupByObject bgbo = null != b ? b.getGroupByObject() : null;
        boolean sameGroupByObject = false;
        sameGroupByObject = null != agbo ? agbo.equals((Object)bgbo) : null == bgbo;
        r = new ResultSet(rs, sameGroupByObject, (Object)agbo, (Object)bgbo, "GroupByObject");
        DisplayProps.setAVal(r, String.valueOf(agbo));
        DisplayProps.setBVal(r, String.valueOf(bgbo));
        String atext = null != a ? a.getSQLText() : null;
        String btext = null != b ? b.getSQLText() : null;
        boolean sameSQLText = null != atext ? atext.equals(btext) : false;
        r = new ResultSet(rs, sameSQLText, (Object)a, (Object)b, "SQLText");
        DisplayProps.setAVal(r, atext);
        DisplayProps.setBVal(r, btext);
        return sameWhereObject && sameGroupByObject && sameSQLText;
    }
}

