/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.derby;

import java.sql.Connection;
import java.util.Collection;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.derby.DerbyDatabase;
import oracle.javatools.db.derby.DerbyTableBuilder;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDatabaseImpl
extends JdbcDDLDatabase
implements DerbyDatabase {
    protected DerbyDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    protected void registerBuilders(Collection<String> types, String catalog) {
        super.registerBuilders(types, catalog);
        if (types.contains("TABLE")) {
            this.registerBuilder("TABLE", (DBObjectBuilder)new DerbyTableBuilder(this, catalog));
        }
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        Registerer() {
        }

        public void registerDataTypes(DataTypeRegistry dtr) {
            DataTypeAttribute INTEGER_DISPLAY_WIDTH = new DataTypeAttribute("size", 172, 0L, new Long(255L), null, false);
            DataTypeAttribute DECIMAL_DISPLAY_PRECISION = new DataTypeAttribute("size", 158, 0L, new Long(255L), new Long(10L), false);
            DataTypeAttribute DOUBLE_DISPLAY_PRECISION = new DataTypeAttribute("size", 158, 0L, new Long(255L), new Long(22L), false);
            DataTypeAttribute SCALE = new DataTypeAttribute("scale", 159, 0L, null, new Long(0L), false);
            NumericDataType.MinMaxValue MIN_MAX_DOUBLE = new NumericDataType.MinMaxValue("2.2250738585072014E-308", "1.7976931348623157E+308", 2);
            NumericDataType.MinMaxValue MIN_MAX_REAL = new NumericDataType.MinMaxValue("1.175E-37", "3.402E+38", 2);
            NumericDataType DATATYPE_SMALLINT = new NumericDataType(65535, "SMALLINT", "SMALLINT", new DataTypeAttribute[0], NumericDataType.MIN_MAX_SMALLINT);
            NumericDataType DATATYPE_BIGINT = new NumericDataType(65535, "BIGINT", "BIGINT", new DataTypeAttribute[0], NumericDataType.MIN_MAX_BIGINT);
            NumericDataType DATATYPE_INTEGER = new NumericDataType(65535, "INTEGER", "INTEGER", new DataTypeAttribute[0], NumericDataType.MIN_MAX_INT);
            NumericDataType DATATYPE_DECIMAL = new NumericDataType(65535, "DECIMAL", "DECIMAL[(<size>[, <scale>])]", new DataTypeAttribute[]{DECIMAL_DISPLAY_PRECISION, SCALE}, MIN_MAX_DOUBLE);
            NumericDataType DATATYPE_FLOAT = new NumericDataType(65535, "FLOAT", "FLOAT[(<size>)]", new DataTypeAttribute[]{DECIMAL_DISPLAY_PRECISION}, MIN_MAX_DOUBLE);
            NumericDataType DATATYPE_DOUBLE = new NumericDataType(65535, "DOUBLE", "DOUBLE", new DataTypeAttribute[0], MIN_MAX_DOUBLE);
            NumericDataType DATATYPE_REAL = new NumericDataType(65535, "REAL", "REAL", new DataTypeAttribute[0], MIN_MAX_REAL);
            PredefinedDataType DATATYPE_DATE = new PredefinedDataType(65535, "DATE");
            PredefinedDataType DATATYPE_TIME = new PredefinedDataType(65535, "TIME");
            PredefinedDataType DATATYPE_TIMESTAMP = new PredefinedDataType(65535, "TIMESTAMP");
            DataTypeAttribute CHAR_DISPLAY_WIDTH = new DataTypeAttribute("size", 172, 1L, new Long(255L), new Long(255L), true);
            DataTypeAttribute OPTIONAL_CHAR_DISPLAY_WIDTH = new DataTypeAttribute("size", 172, 1L, new Long(255L), new Long(1L), false);
            DataTypeAttribute VARCHAR_DISPLAY_WIDTH = new DataTypeAttribute("size", 172, 1L, new Long(21844L), new Long(255L), true);
            DataTypeAttribute CHAR_SIZE = new DataTypeAttribute("size", 157, 1L, new Long(255L), new Long(255L), true);
            DataTypeAttribute OPTIONAL_CHAR_SIZE = new DataTypeAttribute("size", 157, 1L, new Long(255L), new Long(1L), false);
            DataTypeAttribute VARCHAR_SIZE = new DataTypeAttribute("size", 157, 1L, new Long(21844L), new Long(255L), true);
            CharacterDataType DATATYPE_CHAR = new CharacterDataType(65535, "CHAR", "CHAR[(<size>)]", new DataTypeAttribute[]{OPTIONAL_CHAR_DISPLAY_WIDTH});
            CharacterDataType DATATYPE_VARCHAR = new CharacterDataType(65535, "VARCHAR", "VARCHAR(<size>)", new DataTypeAttribute[]{VARCHAR_DISPLAY_WIDTH});
            CharacterDataType DATATYPE_LONG_VARCHAR = new CharacterDataType(65535, "LONG VARCHAR", "LONG VARCHAR", new DataTypeAttribute[0]);
            BinaryDataType DATATYPE_CHAR_FOR_BIT_DATA = new BinaryDataType(65535, "CHAR FOR BIT DATA", "CHAR[(<size>)] FOR BIT DATA", new DataTypeAttribute[]{OPTIONAL_CHAR_SIZE});
            BinaryDataType DATATYPE_VARCHAR_FOR_BIT_DATA = new BinaryDataType(65535, "VARCHAR FOR BIT DATA", "VARCHAR(<size>) FOR BIT DATA", new DataTypeAttribute[]{CHAR_SIZE});
            BinaryDataType DATATYPE_LONG_VARCHAR_FOR_BIT_DATA = new BinaryDataType(65535, "LONG VARCHAR FOR BIT DATA", "LONG VARCHAR FOR BIT DATA", new DataTypeAttribute[0]);
            BinaryDataType DATATYPE_CLOB = new BinaryDataType(65535, "CLOB", "CLOB[(<size>)]", 1L, Integer.MAX_VALUE, Integer.MAX_VALUE, false, new DataTypeAttribute[0]);
            BinaryDataType DATATYPE_BLOB = new BinaryDataType(65535, "BLOB", "BLOB[(<size>)]", 1L, Integer.MAX_VALUE, Integer.MAX_VALUE, false, new DataTypeAttribute[0]);
            CharacterDataType DATATYPE_XML = new CharacterDataType(65535, "XML", "XML", new DataTypeAttribute[0]);
            dtr.registerDataType((DataType)DATATYPE_SMALLINT, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            dtr.registerDataType((DataType)DATATYPE_BIGINT, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_BIGINT);
            dtr.registerDataType((DataType)DATATYPE_BLOB, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_BLOB);
            dtr.registerDataType((DataType)DATATYPE_CHAR, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_CHAR);
            dtr.registerDataType((DataType)DATATYPE_CHAR_FOR_BIT_DATA, DerbyDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_CLOB, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_CLOB);
            dtr.registerDataType((DataType)DATATYPE_DATE, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_DATE);
            dtr.registerDataType((DataType)DATATYPE_DECIMAL, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)DATATYPE_DOUBLE, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_DOUBLE_PRECISION);
            dtr.registerDataType((DataType)DATATYPE_FLOAT, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)DATATYPE_INTEGER, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_INTEGER);
            dtr.registerDataType((DataType)DATATYPE_LONG_VARCHAR, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_VARCHAR);
            dtr.registerDataType((DataType)DATATYPE_LONG_VARCHAR_FOR_BIT_DATA, DerbyDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_REAL, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_REAL);
            dtr.registerDataType((DataType)DATATYPE_TIME, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_TIME);
            dtr.registerDataType((DataType)DATATYPE_TIMESTAMP, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_TIMESTAMP);
            dtr.registerDataType((DataType)DATATYPE_VARCHAR, DerbyDatabaseImpl.class, JdbcDatabase.ANSI_VARCHAR);
            dtr.registerDataType((DataType)DATATYPE_VARCHAR_FOR_BIT_DATA, DerbyDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_XML, DerbyDatabaseImpl.class);
            dtr.registerSynonym("BINARY LARGE OBJECT", (DataType)DATATYPE_BLOB, DerbyDatabaseImpl.class);
            dtr.registerSynonym("CHAR VARYING", (DataType)DATATYPE_VARCHAR, DerbyDatabaseImpl.class);
            dtr.registerSynonym("CHAR VARYING FOR BIT DATA", (DataType)DATATYPE_VARCHAR_FOR_BIT_DATA, DerbyDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER", (DataType)DATATYPE_CHAR, DerbyDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER FOR BIT DATA", (DataType)DATATYPE_CHAR_FOR_BIT_DATA, DerbyDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER LARGE OBJECT", (DataType)DATATYPE_CLOB, DerbyDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER VARYING", (DataType)DATATYPE_VARCHAR, DerbyDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER VARYING FOR BIT DATA", (DataType)DATATYPE_VARCHAR_FOR_BIT_DATA, DerbyDatabaseImpl.class);
            dtr.registerSynonym("DEC", (DataType)DATATYPE_DECIMAL, DerbyDatabaseImpl.class);
            dtr.registerSynonym("DOUBLE PRECISION", (DataType)DATATYPE_DOUBLE, DerbyDatabaseImpl.class);
            dtr.registerSynonym("INT", (DataType)DATATYPE_INTEGER, DerbyDatabaseImpl.class);
            dtr.registerSynonym("NUMERIC", (DataType)DATATYPE_DECIMAL, DerbyDatabaseImpl.class);
        }
    }
}

