/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.sql.Connection;
import java.util.Collection;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.db2.DB2TableBuilder;
import oracle.javatools.db.db2.DB2UniversalDatabase;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2UniversalDatabaseImpl
extends JdbcDDLDatabase
implements DB2UniversalDatabase {
    protected DB2UniversalDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    @Override
    protected void registerBuilders(Collection<String> types, String catalog) {
        super.registerBuilders(types, catalog);
        if (types.contains("TABLE")) {
            this.registerBuilder("TABLE", (DBObjectBuilder)new DB2TableBuilder(this, catalog));
        }
    }

    public DataType getOrCreateDataType(String typeName) {
        return super.getOrCreateDataType(typeName.trim().toUpperCase());
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    protected boolean useCatalogFromSchema() {
        return false;
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        Registerer() {
        }

        public void registerDataTypes(DataTypeRegistry dtr) {
            Long LONG_0 = new Long(0L);
            Long LONG_5 = new Long(5L);
            DataTypeAttribute KMG = new DataTypeAttribute("KMG", 164, new String[]{"K", "M", "G"}, null, false, false);
            DataTypeAttribute SCHEMA = new DataTypeAttribute("schema", 169, null, false);
            DataTypeAttribute DATA_LINK_SIZE = new DataTypeAttribute("size", 157, new String[]{"200"}, "200", false, false);
            NumericDataType BIGINT = new NumericDataType(65535, "BIGINT", NumericDataType.MIN_MAX_BIGINT);
            NumericDataType INT = new NumericDataType(65535, "INT", NumericDataType.MIN_MAX_INT);
            NumericDataType INTEGER = new NumericDataType(65535, "INTEGER", NumericDataType.MIN_MAX_INT);
            NumericDataType SMALLINT = new NumericDataType(65535, "SMALLINT", NumericDataType.MIN_MAX_SMALLINT);
            NumericDataType DEC = new NumericDataType(65535, "DEC", "DEC[(<precision>[, <scale>])]", 1L, 31L, LONG_5, false, 0L, null, LONG_0, false, null, null);
            NumericDataType DECIMAL = new NumericDataType(65535, "DECIMAL", "DECIMAL[(<precision>[, <scale>])]", 1L, 31L, LONG_5, false, 0L, null, LONG_0, false, null, null);
            NumericDataType DOUBLE = new NumericDataType(65535, "DOUBLE", new NumericDataType.MinMaxValue("2.225E-307", "1.79769E+308", 2));
            NumericDataType DOUBLE_PRECISION = new NumericDataType(65535, "DOUBLE PRECISION", new NumericDataType.MinMaxValue("2.225E-307", "1.79769E+308", 2));
            NumericDataType FLOAT = new NumericDataType(65535, "FLOAT", "FLOAT[(<precision>)]", 1L, 53L, null, false, null, new NumericDataType.MinMaxValue("2.225E-307", "1.79769E+308", 2));
            NumericDataType REAL = new NumericDataType(65535, "REAL", new NumericDataType.MinMaxValue("1.175E-37", "3.402E+38", 2));
            PredefinedDataType DATE = new PredefinedDataType(65535, "DATE");
            PredefinedDataType TIME = new PredefinedDataType(65535, "TIME");
            PredefinedDataType TIMESTAMP = new PredefinedDataType(65535, "TIMESTAMP");
            CharacterDataType CHAR = new CharacterDataType(65535, "CHAR", "CHAR[(<size>)]", 1L, 254L, 1L, false, null);
            CharacterDataType VARCHAR = new CharacterDataType(65535, "VARCHAR", "VARCHAR(<size>)", 1L, 32762L, 20L, true, null);
            CharacterDataType LONG_VARCHAR = new CharacterDataType(65535, "LONG VARCHAR", 1L, 32700L);
            CharacterDataType CLOB = new CharacterDataType(65535, "CLOB", "CLOB[(<size>[ <KMG>])]", 1L, Integer.MAX_VALUE, 0x100000L, false, new DataTypeAttribute[]{KMG});
            CharacterDataType DBCLOB = new CharacterDataType(65535, "DBCLOB", "DBCLOB[(<size>[ <KMG>])]", 1L, 0x3FFFFFFFL, 0x100000L, false, new DataTypeAttribute[]{KMG});
            CharacterDataType GRAPHIC = new CharacterDataType(65535, "GRAPHIC", "GRAPHIC[(<size>)]", 1L, 127L, 1L, false, null);
            CharacterDataType VARGRAPHIC = new CharacterDataType(65535, "VARGRAPHIC", "VARGRAPHIC(<size>)", 1L, 16336L, 20L, true, null);
            CharacterDataType LONG_VARGRAPHIC = new CharacterDataType(65535, "LONG VARGRAPHIC", 1L, 16350L);
            BinaryDataType BLOB = new BinaryDataType(65535, "BLOB", "BLOB[(<size>[ <KMG>])]", 1L, Integer.MAX_VALUE, 0x100000L, false, new DataTypeAttribute[]{KMG});
            PredefinedDataType DATALINK = new PredefinedDataType(65535, "DATALINK", "DATALINK[(<size>)]", new DataTypeAttribute[]{DATA_LINK_SIZE});
            PredefinedDataType REF = new PredefinedDataType(65535, "REF", "REF[(<schema>)]", new DataTypeAttribute[]{SCHEMA});
            dtr.registerDataType((DataType)BIGINT, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_BIGINT);
            dtr.registerDataType((DataType)INT, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_INT);
            dtr.registerDataType((DataType)INTEGER, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_INT);
            dtr.registerDataType((DataType)SMALLINT, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            dtr.registerDataType((DataType)DEC, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)DECIMAL, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)DOUBLE, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_DOUBLE_PRECISION);
            dtr.registerDataType((DataType)DOUBLE_PRECISION, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_DOUBLE_PRECISION);
            dtr.registerDataType((DataType)FLOAT, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)REAL, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_REAL);
            dtr.registerDataType((DataType)DATE, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_TIMESTAMP);
            dtr.registerDataType((DataType)TIME, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_TIMESTAMP);
            dtr.registerDataType((DataType)TIMESTAMP, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_TIMESTAMP);
            dtr.registerDataType((DataType)CHAR, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_CHAR);
            dtr.registerDataType((DataType)VARCHAR, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_VARCHAR);
            dtr.registerDataType((DataType)GRAPHIC, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_NCHAR);
            dtr.registerDataType((DataType)VARGRAPHIC, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_NCHAR_VARYING);
            dtr.registerDataType((DataType)CLOB, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_CLOB);
            dtr.registerDataType((DataType)DBCLOB, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_NCLOB);
            dtr.registerDataType((DataType)LONG_VARCHAR, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_VARCHAR);
            dtr.registerDataType((DataType)LONG_VARGRAPHIC, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_NCHAR_VARYING);
            dtr.registerDataType((DataType)BLOB, DB2UniversalDatabaseImpl.class, JdbcDatabase.ANSI_BLOB);
            dtr.registerDataType((DataType)DATALINK, DB2UniversalDatabaseImpl.class);
            dtr.registerDataType((DataType)REF, DB2UniversalDatabaseImpl.class);
            dtr.registerSynonym("BINARY LARGE OBJECT", (DataType)BLOB, DB2UniversalDatabaseImpl.class);
            dtr.registerSynonym("CHAR LARGE OBJECT", (DataType)CLOB, DB2UniversalDatabaseImpl.class);
            dtr.registerSynonym("CHAR VARYING", (DataType)VARCHAR, DB2UniversalDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER", (DataType)CHAR, DB2UniversalDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER LARGE OBJECT", (DataType)CLOB, DB2UniversalDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER VARYING", (DataType)VARCHAR, DB2UniversalDatabaseImpl.class);
            dtr.registerSynonym("NUM", (DataType)DEC, DB2UniversalDatabaseImpl.class);
            dtr.registerSynonym("NUMERIC", (DataType)DECIMAL, DB2UniversalDatabaseImpl.class);
        }
    }
}

