/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.BaseDatabaseCreator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.db2.DB2DatabaseDescriptor;
import oracle.javatools.db.db2.DB2UniversalDatabaseImpl;
import oracle.javatools.db.db2.DB2v9DatabaseDescriptor;
import oracle.javatools.db.db2.DB2v9UniversalDatabaseImpl;

public class DB2UniversalDatabaseFactory
extends BaseDatabaseCreator {
    private Map<String, DatabaseDescriptor> m_descriptors = new HashMap<String, DatabaseDescriptor>();

    public DB2UniversalDatabaseFactory() {
        this.registerProviderClass(DB2UniversalDatabaseImpl.class, 406, (DataTypeRegistry.Registerer)new DB2UniversalDatabaseImpl.Registerer());
        this.registerProviderClass(DB2v9UniversalDatabaseImpl.class, 407, (DataTypeRegistry.Registerer)new DB2v9UniversalDatabaseImpl.Registerer());
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getUniversalConnectionType(conn);
        switch (t) {
            case 0: {
                return new DB2UniversalDatabaseImpl(connStore, connName, conn);
            }
            case 1: {
                return new DB2v9UniversalDatabaseImpl(connStore, connName, conn);
            }
        }
        return null;
    }

    protected int getUniversalConnectionType(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                if (driverName.indexOf("DB2") > -1 || driverName.indexOf("AS/400") > -1 || driverName.indexOf("JDE World") > -1) {
                    int v = dmd.getDatabaseMajorVersion();
                    if (v >= 9) {
                        return 1;
                    }
                    return 0;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        DB2DatabaseDescriptor descriptor = null;
        if (DB2v9UniversalDatabaseImpl.class.isAssignableFrom(providerClass)) {
            descriptor = this.m_descriptors.get(providerClass.getName());
            if (descriptor == null) {
                descriptor = new DB2v9DatabaseDescriptor(providerClass);
                this.m_descriptors.put(providerClass.getName(), descriptor);
            }
            return descriptor;
        }
        if (DB2UniversalDatabaseImpl.class.isAssignableFrom(providerClass)) {
            descriptor = this.m_descriptors.get(providerClass.getName());
            if (descriptor == null) {
                descriptor = new DB2DatabaseDescriptor(providerClass);
                this.m_descriptors.put(providerClass.getName(), descriptor);
            }
            return descriptor;
        }
        return null;
    }
}

