/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.SQLServer.SQLServer2005;
import oracle.javatools.db.SQLServer.SQLServer2008;
import oracle.javatools.db.SQLServer.SQLServerColumnValidator;
import oracle.javatools.db.SQLServer.SQLServerDDLGenerator;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcDatabaseDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServerDatabaseDescriptor<T extends SQLServerDatabase>
extends JdbcDatabaseDescriptor<T> {
    public static final int MAX_NAME_LENGTH = 128;
    public static final int MAX_TEMP_NAME_LENGTH = 116;
    public static final char QUOTE_IDENTIFIER = '\"';
    public static final char OPEN_QUOTE_IDENTIFIER = '[';
    public static final char CLOSE_QUOTE_IDENTIFIER = ']';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BACKUP", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLUMN", "COMMIT", "COMPUTE", "CONSTRAINT", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DENY", "DESC", "DISK", "DISTINCT", "DISTRIBUTED", "DOUBLE", "DROP", "DUMMY", "DUMP", "ELSE", "END", "ERRLVL", "ESCAPE", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXIT", "FETCH", "FILE", "FILLFACTOR", "FOR", "FOREIGN", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITY_INSERT", "IDENTITYCOL", "IF", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "KEY", "KILL", "LEFT", "LIKE", "LINENO", "LOAD", "NATIONAL", "NOCHECK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "OF", "OFF", "OFFSETS", "ON", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPTION", "OR", "ORDER", "OUTER", "OVER", "PERCENT", "PLAN", "PRECISION", "PRIMARY", "PRINT", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READTEXT", "RECONFIGURE", "REFERENCES", "REPLICATION", "RESTORE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROWCOUNT", "ROWGUIDCOL", "RULE", "SAVE", "SCHEMA", "SELECT", "SESION_USER", "SET", "SETUSER", "SHUTDOWN", "SOME", "STATISTICS", "SYSTEM_USER", "TABLE", "TEXTSIZE", "THEN", "TO", "TOP", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UPDATE", "UPDATETEXT", "USE", "USER", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WRITETEXT"));

    public SQLServerDatabaseDescriptor(Class<? extends T> clz) {
        super(clz);
    }

    @Override
    public int getCasePolicy() {
        return 0;
    }

    public int getQuotedNameCasePolicy() {
        return 0;
    }

    @Override
    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    @Override
    public int getMaxNameLength(String type) {
        return 128;
    }

    @Override
    public void validateName(String type, String name) throws InvalidNameException {
        char firstChar;
        boolean isValid = true;
        String reason = "";
        try {
            SQLServerDatabaseDescriptor.validateIdentifier((String)name, (char)'\"', (int)128, (String)"_$#@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy());
        }
        catch (InvalidNameException ine) {
            isValid = false;
            reason = ine.getMessage();
        }
        char c = firstChar = isValid ? (char)name.charAt(0) : (char)'0';
        if (isValid && firstChar != '\"' && !Character.isLetter(firstChar) && firstChar != '_' && firstChar != '#' && firstChar != '@') {
            throw new InvalidNameException(null, DBArb.getString((int)9));
        }
        if (!isValid && firstChar == '[' && name.indexOf(91, 1) == -1 && name.indexOf(93, 1) == name.length() - 1 && name.length() > 2 && name.length() < 131) {
            isValid = true;
        }
        if (!isValid) {
            throw new InvalidNameException(null, reason);
        }
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(pro);
        v.put("COLUMN", new SQLServerColumnValidator(pro));
        return v;
    }

    @Override
    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new SQLServerDDLGenerator(pro);
    }

    @Override
    public String getDatabaseType() {
        return "SQLServer";
    }

    @Override
    public int getDatabaseVersion() {
        int retval = 8;
        Class clz = this.getDatabaseClass();
        if (SQLServer2008.class.isAssignableFrom(clz)) {
            retval = 10;
        } else if (SQLServer2005.class.isAssignableFrom(clz)) {
            retval = 9;
        }
        return retval;
    }
}

