/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.SQLServer.SQLServerDatabaseImpl;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.util.ModelUtil;

public class SQLServer2005
extends SQLServerDatabaseImpl {
    protected static final String SELECT_SCHEMAS = "select name from sys.schemas";

    protected SQLServer2005(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    protected String getDefaultSchemaName() {
        String defaultSchemaName = "dbo";
        return defaultSchemaName;
    }

    protected boolean useCatalogFromSchema() {
        return false;
    }

    public boolean isUseSchema() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateSchemas() throws SQLException {
        Object crs = null;
        try {
            final QueryWrapper wrap = new QueryWrapper((Database)this, SELECT_SCHEMAS);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        while (rs.next()) {
                            String name = rs.getString(1);
                            String schemaName = ModelUtil.hasLength((String)name) ? name : "<null>";
                            String catalogName = SQLServer2005.this.getCatalog();
                            SQLServer2005.this.createAndCacheSchema(schemaName, catalogName, name);
                        }
                    }
                    catch (SQLException e) {
                        wrap.throwDBException(e);
                    }
                }
            };
            try {
                wrap.executeQuery(r);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Cannot query schemas for database " + this.getConnectionName(), dbe);
            }
        }
        catch (Throwable throwable) {
            this.close(crs);
            throw throwable;
        }
        this.close(crs);
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        Registerer() {
        }

        public void registerDataTypes(DataTypeRegistry dtr) {
            CharacterDataType XML = new CharacterDataType(65535, "XML", 1L, Integer.MAX_VALUE);
            dtr.registerDataType((DataType)XML, SQLServer2005.class, JdbcDatabase.ANSI_VARCHAR);
        }
    }
}

