/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.db.validators.IndexValidator;
import oracle.javatools.db.validators.SchemaValidator;
import oracle.javatools.db.validators.TableValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDatabaseDescriptor<T extends Database>
extends DatabaseDescriptor<T> {
    protected BaseDatabaseDescriptor(Class<? extends T> clz) {
        super(clz);
    }

    public boolean isCompatibleUpgrade(Class<? extends Database> dbClz, Class<? extends Database> testClz) {
        return dbClz != testClz && dbClz.isAssignableFrom(testClz);
    }

    public Map<String, DBObjectValidator> getValidators(DBObjectProvider pro) {
        Map<String, SchemaValidator> v = DBObjectRegistry.isActive() ? DBObjectRegistry.getInstance().getValidators(this.getDatabaseType(), this.getDatabaseVersion(), pro) : new HashMap<String, SchemaValidator>();
        v.put("SCHEMA", new SchemaValidator(pro));
        v.put("INDEX", (SchemaValidator)((Object)new IndexValidator(pro)));
        v.put("CONSTRAINT", (SchemaValidator)((Object)new ConstraintValidator(pro)));
        v.put("COLUMN", (SchemaValidator)((Object)new ColumnValidator(pro)));
        v.put("TABLE", (SchemaValidator)((Object)new TableValidator(pro)));
        return v;
    }

    public void makeNameValidAndUnique(DBObject object, DBObjectProvider pro) throws InvalidNameException {
        String origName = object.getName();
        try {
            pro.validateObjectProperty(null, object, "name");
            return;
        }
        catch (ValidationException e) {
            String newName = null;
            int baseLength = 0;
            String baseName = object.getName();
            baseLength = baseName.length() < this.getMaxNameLength(object.getType()) ? baseName.length() : this.getMaxNameLength(object.getType()) - 1;
            String chunk = baseName.substring(0, baseLength);
            while (true) {
                try {
                    this.validateName(object.getType(), chunk);
                }
                catch (InvalidNameException e2) {
                    chunk = baseName.substring(0, --baseLength);
                    if (baseLength != 0) continue;
                    chunk = "NAME";
                    baseLength = 4;
                }
                break;
            }
            int suffix = 1;
            while (true) {
                if ((newName = chunk + suffix++).length() > this.getMaxNameLength(object.getType())) {
                    --baseLength;
                    continue;
                }
                if (suffix >= 10000) break;
                try {
                    object.setName(newName);
                    pro.validateObjectProperty(null, object, "name");
                    return;
                }
                catch (ValidationException e3) {
                    continue;
                }
                break;
            }
            object.setName(origName);
            throw new InvalidNameException(null, null);
        }
    }

    public List<PropertyInitializer> getPropertyInitializers(DBObjectProvider pro) {
        ArrayList<PropertyInitializer> pdpList = new ArrayList<PropertyInitializer>();
        pdpList.add(new BasePropertyInitializer(pro));
        return pdpList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BasePropertyInitializer
    extends PropertyInitializer {
        private static String[] s_names = new String[]{"name"};
        private static String[] s_empty = new String[0];
        private boolean m_lower = this.getProvider().getDescriptor().getCasePolicy() == 1;

        BasePropertyInitializer(DBObjectProvider pro) {
            super(pro);
        }

        public String[] getPropertyNames(Class<? extends DBObject> clz) {
            if (SchemaObject.class.isAssignableFrom(clz) && Index.class != clz) {
                return s_names;
            }
            return s_empty;
        }

        public Object getPropertyInitialValue(DBObject obj, String propertyName) throws PropertyInitializer.InitializationVeto {
            if (obj instanceof SchemaObject && "name".equals(propertyName)) {
                String name;
                String typeName;
                SchemaObject so = (SchemaObject)obj;
                StringBuffer sb = new StringBuffer();
                if (so instanceof MaterializedView) {
                    typeName = "MVIEW";
                } else {
                    String type = Metadata.getType(so.getClass());
                    typeName = type.replaceAll(" ", "_");
                }
                sb.append(typeName);
                String string = name = this.m_lower ? sb.toString().toLowerCase() : sb.toString();
                if (so.getSchema() != null) {
                    name = this.getProvider().getUniqueName(so.getType(), (DBObject)so.getSchema(), name + "1");
                }
                return name;
            }
            return null;
        }
    }
}

