/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.Comparator;
import java.util.TreeMap;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.parser.XQXGen;
import org.w3c.dom.Node;

public class SeqOp
extends Expr {
    public static final int OP_UNION = 0;
    public static final int OP_INTERSECT = 1;
    public static final int OP_EXCEPT = 2;
    static final String[] types = new String[]{"union", "intersect", "except"};
    int type;

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)SeqOp.getDoc().createElement("SeqOp");
        xMLElement.setAttribute("type", types[this.type]);
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    public void getStrRep(StringBuffer stringBuffer) {
        this.toKidsStrRep(stringBuffer, types[this.type]);
    }

    public void toSql(XQXGen xQXGen) {
        xQXGen.startElement("function", XQXGen.createAttrs("builtin", "true", "infix", "true", "name", types[this.type]));
        this.toSqlDefault(xQXGen);
        xQXGen.endElement("function");
    }

    public SeqOp(int n, Expr expr, Expr expr2) {
        super(expr, expr2);
        this.type = n;
    }

    public SeqOp(int n, Expr[] exprArray) {
        super(exprArray);
        this.type = n;
    }

    public SeqOp() {
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        OXMLSequence oXMLSequence = queryState.createSequence();
        OXMLSequence oXMLSequence2 = this.kids[0].Evaluate(queryState);
        OXMLSequence oXMLSequence3 = this.kids[1].Evaluate(queryState);
        int n = 0;
        switch (this.type) {
            case 0: {
                n = this.union(oXMLSequence2, oXMLSequence3, oXMLSequence, queryState);
                break;
            }
            case 1: {
                n = this.intersect(oXMLSequence2, oXMLSequence3, oXMLSequence, queryState);
                break;
            }
            case 2: {
                n = this.except(oXMLSequence2, oXMLSequence3, oXMLSequence, queryState);
            }
        }
        switch (n) {
            case 0: {
                oXMLSequence.setKnownType(OXMLSequenceType.EMPTY_SEQUENCE);
                break;
            }
            case 1: {
                oXMLSequence.setKnownType(OXMLSequenceType.NODE_ONE);
                break;
            }
            default: {
                oXMLSequence.setKnownType(OXMLSequenceType.NODE_ONE_OR_MORE);
            }
        }
        return oXMLSequence;
    }

    private int union(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, OXMLSequence oXMLSequence3, QueryState queryState) {
        Object object;
        boolean bl = this.kids[0].unknownStaticType();
        boolean bl2 = this.kids[1].unknownStaticType();
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(new DocumentOrderComparator());
        while (oXMLSequence.next()) {
            object = oXMLSequence.getItem();
            if (bl && !FNUtil.isNode((OXMLItem)object)) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
            treeMap.put(object, object);
        }
        while (oXMLSequence2.next()) {
            object = oXMLSequence2.getItem();
            if (bl2 && !FNUtil.isNode((OXMLItem)object)) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
            treeMap.put(object, object);
        }
        object = treeMap.keySet().iterator();
        int n = 0;
        while (object.hasNext()) {
            oXMLSequence3.appendItem((OXMLItem)object.next());
            ++n;
        }
        return n;
    }

    private int intersect(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, OXMLSequence oXMLSequence3, QueryState queryState) {
        Object object;
        int n = 0;
        if (!oXMLSequence.next() || !oXMLSequence2.next()) {
            return n;
        }
        boolean bl = this.kids[0].unknownStaticType();
        boolean bl2 = this.kids[1].unknownStaticType();
        TreeMap<OXMLItem, OXMLItem> treeMap = new TreeMap<OXMLItem, OXMLItem>(new DocumentOrderComparator());
        TreeMap<OXMLItem, OXMLItem> treeMap2 = new TreeMap<OXMLItem, OXMLItem>(new DocumentOrderComparator());
        do {
            object = oXMLSequence.getItem();
            if (bl && !FNUtil.isNode((OXMLItem)object)) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
            treeMap.put((OXMLItem)object, (OXMLItem)object);
        } while (oXMLSequence.next());
        do {
            object = oXMLSequence2.getItem();
            if (bl2 && !FNUtil.isNode((OXMLItem)object)) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
            if (!treeMap.containsKey(object)) continue;
            treeMap2.put((OXMLItem)object, (OXMLItem)object);
        } while (oXMLSequence2.next());
        object = treeMap2.keySet().iterator();
        while (object.hasNext()) {
            oXMLSequence3.appendItem((OXMLItem)object.next());
            ++n;
        }
        return n;
    }

    private int except(OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, OXMLSequence oXMLSequence3, QueryState queryState) {
        Object object;
        int n = 0;
        if (!oXMLSequence.next()) {
            return n;
        }
        boolean bl = this.kids[0].unknownStaticType();
        boolean bl2 = this.kids[1].unknownStaticType();
        TreeMap<OXMLItem, OXMLItem> treeMap = new TreeMap<OXMLItem, OXMLItem>(new DocumentOrderComparator());
        TreeMap<OXMLItem, OXMLItem> treeMap2 = new TreeMap<OXMLItem, OXMLItem>(new DocumentOrderComparator());
        while (oXMLSequence2.next()) {
            object = oXMLSequence2.getItem();
            if (bl && !FNUtil.isNode((OXMLItem)object)) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
            treeMap.put((OXMLItem)object, (OXMLItem)object);
        }
        do {
            object = oXMLSequence.getItem();
            if (bl2 && !FNUtil.isNode((OXMLItem)object)) {
                throw new XQException(queryState.getMesg().getMessage0("XPTY0004"));
            }
            if (treeMap.containsKey(object)) continue;
            treeMap2.put((OXMLItem)object, (OXMLItem)object);
        } while (oXMLSequence.next());
        object = treeMap2.keySet().iterator();
        while (object.hasNext()) {
            oXMLSequence3.appendItem((OXMLItem)object.next());
            ++n;
        }
        return n;
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitNodeSequence(this);
    }

    class SameNodeComparator
    implements Comparator {
        SameNodeComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((OXMLItem)object).getNode().isSameNode((Node)((OXMLItem)object2).getNode())) {
                return 0;
            }
            return 1;
        }
    }

    class DocumentOrderComparator
    implements Comparator {
        DocumentOrderComparator() {
        }

        public int compare(Object object, Object object2) {
            return XQueryUtils.compareNodeOrder(((OXMLItem)object).getNode(), ((OXMLItem)object2).getNode());
        }
    }
}

