/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.PathAxis;
import oracle.xquery.exec.PredicateSet;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XpathExpr;
import org.w3c.dom.Node;

public class PathStep
extends Expr {
    int nodeTestType;
    int nodeType;
    String name;
    String nameSpace;
    OXMLSequenceType seqType = null;
    PathAxis axisClass = null;
    PredicateSet predicateSet = null;
    boolean reorder = true;
    boolean anyNode = false;
    boolean hasNodeTest = false;

    public PathStep(int n, String string, String string2, PredicateSet predicateSet) {
        this.axisClass = PathAxis.getInstance(n);
        this.name = string;
        this.setNamespace(string2);
        this.nodeType = 1;
        this.predicateSet = predicateSet;
    }

    public PathStep(int n, PathStep pathStep) {
        this(n, pathStep.name, pathStep.nameSpace, pathStep.predicateSet);
        this.setAnyNode(pathStep.anyNode);
        this.hasNodeTest = pathStep.hasNodeTest;
        this.setNodeType(pathStep.nodeType);
        this.setReorder(pathStep.reorder);
        this.setSequenceType(pathStep.seqType);
    }

    private boolean tryAxis(int n) {
        this.axisClass = PathAxis.getInstance(n);
        return this.axisClass != null;
    }

    public Expr optimize(OptimizeContext optimizeContext) {
        if (this.predicateSet != null) {
            this.predicateSet.optimize(optimizeContext);
        }
        return super.optimize(optimizeContext);
    }

    public void eval(QueryState queryState) {
        this.axisClass.getItemList(this, queryState);
    }

    public void setNamespace(String string) {
        this.nameSpace = string;
        if (this.nameSpace == null) {
            this.nameSpace = "";
        }
    }

    public void setNodeType(int n) {
        this.nodeType = n;
    }

    public void setHasNodeTest() {
        this.hasNodeTest = true;
    }

    public boolean getHasNodeTest() {
        return this.hasNodeTest;
    }

    public boolean isTextTest() {
        return this.nodeType == 3;
    }

    public void setSequenceType(OXMLSequenceType oXMLSequenceType) {
        this.seqType = oXMLSequenceType;
    }

    public void setPredicateSet(PredicateSet predicateSet) {
        this.predicateSet = predicateSet;
    }

    public XMLNode toXML() {
        XMLElement xMLElement = (XMLElement)PathStep.getDoc().createElement("XPathStep");
        StringBuffer stringBuffer = new StringBuffer(20);
        this.getStrRep(stringBuffer);
        xMLElement.setAttribute("path", stringBuffer.toString());
        if (this.predicateSet != null) {
            xMLElement.appendChild((Node)this.predicateSet.toXML());
        }
        this.toXMLKids((XMLNode)xMLElement);
        return xMLElement;
    }

    public void getStrRep(StringBuffer stringBuffer) {
        stringBuffer.append("/");
        this.axisClass.getStrRep(stringBuffer);
        if (this.anyNode) {
            stringBuffer.append("node()");
        } else if (this.seqType != null) {
            this.seqType.toString(stringBuffer);
        } else {
            switch (this.nodeType) {
                case 3: {
                    stringBuffer.append("text()");
                    break;
                }
                case 8: {
                    stringBuffer.append("comment()");
                    break;
                }
                case 7: {
                    stringBuffer.append("processing-instruction(");
                    if (this.name != null) {
                        stringBuffer.append(this.name);
                    }
                    stringBuffer.append(")");
                    break;
                }
                case 1: 
                case 2: {
                    if (this.nameSpace.equals("") && this.name == null) {
                        if (this.nodeType == 1) {
                            stringBuffer.append("element()");
                            break;
                        }
                        stringBuffer.append("attribute()");
                        break;
                    }
                    if (!(this.nameSpace.equals("") || this.nameSpace.equals("*") && this.name.equals("*"))) {
                        stringBuffer.append(this.nameSpace).append(":");
                    }
                    if (this.name == null) break;
                    stringBuffer.append(this.name);
                    break;
                }
                case 9: {
                    stringBuffer.append("document-node()");
                }
            }
        }
    }

    public OXMLSequence Evaluate(QueryState queryState) {
        XpathExpr xpathExpr = new XpathExpr();
        xpathExpr.addStep(this);
        return xpathExpr.Evaluate(queryState);
    }

    public void setAnyNode(boolean bl) {
        this.anyNode = bl;
    }

    public void setReorder(boolean bl) {
        this.reorder = bl;
    }

    public int getAxis() {
        return this.axisClass.getAxisType();
    }

    public Expr normalize() {
        if (this.predicateSet != null) {
            this.predicateSet.normalize();
        }
        return this;
    }

    public void acceptVisitor(Visitor visitor) {
        visitor.visitPathStep(this);
    }
}

