/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import oracle.xquery.exec.ArithOp;
import oracle.xquery.exec.Case;
import oracle.xquery.exec.ConstantExpr;
import oracle.xquery.exec.DeleteExpr;
import oracle.xquery.exec.Document;
import oracle.xquery.exec.Dot;
import oracle.xquery.exec.Exists;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprSequence;
import oracle.xquery.exec.FLWR;
import oracle.xquery.exec.FilterProject;
import oracle.xquery.exec.FunctionCall;
import oracle.xquery.exec.GeneralComparison;
import oracle.xquery.exec.InsertExpr;
import oracle.xquery.exec.LetExpr;
import oracle.xquery.exec.LogicalOp;
import oracle.xquery.exec.NLJ;
import oracle.xquery.exec.NodeSource;
import oracle.xquery.exec.NodeSourceVisitor;
import oracle.xquery.exec.OrderComparison;
import oracle.xquery.exec.PathStep;
import oracle.xquery.exec.Predicate;
import oracle.xquery.exec.PredicateSet;
import oracle.xquery.exec.PredicatedExpr;
import oracle.xquery.exec.RelOp;
import oracle.xquery.exec.RenameExpr;
import oracle.xquery.exec.ReplaceNodeExpr;
import oracle.xquery.exec.ReplaceValueExpr;
import oracle.xquery.exec.SQLQuery;
import oracle.xquery.exec.Scan;
import oracle.xquery.exec.SeqOp;
import oracle.xquery.exec.SortNS;
import oracle.xquery.exec.TransformExpr;
import oracle.xquery.exec.TypeOp;
import oracle.xquery.exec.UnaryExpr;
import oracle.xquery.exec.ValidateExpr;
import oracle.xquery.exec.VarExpr;
import oracle.xquery.exec.Variable;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XMLCons;
import oracle.xquery.exec.XMLElem;
import oracle.xquery.exec.XQRangeExpr;
import oracle.xquery.exec.XpathExpr;

public class AbstractVisitor
implements Visitor,
NodeSourceVisitor {
    protected void generalVisit(Expr expr) {
        if (expr.kids != null) {
            for (int i = 0; i < expr.kids.length; ++i) {
                expr.kids[i].acceptVisitor(this);
            }
        }
    }

    public void visitLiteral(ConstantExpr constantExpr) {
    }

    public void visitVariableRef(VarExpr varExpr) {
        varExpr.var.acceptVisitor(this);
    }

    public void visitVariable(Variable variable) {
    }

    public void visitLetExpr(LetExpr letExpr) {
        letExpr.kids[0].acceptVisitor(this);
    }

    public void visitContextItem(Dot dot) {
    }

    public void visitFunctionCall(FunctionCall functionCall) {
        this.generalVisit(functionCall);
        if (functionCall.fd.getFunctionObj() == null) {
            Expr expr = functionCall.fd.getFunctionExpr();
            expr.acceptVisitor(this);
        }
    }

    public void visitDocument(Document document) {
        this.generalVisit(document);
    }

    public void visitOraView(SQLQuery sQLQuery) {
        this.generalVisit(sQLQuery);
    }

    public void visitPath(XpathExpr xpathExpr) {
        this.generalVisit(xpathExpr);
        int n = xpathExpr.steps.size();
        for (int i = 0; i < n; ++i) {
            Expr expr = (Expr)xpathExpr.steps.get(i);
            expr.acceptVisitor(this);
        }
    }

    public void visitPathStep(PathStep pathStep) {
        if (pathStep.predicateSet != null) {
            this.visitPredicateSet(pathStep.predicateSet);
        }
    }

    public void visitPredicateExpr(PredicatedExpr predicatedExpr) {
        predicatedExpr.kids[0].acceptVisitor(this);
        this.visitPredicateSet(predicatedExpr.predSet);
    }

    public void visitPredicateSet(PredicateSet predicateSet) {
        if (predicateSet.predicates == null) {
            return;
        }
        int n = predicateSet.predicates.size();
        for (int i = 0; i < n; ++i) {
            Predicate predicate = (Predicate)predicateSet.predicates.get(i);
            this.visitPredicate(predicate);
        }
    }

    public void visitPredicate(Predicate predicate) {
        predicate.kids[0].acceptVisitor(this);
    }

    public void visitExprSequence(ExprSequence exprSequence) {
        this.generalVisit(exprSequence);
    }

    public void visitRangeExpr(XQRangeExpr xQRangeExpr) {
        this.generalVisit(xQRangeExpr);
    }

    public void visitNodeSequence(SeqOp seqOp) {
        this.generalVisit(seqOp);
    }

    public void visitArithmeticExpr(ArithOp arithOp) {
        this.generalVisit(arithOp);
    }

    public void visitUnaryExpr(UnaryExpr unaryExpr) {
        this.generalVisit(unaryExpr);
    }

    public void visitValueComp(RelOp relOp) {
        this.generalVisit(relOp);
    }

    public void visitGeneralComp(GeneralComparison generalComparison) {
        this.generalVisit(generalComparison);
    }

    public void visitNodeComp(OrderComparison orderComparison) {
        this.generalVisit(orderComparison);
    }

    public void visitLogicalExpr(LogicalOp logicalOp) {
        this.generalVisit(logicalOp);
    }

    public void visitElementConstructor(XMLElem xMLElem) {
        if (xMLElem.elemNameExpr != null) {
            xMLElem.elemNameExpr.acceptVisitor(this);
        }
        this.generalVisit(xMLElem);
    }

    public void visitOtherConstructor(XMLCons xMLCons) {
        if (xMLCons.nameExpr != null) {
            xMLCons.nameExpr.acceptVisitor(this);
        }
        this.generalVisit(xMLCons);
    }

    public void visitFlwor(FLWR fLWR) {
        fLWR.nsTree.acceptVisitor(this);
    }

    public void visitConditionalExpr(Case case_) {
        this.generalVisit(case_);
    }

    public void visitQuantifiedExpr(Exists exists) {
        this.generalVisit(exists);
    }

    public void visitSequenceTypeExpr(TypeOp typeOp) {
        this.generalVisit(typeOp);
    }

    public void visitValidateExpr(ValidateExpr validateExpr) {
        validateExpr.kids[0].acceptVisitor(this);
    }

    public void visitTransformExpr(TransformExpr transformExpr) {
        VarExpr[] varExprArray = transformExpr.getLetExprs();
        if (varExprArray != null) {
            for (int i = 0; i < varExprArray.length; ++i) {
                this.visitVariableRef(varExprArray[i]);
            }
        }
        this.generalVisit(transformExpr);
    }

    public void visitInsertExpr(InsertExpr insertExpr) {
        this.generalVisit(insertExpr);
    }

    public void visitDeleteExpr(DeleteExpr deleteExpr) {
        this.generalVisit(deleteExpr);
    }

    public void visitReplaceNodeExpr(ReplaceNodeExpr replaceNodeExpr) {
        this.generalVisit(replaceNodeExpr);
    }

    public void visitReplaceValueExpr(ReplaceValueExpr replaceValueExpr) {
        this.generalVisit(replaceValueExpr);
    }

    public void visitRenameExpr(RenameExpr renameExpr) {
        this.generalVisit(renameExpr);
    }

    private void generalNSVisit(NodeSource nodeSource) {
        if (nodeSource.kids != null) {
            for (int i = 0; i < nodeSource.kids.length; ++i) {
                nodeSource.kids[i].acceptVisitor(this);
            }
        }
    }

    public void visitScan(Scan scan) {
        VarExpr[] varExprArray;
        VarExpr varExpr = scan.getOutVariable();
        if (varExpr != null) {
            this.visitVariableRef(varExpr);
        }
        if ((varExprArray = scan.getLetExprs()) != null) {
            for (int i = 0; i < varExprArray.length; ++i) {
                this.visitVariableRef(varExprArray[i]);
            }
        }
    }

    public void visitFilterProject(FilterProject filterProject) {
        this.generalNSVisit(filterProject);
        Expr expr = filterProject.getFilter();
        if (expr != null) {
            expr.acceptVisitor(this);
        }
        VarExpr varExpr = filterProject.getOutVariable();
        this.visitVariableRef(varExpr);
    }

    public void visitNLJ(NLJ nLJ) {
        this.generalNSVisit(nLJ);
    }

    public void visitSortNS(SortNS sortNS) {
        int n;
        sortNS.kids[0].acceptVisitor(this);
        if (sortNS.keys != null) {
            for (n = 0; n < sortNS.keys.length; ++n) {
                sortNS.keys[n].acceptVisitor(this);
            }
        }
        if (sortNS.nonKeys != null) {
            for (n = 0; n < sortNS.nonKeys.length; ++n) {
                sortNS.nonKeys[n].acceptVisitor(this);
            }
        }
    }
}

