/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery;

import java.io.Reader;
import java.sql.Connection;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.XMLItem;
import oracle.xml.xqxp.datamodel.XMLSequence;
import oracle.xquery.Configuration;
import oracle.xquery.PreparedXQuery;
import oracle.xquery.XQException;
import oracle.xquery.XQueryContext;
import oracle.xquery.exec.OXQResultSequence;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.XDBConnExpr;
import oracle.xquery.exec.XQueryUtils;

class XDBPreparedXQuery
extends PreparedXQuery {
    private boolean executed = false;

    XDBPreparedXQuery(Reader reader, XQueryContext xQueryContext, Configuration configuration) {
        this(XQueryUtils.read2String(reader), xQueryContext, configuration);
    }

    XDBPreparedXQuery(String string, XQueryContext xQueryContext, Configuration configuration) {
        Connection connection = (Connection)xQueryContext.getConnectionTable().get("default-oracle-connection");
        this.qryState = new QueryState(false);
        this.qryState.setMessage(xQueryContext.getMesg());
        this.qryState.setLazyDom(configuration.getLazyDom());
        this.qryState.setCloneDOM(configuration.getCloneDom());
        this.qryState.setPageManagerPool(xQueryContext.getPageManagerPool());
        this.qryState.setBaseURI(configuration.baseUri);
        this.qryState.attachExternalObject(configuration.extObj);
        this.qryState.setXQueryContextHandler(xQueryContext.getHandler());
        this.expr = new XDBConnExpr(connection, string);
    }

    public XMLSequence executeQuery() throws XQException {
        return this.executeQuery(false);
    }

    public OXMLSequence executeQuery(boolean bl) {
        this.executed = true;
        return new OXQResultSequence(this.qryState, this.expr);
    }

    public void setContextItem(XMLItem xMLItem) {
        this.checkIfExecuted();
        ((XDBConnExpr)this.expr).setContextItem((OXMLItem)xMLItem);
    }

    public void setString(QName qName, String string) {
        this.checkIfExecuted();
        ((XDBConnExpr)this.expr).setString(qName, string, this.qryState);
    }

    public void setFloat(QName qName, float f) {
        this.checkIfExecuted();
        ((XDBConnExpr)this.expr).setFloat(qName, f, this.qryState);
    }

    public void setInt(QName qName, int n) {
        this.checkIfExecuted();
        ((XDBConnExpr)this.expr).setInt(qName, n, this.qryState);
    }

    public void setBoolean(QName qName, boolean bl) {
        this.checkIfExecuted();
        ((XDBConnExpr)this.expr).setBoolean(qName, bl, this.qryState);
    }

    public void setNode(QName qName, XMLNode xMLNode) {
        this.checkIfExecuted();
        ((XDBConnExpr)this.expr).setNode(qName, xMLNode, this.qryState);
    }

    public void setItem(QName qName, OXMLItem oXMLItem) {
        this.checkIfExecuted();
        ((XDBConnExpr)this.expr).setItem(qName, oXMLItem);
    }

    private void checkIfExecuted() {
        if (this.executed) {
            ((XDBConnExpr)this.expr).cleanup();
            this.executed = false;
        }
    }
}

