/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.datamodel.XMLItem;
import oracle.xml.xqxp.datamodel.XMLSequence;
import oracle.xquery.Configuration;
import oracle.xquery.XQException;
import oracle.xquery.XQueryContext;
import oracle.xquery.comp.CompState;
import oracle.xquery.comp.LibraryModule;
import oracle.xquery.comp.SAXComp;
import oracle.xquery.comp.XQCompiler;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.OXQResultSequence;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.StaticTypingVisitor;
import oracle.xquery.exec.XQueryUtils;

public class PreparedXQuery {
    private SAXComp comp;
    protected QueryState qryState;
    private CompState compState;
    protected Expr expr;

    PreparedXQuery() {
    }

    PreparedXQuery(String string, XQueryContext xQueryContext, Configuration configuration, boolean bl) throws XQException {
        this(new StringReader(string), xQueryContext, configuration, bl, string);
    }

    PreparedXQuery(String string, XQueryContext xQueryContext, boolean bl) {
        this(string, xQueryContext, new Configuration(), bl);
    }

    PreparedXQuery(Reader reader, XQueryContext xQueryContext, Configuration configuration, boolean bl) throws XQException {
        this(reader, xQueryContext, configuration, bl, null);
    }

    PreparedXQuery(Reader reader, XQueryContext xQueryContext, Configuration configuration, boolean bl, String string) throws XQException {
        Object object;
        this.compState = new CompState();
        this.compState.setConnectionTable(xQueryContext.getConnectionTable());
        this.compState.setDataSourceTable(xQueryContext.getDatasourceTable());
        this.compState.setResolvers(xQueryContext.getNSResolvers());
        this.compState.setModulesTable(xQueryContext.getModulesTable());
        this.compState.setModuleResolver(xQueryContext.getModuleResolver());
        this.compState.setPrintWriter(configuration.xqxOut);
        this.compState.setStringWriter(configuration.xqxStr);
        this.compState.setOptimizerFlag(configuration.xqoption);
        this.compState.setXQueryX(bl);
        Reader reader2 = reader;
        if (!bl) {
            if (string != null) {
                this.compState.setXQueryString(string);
            } else {
                object = XQueryUtils.read2String(reader2);
                this.compState.setXQueryString((String)object);
                reader2 = new StringReader((String)object);
            }
        }
        this.qryState = new QueryState(false);
        this.qryState.setMessage(xQueryContext.getMesg());
        this.qryState.setLazyDom(configuration.getLazyDom());
        this.qryState.setCloneDOM(configuration.getCloneDom());
        this.qryState.setPageManagerPool(xQueryContext.getPageManagerPool());
        this.qryState.setBaseURI(configuration.baseUri);
        this.qryState.attachExternalObject(configuration.extObj);
        this.qryState.setXQueryContextHandler(xQueryContext.getHandler());
        this.qryState.setDocResolver(xQueryContext.getDocResolver());
        object = new StaticTypingVisitor(this.qryState);
        this.comp = new SAXComp(this.compState, this.qryState);
        XQCompiler xQCompiler = new XQCompiler(xQueryContext.getMesg());
        try {
            xQCompiler.parse(reader2, this.comp, bl);
        }
        catch (Exception exception) {
            throw new XQException(exception);
        }
    }

    PreparedXQuery(Reader reader, XQueryContext xQueryContext, boolean bl) throws XQException {
        this(reader, xQueryContext, new Configuration(), bl);
    }

    public PreparedXQuery(CompState compState, QueryState queryState, Reader reader) throws XQException {
        this.compState = new CompState();
        this.compState.setConnectionTable(compState.getConnectionTable());
        this.compState.setDataSourceTable(compState.getDataSourceTable());
        this.compState.setResolvers(compState.getResolvers());
        this.compState.setModulesTable(compState.getModulesTable());
        this.compState.setModuleResolver(compState.getModuleResolver());
        this.compState.setOptimizerFlag(compState.getOptimizerFlag());
        this.compState.setModuleHandler(compState.getModuleHandler());
        this.qryState = new QueryState(false);
        this.qryState.setMessage(queryState.getMesg());
        this.qryState.setBaseURI(queryState.getBaseURI());
        this.qryState.setXQueryContextHandler(queryState.getContextHandler());
        this.qryState.setDocResolver(queryState.getDocResolver());
        StaticTypingVisitor staticTypingVisitor = new StaticTypingVisitor(this.qryState);
        this.comp = new SAXComp(this.compState, this.qryState);
        XQCompiler xQCompiler = new XQCompiler(queryState.getMesg());
        try {
            xQCompiler.parse(reader, this.comp, false);
        }
        catch (Exception exception) {
            throw new XQException(exception);
        }
    }

    void setNLSParameters(String string, String string2, String string3) {
        if (this.qryState.getDefaultCollation() == null) {
            this.qryState.setDBCharSet(string3.toUpperCase());
            if (string != null) {
                String string4 = string.toUpperCase();
                this.qryState.setSortCollation(string4);
                if (string2.equalsIgnoreCase("BINARY")) {
                    this.qryState.setDefaultCollation("BINARY");
                } else {
                    this.qryState.setDefaultCollation(string4);
                }
            }
        }
    }

    public QName[] getExternalVarNames() {
        return this.comp.getAllExternalVariables();
    }

    public OXMLSequenceType getStaticExternalVarType(QName qName) {
        return this.comp.getStaticVariableExpr(qName).getDefinedType();
    }

    public void setContextItem(XMLItem xMLItem) {
        this.qryState.setContextItem(xMLItem);
        this.compState.setIniCtxitem(true);
    }

    public void setNode(QName qName, XMLNode xMLNode) {
        this.comp.setNode(qName, xMLNode);
    }

    public void setString(QName qName, String string) {
        this.comp.setString(qName, string);
    }

    public void setFloat(QName qName, float f) {
        this.comp.setFloat(qName, f);
    }

    public void setInt(QName qName, int n) {
        this.comp.setInt(qName, n);
    }

    public void setBoolean(QName qName, boolean bl) {
        this.comp.setBoolean(qName, bl);
    }

    public void setItem(QName qName, OXMLItem oXMLItem) {
        this.comp.setItem(qName, oXMLItem);
    }

    public OXMLItem createItem() {
        return this.qryState.createItem();
    }

    public void setSequence(QName qName, OXMLSequence oXMLSequence) {
        this.comp.setSequence(qName, oXMLSequence);
    }

    public OXMLSequence createSequence() {
        return this.qryState.createSequence();
    }

    void prepare() {
        this.normalizeExpr();
        if (!this.compState.noStaticTyping()) {
            this.staticTyping();
        }
    }

    public LibraryModule prepareLibraryModule() {
        if (!this.compState.noStaticTyping()) {
            this.qryState.staticTypingPrologVars();
            this.qryState.staticTypingFnDecls();
        }
        return this.comp.getLibraryModule();
    }

    private void normalizeExpr() {
        this.expr = this.comp.getExecTree();
        this.expr = this.expr.normalize();
    }

    private void optimizeQuery() {
        int n = this.compState.getOptimizerFlag();
        boolean bl = this.compState.getSchemaImp();
        boolean bl2 = this.compState.getIniCtxitem();
        boolean bl3 = this.compState.getHasRevAxis();
        boolean bl4 = this.compState.isXQueryX();
        boolean bl5 = this.compState.isXQueryPushdown();
        boolean bl6 = System.getProperty("java.vm.name").equals("JServer VM");
        OptimizeContext optimizeContext = null;
        String string = null;
        boolean bl7 = false;
        if (bl || bl2 || bl6 || bl3) {
            n |= 8;
            n &= 0xFFFFFFFE;
            bl5 = false;
        }
        if (bl7) {
            System.out.println("getExpr optimization flag: " + n);
            System.out.println("xquery pushdown value: " + bl5);
        }
        if (!bl4 && bl5) {
            string = this.compState.getXQueryString();
        }
        if (bl7) {
            System.out.println("topquery: " + string);
        }
        optimizeContext = new OptimizeContext(n, string, this.compState.getDefaultConnection());
        this.qryState.optimizeFnExprs(optimizeContext);
        this.expr = this.expr.optimizedrv(optimizeContext);
    }

    void staticTyping() {
        this.qryState.staticTypingPrologVars();
        this.qryState.staticTypingFnDecls();
        this.expr.acceptVisitor(this.qryState.getStaticTypingVisitor());
    }

    void printStaticTypeInfo() throws IOException {
        if (this.expr == null) {
            this.prepare();
        }
        System.out.println("static type of this expr:");
        StringBuffer stringBuffer = new StringBuffer();
        this.expr.printStaticType(stringBuffer);
        System.out.println(stringBuffer.toString());
        this.printPlan();
    }

    void setDebugFlag(int n) {
        this.qryState.setDebugFlag(n);
    }

    public OXMLSequence executeQuery(boolean bl) {
        if (this.expr == null) {
            this.prepare();
        }
        this.optimizeQuery();
        this.qryState.initializeFrame();
        OXQResultSequence oXQResultSequence = new OXQResultSequence(this.qryState, this.expr);
        if (bl) {
            oXQResultSequence.materializeMe();
            this.qryState.applyUpdates();
        }
        return oXQResultSequence;
    }

    public XMLSequence executeQuery() throws XQException {
        return this.executeQuery(this.comp.isUpdateExpr());
    }

    void printPlan() throws IOException {
        if (this.expr == null) {
            this.prepare();
        }
        System.out.println("\n<XQuery Execution Plan>");
        this.expr.toXML().print((OutputStream)System.out);
        System.out.println("</XQuery Execution Plan>\n");
    }

    QueryState getQueryState() {
        return this.qryState;
    }

    CompState getCompState() {
        return this.compState;
    }

    public Object retrieveExternalObject() {
        return this.qryState.retrieveExternalObject();
    }

    public void close() {
        this.qryState.close();
    }

    void cleanup() {
        this.qryState.cleanup();
    }
}

