/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapumpCloud.exp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapumpCloud.exp.CloudExport;
import oracle.dbtools.util.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Settings {
    private Document document = null;
    private Node rootNode = null;
    private String settingFile = Resource.raptorUser.getAbsolutePath() + File.separator;
    private static Object LOCK = new Object();
    protected String uuid = null;

    private Settings() {
    }

    public Settings(String string) {
        this.settingFile = this.settingFile + string + ".xml";
        this.uuid = string;
    }

    private void deleteFile() {
        try {
            if (new File(this.settingFile).exists()) {
                new File(this.settingFile).delete();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return;
        }
    }

    private boolean loadFromFile() {
        if (!this.readFromXml(this.settingFile)) {
            try {
                String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><DataPumpExport><ConnectionName/><JobName/>";
                string = string + "<Date/><Directory/><UUID/><Files/></DataPumpExport>";
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.settingFile), "UTF-8");
                outputStreamWriter.write(string);
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                return false;
            }
            if (!this.readFromXml(this.settingFile)) {
                return false;
            }
        }
        this.rootNode = this.getXmlChildNode(this.document, "DataPumpExport");
        return this.rootNode != this.document;
    }

    private void save() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            Properties properties = new Properties();
            properties.put("method", "xml");
            properties.put("encoding", "UTF-8");
            properties.put("indent", "yes");
            properties.put("cdata-section-elements", "ConnectionName JobName Date UUID Directory FileName Files File FileSize");
            transformer.setOutputProperties(properties);
            DOMSource dOMSource = new DOMSource(this.document);
            File file = new File(this.settingFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (fileOutputStream != null) {
                StreamResult streamResult = new StreamResult(fileOutputStream);
                transformer.transform(dOMSource, streamResult);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudExport getLastExport() {
        try {
            Object object = LOCK;
            synchronized (object) {
                this.loadFromFile();
                CloudExport cloudExport = new CloudExport(this.getNodeContent("ConnectionName"), this.getNodeContent("JobName"), this.getNodeContent("Date"), this.getNodeContent("Directory"), this.getNodeContent("UUID"), null, null);
                this.getListNodeContent("Files", cloudExport);
                return cloudExport;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastExport(CloudExport cloudExport) {
        try {
            Object object = LOCK;
            synchronized (object) {
                this.deleteFile();
                this.loadFromFile();
                this.setNodeContent("ConnectionName", cloudExport.getConnName());
                this.setNodeContent("JobName", cloudExport.getJName());
                this.setNodeContent("Date", cloudExport.getDate());
                this.setNodeContent("Directory", cloudExport.getDir());
                this.setNodeContent("UUID", cloudExport.getUUID());
                this.setListNodeContent("Files", cloudExport);
                this.save();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return;
        }
    }

    private ArrayList<Long> toArrayListLong(ArrayList<String> arrayList) {
        if (arrayList == null) {
            return null;
        }
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        try {
            for (String string : arrayList) {
                arrayList2.add(Long.parseLong(string));
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return arrayList2;
    }

    private Node getXmlChildNode(Node node, String string) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getFirstChild();
        do {
            if (node2.getLocalName() != string) continue;
            return node2;
        } while ((node2 = node2.getNextSibling()) != null);
        return node;
    }

    private String getNodeContent(String string) {
        if (this.rootNode == null) {
            return "";
        }
        Node node = this.getXmlChildNode(this.rootNode, string);
        if (node == this.rootNode) {
            return "";
        }
        return node.getTextContent();
    }

    private void getListNodeContent(String string, CloudExport cloudExport) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (this.rootNode == null) {
            return;
        }
        Node node = this.getXmlChildNode(this.rootNode, string);
        if (node == this.rootNode) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!(node2 instanceof Element) || !((Element)node2).getTagName().equals("File")) continue;
            NodeList nodeList2 = node2.getChildNodes();
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node3 = nodeList2.item(j);
                if (node3 instanceof Element && ((Element)node3).getTagName().equals("FileName")) {
                    arrayList.add(node3.getTextContent());
                }
                if (!(node3 instanceof Element) || !((Element)node3).getTagName().equals("FileSize")) continue;
                arrayList2.add(node3.getTextContent());
            }
        }
        cloudExport.setFileNames(arrayList);
        cloudExport.setFileSize(this.toArrayListLong(arrayList2));
    }

    private void setListNodeContent(String string, CloudExport cloudExport) {
        int n;
        if (this.rootNode == null) {
            return;
        }
        Node node = this.getXmlChildNode(this.rootNode, string);
        if (node == this.rootNode) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (n = n2 - 1; n > 0; --n) {
            node.removeChild(nodeList.item(n));
        }
        for (n = 0; n < cloudExport.getFileNames().size(); ++n) {
            Element element = this.rootNode.getOwnerDocument().createElement("File");
            Element element2 = this.rootNode.getOwnerDocument().createElement("FileName");
            element2.appendChild(this.document.createCDATASection(cloudExport.getFileNames().get(n)));
            Element element3 = this.rootNode.getOwnerDocument().createElement("FileSize");
            element3.appendChild(this.document.createCDATASection(cloudExport.getFileSize().get(n).toString()));
            element.appendChild(element2);
            element.appendChild(element3);
            node.appendChild(element);
        }
    }

    private void setNodeContent(String string, String string2) {
        if (this.rootNode == null) {
            return;
        }
        Node node = this.getXmlChildNode(this.rootNode, string);
        if (node == this.rootNode) {
            return;
        }
        node.appendChild(this.document.createCDATASection(string2));
    }

    private boolean readFromXml(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.parse(fileInputStream);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

