/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapumpCloud.exp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.border.TitledPane;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapumpCloud.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapumpCloud.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapumpCloud.common.CommonScheduleOptions;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.ui.controls.DateTimeEditor;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;

public class FlashbackPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox _toEnable = new JCheckBox();
    private JTextField _byScnText = new JTextField(10);
    private JLabel _byScnTextLabel = new JLabel(DpWizardArb.getString("EXP_BY_SCN"));
    private JLabel _byDateTextLabel = new JLabel(DpWizardArb.getString("EXP_BY_DATE"));
    private CalendarPopupButton _fromButton = new CalendarPopupButton();
    private CalendarPanel _fromCp;
    private DateTimeEditor _fromDe = new DateTimeEditor();
    private JRadioButton _byScn = new JRadioButton();
    private JRadioButton _byDate = new JRadioButton();
    private ExtractListModel _listModel = null;

    public FlashbackPane() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void addLabelandText(JPanel jPanel, int n, JLabel jLabel, JComponent jComponent, int n2, int n3) {
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)jComponent, new GridBagConstraints(1, n, n2, 1, 0.0, 0.0, 18, n3, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this._toEnable = new JCheckBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this._toEnable.setText(DpWizardArb.getString("EXP_ENABLE_FLASHBACK_OPTIONS"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._byScn);
        buttonGroup.add(this._byDate);
        this.calSetup();
        this._byScnText = new JTextField(10);
        this._byScnTextLabel = new JLabel(DpWizardArb.getString("EXP_BY_SCN"));
        this._byDateTextLabel = new JLabel(DpWizardArb.getString("EXP_BY_DATE"));
        jPanel.add((Component)this._byScnTextLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this._byScn, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this._byScnText, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)this._byDateTextLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        jPanel.add((Component)this._byDate, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        this.getCalPanel(jPanel, 2, 4);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        TitledPane titledPane = new TitledPane((Component)this._toEnable, (Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)titledPane, "Center");
        this.add((Component)jPanel3, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(3, 5, 3, 3), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 10.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 10.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._toEnable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    FlashbackPane.this.setLocalEnabled(true);
                } else {
                    FlashbackPane.this.setLocalEnabled(false);
                }
            }
        });
    }

    void setLocalEnabled(boolean bl) {
        this._byScnText.setEnabled(bl);
        this._byScnTextLabel.setEnabled(bl);
        this._byDateTextLabel.setEnabled(bl);
        this._fromButton.setEnabled(bl);
        this._fromCp.setEnabled(bl);
        this._fromDe.setEnabled(bl);
        this._byScn.setEnabled(bl);
        this._byDate.setEnabled(bl);
    }

    public static String getScn(ExtractListModel extractListModel) {
        String string = (String)extractListModel.getPropertyValue("EXP_SCN_ON_ENTRY");
        return string;
    }

    public void onEntry(TraversableContext traversableContext) {
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        if ((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_FLASHBACK_ENABLED", Boolean.FALSE) == Boolean.TRUE) {
            this._toEnable.setSelected(true);
            this.setLocalEnabled(true);
        } else {
            this._toEnable.setSelected(false);
            this.setLocalEnabled(false);
        }
        this._fromDe.setDate((Date)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_CALFROMFLASHBACK", CommonScheduleOptions.getSysdate(this._listModel)));
        if (Boolean.valueOf(DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_FLASHBACKSCNBOOL", Boolean.TRUE).equals(Boolean.TRUE)).booleanValue()) {
            this._byScn.setSelected(true);
        } else {
            this._byDate.setSelected(true);
        }
        this._byScnText.setText((String)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_FLASHBACKSCNTEXT", FlashbackPane.getScn(this._listModel)));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Boolean bl = Boolean.FALSE;
        if (this._toEnable.isSelected()) {
            bl = Boolean.TRUE;
        }
        this._listModel.setProperty("DP_EXP_FLASHBACK_ENABLED", (Object)bl);
        this._listModel.setProperty("DP_EXP_CALFROMFLASHBACK", (Object)this._fromDe.getDate());
        bl = Boolean.FALSE;
        if (this._byScn.isSelected() && this._toEnable.isSelected()) {
            bl = Boolean.TRUE;
            int n = -1;
            try {
                n = Integer.parseInt(this._byScnText.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            if (traversableContext.getDirection() == 1 && n < 0) {
                throw new TraversalException(DpWizardArb.getString("EXP_SCN_TEXT"), DpWizardArb.getString("EXP_SCN_TITLE"));
            }
        }
        this._listModel.setProperty("DP_EXP_FLASHBACKSCNBOOL", (Object)bl);
        this._listModel.setProperty("DP_EXP_FLASHBACKSCNTEXT", (Object)this._byScnText.getText());
    }

    private void getCalPanel(JPanel jPanel, int n, int n2) {
        this._fromCp = this._fromButton.getCalendarPanel();
        jPanel.add((Component)this._fromDe, new GridBagConstraints(n, n2, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 0), 0, 0));
        jPanel.add((Component)this._fromButton, new GridBagConstraints(n + 1, n2, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._fromButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlashbackPane.this._fromCp.setSelectedDate(FlashbackPane.this._fromDe.getDate());
                FlashbackPane.this._fromCp.makeDateVisible(FlashbackPane.this._fromDe.getDate());
            }
        });
    }

    private void calSetup() {
        this._fromCp = this._fromButton.getCalendarPanel();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        this._fromDe = new DateTimeEditor(new Date(calendar.getTimeInMillis()));
        this._fromCp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Date[] dateArray;
                if (actionEvent.getActionCommand() == "SELECTION_CHANGED_COMMAND" && (dateArray = FlashbackPane.this._fromCp.getSelectedDates()).length > 0) {
                    FlashbackPane.this._fromDe.setDate(dateArray[0]);
                }
            }
        });
        this._fromButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FlashbackPane.this._fromCp.setSelectedDate(FlashbackPane.this._fromDe.getDate());
                FlashbackPane.this._fromCp.makeDateVisible(FlashbackPane.this._fromDe.getDate());
            }
        });
    }
}

