/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.tablespace;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class ReadManagementAction
extends ActionDialog {
    private static final String TABLESPACE = "Tablespace";
    private static final String READONLY = "readonly";
    private static final String READWRITE = "readwrite";
    private String _status = null;

    protected String getTitle() {
        if (this._status.equals("ONLINE")) {
            return DbaNavigatorResources.getString("READONLY_LABEL");
        }
        if (this._status.equals("READ ONLY")) {
            return DbaNavigatorResources.getString("READWRITE_LABEL");
        }
        return DbaNavigatorResources.getString("INVALID_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TNAME", this.getDBObject().getObjectName());
        this._status = DBUtil.getInstance((Connection)connection).executeOracleReturnOneCol("select status from dba_tablespaces where tablespace_name = :TNAME", hashMap);
        boolean bl = false;
        boolean bl2 = false;
        if (this._status.equals("ONLINE")) {
            bl = true;
        } else if (this._status.equals("READ ONLY")) {
            bl2 = true;
        }
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(TABLESPACE, DbaNavigatorResources.getString("TABLESPACE_LABEL"), this.getDBObject().getObjectName());
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(READONLY, DbaNavigatorResources.getString("READONLY_LABEL"), bl);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(READWRITE, DbaNavigatorResources.getString("READWRITE_LABEL"), bl2);
        textBoxActionControl.enableUI(false);
        booleanCheckBoxActionControl.enableUI(bl);
        booleanCheckBoxActionControl2.enableUI(bl2);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER TABLESPACE ");
        stringBuffer.append(DBUtil.addDoubleQuote((String)values.get(TABLESPACE)));
        stringBuffer.append(" ");
        if (Boolean.parseBoolean(values.get(READONLY))) {
            stringBuffer.append("\n READ ONLY");
        } else if (Boolean.parseBoolean(values.get(READWRITE))) {
            stringBuffer.append("\n READ WRITE");
        } else {
            return DbaNavigatorResources.getString("NO_SELECTION");
        }
        return stringBuffer.toString();
    }
}

