/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupactionjobs.ConfigurationGenerator;
import oracle.dbtools.raptor.dba.navigator.actions.backupactionjobs.NewSelectionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FilePathActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.dialogs.MessageDialog;

public class RMANScriptProcessorActionControl
extends ActionControl {
    public static final String PROCESSING_TYPE = "RMANScriptProcessor/Type";
    public static final String SCRIPT_FILE_PATH = "RMANScriptProcessor/FilePath";
    public static final String CREDENTIAL = "RMANScriptProcessor/Credential";
    public static final String JOB_NAME = "RMANScriptProcessor/Job";
    public static final String CONFIGURED = "RMANScriptProcessor/Configured";
    public static final String SAVE_TO_FILE = DbaNavigatorResources.getString("SAVE_TO_FILE");
    public static final String RUN_SCHEDULER_JOB = DbaNavigatorResources.getString("RUN_SCHEDULER_JOB");
    public static final String DEFAULT_CREDENTIAL = "DBA.DEFAULT_CREDENTIAL";
    public static final String DEFAULT_SAVE_DIR = "DBA.DEFAULT_SAVE_DIR";
    private ComboBoxActionControl processingTypeCtl;
    private TextBoxActionControl jobNameCtl;
    private ActionControl credentialCtl;
    private FilePathActionControl filePathCtl;
    private JPanel ui;
    private boolean schedulerActionConfigured;
    private boolean inEnableControls = false;
    private boolean schedulerProcessingSupported = false;
    private ValidityListener validityListener;
    private boolean validWhenLastChecked;

    public RMANScriptProcessorActionControl(Connection connection, String string) {
        this(connection, string, true);
    }

    public RMANScriptProcessorActionControl(Connection connection, String string, boolean bl) {
        this(connection, string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMANScriptProcessorActionControl(final Connection connection, String string, final boolean bl, boolean bl2) {
        super("RMANScriptProcessor", null);
        JComponent jComponent;
        Serializable serializable;
        int n;
        Object object;
        Serializable serializable2;
        Object object2;
        Serializable serializable3;
        Object object3;
        String string2;
        this.schedulerProcessingSupported = DbaUtil.isSysdbaRole(connection) && DbaUtil.getDatabaseMajorVersion(connection) >= 11;
        String[] stringArray = null;
        String string3 = null;
        String string4 = this.schedulerProcessingSupported ? DbaUtil.getServerHome(connection) : "";
        String string5 = "/";
        if (string4.contains("\\")) {
            string5 = "\\";
        }
        String string6 = this.schedulerProcessingSupported ? (string4.endsWith(string5) ? string4 + "sqldeveloper" + string5 + "dbascripts" + string5 + "marker" : string4 + string5 + "sqldeveloper" + string5 + "dbascripts" + string5 + "marker") : (string2 = "");
        if (this.schedulerProcessingSupported && Connections.getInstance().lock(connection)) {
            object3 = null;
            try {
                serializable3 = new HashMap();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object3 = dBUtil.executeOracleQuery(RMANScriptProcessorActionControl.getQuery(connection, "getCredentials"), serializable3);
                if (object3 != null) {
                    object2 = Preferences.getPreferences().getProperties().getString(DEFAULT_CREDENTIAL);
                    ResultSet resultSet = object3.getResultSet();
                    serializable2 = new ArrayList<String>();
                    while (resultSet.next()) {
                        object = resultSet.getString("CREDENTIAL_NAME");
                        ((ArrayList)serializable2).add(object);
                        if (!((String)object).equals(object2)) continue;
                        string3 = object2;
                    }
                    if (string3 == null && ((ArrayList)serializable2).size() > 0) {
                        string3 = (String)((ArrayList)serializable2).get(0);
                    }
                    stringArray = new String[((ArrayList)serializable2).size()];
                    ((ArrayList)serializable2).toArray(stringArray);
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (object3 != null) {
                    object3.close();
                }
                Connections.getInstance().unlock(connection);
            }
            this.schedulerActionConfigured = this.isSchedulerActionConfigured(connection, string3, string2);
        }
        this.processingTypeCtl = new ComboBoxActionControl(PROCESSING_TYPE, !bl2 ? DbaNavigatorResources.getString("PROCESSING_TYPE_LABEL") : null, new String[]{RUN_SCHEDULER_JOB, SAVE_TO_FILE}, this.schedulerProcessingSupported && bl && this.schedulerActionConfigured ? RUN_SCHEDULER_JOB : SAVE_TO_FILE);
        if (this.schedulerProcessingSupported) {
            object3 = new NewSelectionControl(CREDENTIAL, DbaNavigatorResources.getString("CREDENTIAL_LABEL"), stringArray, new NewSelectionControl.NewListener(){

                @Override
                public String getButtonLabel() {
                    return DbaNavigatorResources.getString("NEW_CREDENTIAL_LABEL");
                }

                @Override
                public String getNewComboItem() {
                    return DbaUtil.createNewCredential(connection);
                }
            });
            ((NewSelectionControl)((Object)object3)).set(string3);
            this.credentialCtl = object3;
        }
        this.jobNameCtl = new TextBoxActionControl(JOB_NAME, DbaNavigatorResources.getString("JOB_NAME_LABEL"), "SQLDEV$JOB_" + System.currentTimeMillis());
        this.filePathCtl = new FilePathActionControl(SCRIPT_FILE_PATH, DbaNavigatorResources.getString("SAVE_FILE_LABEL"), RMANScriptProcessorActionControl.defaultFilePath(string));
        this.jobNameCtl.setEditable(false);
        object3 = new JPanel(new GridBagLayout());
        if (!bl2) {
            ((JComponent)object3).setBorder(new LineBorder(Color.LIGHT_GRAY));
        }
        ((Container)object3).add((Component)new JLabel(this.filePathCtl.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)object3).add((Component)this.filePathCtl.getUI(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        ((Container)object3).add((Component)new JLabel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        serializable3 = new JPanel(new GridBagLayout());
        if (!bl2) {
            ((JComponent)serializable3).setBorder(new LineBorder(Color.LIGHT_GRAY));
        }
        int n2 = 0;
        if (bl2) {
            ((Container)serializable3).add(DbaUtil.createMultiLineLabel((JPanel)serializable3, DbaNavigatorResources.getString("BACKUP_WIZ_CREDENTIAL_HELP_LABEL")), new GridBagConstraints(0, n2++, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (this.credentialCtl != null) {
            ((Container)serializable3).add(new JLabel(this.credentialCtl.getPrompt()), new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            ((Container)serializable3).add(this.credentialCtl.getUI(), new GridBagConstraints(1, n2++, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        object2 = new ArrayList();
        int n3 = n2;
        if (!bl2) {
            serializable2 = new JLabel(this.jobNameCtl.getPrompt());
            object = this.jobNameCtl.getUI();
            ((ArrayList)object2).add(serializable2);
            ((ArrayList)object2).add(object);
            ((Container)serializable3).add((Component)serializable2, new GridBagConstraints(0, n3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            ((Container)serializable3).add((Component)object, new GridBagConstraints(1, n3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        serializable2 = new ArrayList();
        object = null;
        if (bl2) {
            n = n2;
            serializable = new JPanel(new GridBagLayout());
            ((Container)serializable).add(new JLabel(DbaNavigatorResources.getIcon("EXPLANATION_ICON"), 2), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            jComponent = DbaUtil.createMultiLineLabel((JPanel)serializable3, DbaNavigatorResources.getString("BACKUP_WIZ_CONFIG_HELP_LABEL"));
            ((Container)serializable).add(jComponent, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
            object = new JButton(DbaNavigatorResources.getString("BACKUP_WIZ_CONFIG_BUTTON_LABEL"));
            ((ArrayList)serializable2).add(serializable);
            ((ArrayList)serializable2).add(object);
            ((Container)serializable3).add((Component)serializable, new GridBagConstraints(0, n++, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            ((Container)serializable3).add((Component)object, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        } else {
            n = n2;
            serializable = new JLabel(DbaNavigatorResources.getString("UNABLE_TO_RUN_RMAN"), DbaNavigatorResources.getIcon("EXPLANATION_ICON"), 2);
            ((ArrayList)serializable2).add(serializable);
            ((Container)serializable3).add((Component)serializable, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        Object object4 = object;
        this.enableControls(connection, bl, string2, this.processingTypeCtl, (ActionControl)this.jobNameCtl, this.credentialCtl, (ActionControl)this.filePathCtl, (List<Component>)object2, (List<Component>)((Object)serializable2), (JButton)object4);
        if (this.credentialCtl != null) {
            this.credentialCtl.addPropertyChangeListener(new PropertyChangeListener((ArrayList)object2, (ArrayList)serializable2, (JButton)object4){
                final /* synthetic */ ArrayList val$okComponents;
                final /* synthetic */ ArrayList val$warningComponents;
                final /* synthetic */ JButton val$configButton;
                {
                    this.val$okComponents = arrayList;
                    this.val$warningComponents = arrayList2;
                    this.val$configButton = jButton;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RMANScriptProcessorActionControl.this.enableControls(connection, bl, string2, RMANScriptProcessorActionControl.this.processingTypeCtl, (ActionControl)RMANScriptProcessorActionControl.this.jobNameCtl, RMANScriptProcessorActionControl.this.credentialCtl, (ActionControl)RMANScriptProcessorActionControl.this.filePathCtl, this.val$okComponents, this.val$warningComponents, this.val$configButton);
                }
            });
        }
        this.processingTypeCtl.addPropertyChangeListener(new PropertyChangeListener((ArrayList)object2, (ArrayList)serializable2, (JButton)object4){
            final /* synthetic */ ArrayList val$okComponents;
            final /* synthetic */ ArrayList val$warningComponents;
            final /* synthetic */ JButton val$configButton;
            {
                this.val$okComponents = arrayList;
                this.val$warningComponents = arrayList2;
                this.val$configButton = jButton;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RMANScriptProcessorActionControl.this.enableControls(connection, bl, string2, RMANScriptProcessorActionControl.this.processingTypeCtl, (ActionControl)RMANScriptProcessorActionControl.this.jobNameCtl, RMANScriptProcessorActionControl.this.credentialCtl, (ActionControl)RMANScriptProcessorActionControl.this.filePathCtl, this.val$okComponents, this.val$warningComponents, this.val$configButton);
            }
        });
        if (object4 != null) {
            ((AbstractButton)object4).addActionListener(new ActionListener((ArrayList)object2, (ArrayList)serializable2, (JButton)object4){
                final /* synthetic */ ArrayList val$okComponents;
                final /* synthetic */ ArrayList val$warningComponents;
                final /* synthetic */ JButton val$configButton;
                {
                    this.val$okComponents = arrayList;
                    this.val$warningComponents = arrayList2;
                    this.val$configButton = jButton;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RaptorTask<Void> raptorTask = new RaptorTask<Void>(UiResources.getString((String)"PERFORM_ACTION"), true, IRaptorTaskRunMode.MODAL){

                        protected Void doWork() throws TaskException {
                            if (RMANScriptProcessorActionControl.this.configureServer(connection)) {
                                RMANScriptProcessorActionControl.this.enableControls(connection, bl, string2, RMANScriptProcessorActionControl.this.processingTypeCtl, (ActionControl)RMANScriptProcessorActionControl.this.jobNameCtl, RMANScriptProcessorActionControl.this.credentialCtl, (ActionControl)RMANScriptProcessorActionControl.this.filePathCtl, val$okComponents, val$warningComponents, val$configButton);
                                if (RMANScriptProcessorActionControl.this.validWhenLastChecked) {
                                    MessageDialog.information((Component)RMANScriptProcessorActionControl.this.ui, (Object)DbaNavigatorResources.getString("BACKUP_WIZ_CONFIG_SERVER_SUCCESS"), (String)DbaNavigatorResources.getString("SUCCESS_TITLE"), null);
                                } else {
                                    MessageDialog.error((Component)RMANScriptProcessorActionControl.this.ui, (Object)DbaNavigatorResources.getString("BACKUP_WIZ_CONFIG_SERVER_FAILURE"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
                                }
                            } else {
                                MessageDialog.error((Component)RMANScriptProcessorActionControl.this.ui, (Object)DbaNavigatorResources.getString("BACKUP_NO_WINDOWS_EXECUTION"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
                            }
                            return null;
                        }
                    };
                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                }
            });
        }
        serializable = new CardLayout();
        jComponent = new JPanel((LayoutManager)((Object)serializable));
        jComponent.add((Component)object3, SAVE_TO_FILE);
        jComponent.add((Component)serializable3, RUN_SCHEDULER_JOB);
        ((CardLayout)serializable).show(jComponent, this.processingTypeCtl.getValue().get());
        this.processingTypeCtl.addPropertyChangeListener(new PropertyChangeListener((CardLayout)serializable, (JPanel)jComponent){
            final /* synthetic */ CardLayout val$cardStack;
            final /* synthetic */ JPanel val$cardStackPanel;
            {
                this.val$cardStack = cardLayout;
                this.val$cardStackPanel = jPanel;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.val$cardStack.show(this.val$cardStackPanel, RMANScriptProcessorActionControl.this.processingTypeCtl.getValue().get());
            }
        });
        this.ui = new JPanel(new GridBagLayout());
        this.ui.add((Component)new JLabel(this.processingTypeCtl.getPrompt()), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.ui.add(this.processingTypeCtl.getUI(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.ui.add((Component)jComponent, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public ActionControl getProcessingTypeCtl() {
        return this.processingTypeCtl;
    }

    public ActionControl getJobNameCtl() {
        return this.jobNameCtl;
    }

    public ActionControl getCredentialCtl() {
        return this.credentialCtl;
    }

    public ActionControl getFilePathCtl() {
        return this.filePathCtl;
    }

    public boolean isSchedulerProcessingSupported() {
        return this.schedulerProcessingSupported;
    }

    public Component getUI() {
        return this.ui;
    }

    public ActionControl.Value getValue() {
        ActionControl.Value value = new ActionControl.Value();
        value.add("Type", this.processingTypeCtl.getValue().get());
        value.add("Job", this.jobNameCtl.getValue().get());
        value.add("Credential", this.credentialCtl != null ? this.credentialCtl.getValue().get() : "");
        value.add("FilePath", this.filePathCtl.getValue().get());
        value.add("Configured", Boolean.toString(this.schedulerActionConfigured));
        return value;
    }

    public void setEditable(boolean bl) {
        this.processingTypeCtl.setEditable(bl);
        this.jobNameCtl.setEditable(bl);
        if (this.credentialCtl != null) {
            this.credentialCtl.setEditable(bl);
        }
        this.filePathCtl.setEditable(bl);
    }

    public void enableUI(boolean bl) {
        this.processingTypeCtl.enableUI(bl);
        this.jobNameCtl.enableUI(bl);
        if (this.credentialCtl != null) {
            this.credentialCtl.enableUI(bl);
        }
        this.filePathCtl.enableUI(bl);
    }

    public boolean isUIEnabled() {
        return this.processingTypeCtl.isUIEnabled();
    }

    public void setValidityListener(ValidityListener validityListener) {
        this.validityListener = validityListener;
        this.validityListener.onChange(this.validWhenLastChecked);
    }

    public static String getJobName(ActionDialog.Lookup lookup) {
        String string = null;
        String string2 = lookup.get(PROCESSING_TYPE);
        if (string2 != null && string2.equals(RUN_SCHEDULER_JOB)) {
            string = lookup.get(JOB_NAME);
        }
        return string;
    }

    public static void updateDefaultCredential(String string) {
        Preferences.getPreferences().getProperties().putString(DEFAULT_CREDENTIAL, string);
    }

    public static void updateDefaultSaveDir(String string) {
        File file = new File(string);
        File file2 = file.getParentFile();
        Preferences.getPreferences().getProperties().putString(DEFAULT_SAVE_DIR, file2.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSchedulerActionConfigured(Connection connection, String string, String string2) {
        boolean bl;
        boolean bl2 = bl = string != null;
        if (bl && Connections.getInstance().lock(connection)) {
            String string3 = RMANScriptProcessorActionControl.getQuery(connection, "retrieveMarker");
            try {
                CallableStatement callableStatement = connection.prepareCall(string3);
                callableStatement.setString("MARKER_PATH", string2);
                callableStatement.setString("CREDENTIAL", string);
                callableStatement.registerOutParameter("MARKER_CONTENT", 2005);
                callableStatement.execute();
                Clob clob = callableStatement.getClob("MARKER_CONTENT");
                Reader reader = clob.getCharacterStream();
                reader.read();
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configureServer(Connection connection) {
        boolean bl = true;
        ConfigurationGenerator configurationGenerator = new ConfigurationGenerator(connection);
        if (!configurationGenerator.isUnix()) {
            bl = false;
        }
        String string = this.credentialCtl != null ? this.credentialCtl.getValue().get() : null;
        String string2 = configurationGenerator.generateConfigurationScript(string);
        if (Connections.getInstance().lock(connection)) {
            try {
                HashMap hashMap = new HashMap();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                dBUtil.execute(string2, hashMap);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableControls(Connection connection, boolean bl, String string, ComboBoxActionControl comboBoxActionControl, ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, List<Component> list, List<Component> list2, JButton jButton) {
        if (!this.inEnableControls) {
            this.inEnableControls = true;
            try {
                String string2;
                if (actionControl2 != null) {
                    string2 = actionControl2.getValue().get();
                    this.schedulerActionConfigured = this.isSchedulerActionConfigured(connection, string2, string);
                }
                if (this.schedulerProcessingSupported && bl) {
                    if (this.schedulerActionConfigured) {
                        comboBoxActionControl.enableUI(true);
                        if (comboBoxActionControl.getValue().get().equals(RUN_SCHEDULER_JOB)) {
                            actionControl2.enableUI(true);
                            actionControl.enableUI(true);
                            actionControl3.enableUI(false);
                            this.setVisible(list, true);
                            this.setVisible(list2, false);
                        } else {
                            actionControl2.enableUI(false);
                            actionControl.enableUI(false);
                            actionControl3.enableUI(true);
                        }
                        this.validWhenLastChecked = true;
                        if (this.validityListener != null) {
                            this.validityListener.onChange(this.validWhenLastChecked);
                        }
                    } else {
                        comboBoxActionControl.enableUI(true);
                        if (actionControl2 != null) {
                            actionControl2.enableUI(true);
                        }
                        actionControl.enableUI(true);
                        actionControl3.enableUI(true);
                        this.setVisible(list, false);
                        this.setVisible(list2, true);
                        boolean bl2 = this.validWhenLastChecked = !comboBoxActionControl.getValue().get().equals(RUN_SCHEDULER_JOB);
                        if (this.validityListener != null) {
                            this.validityListener.onChange(this.validWhenLastChecked);
                        }
                    }
                } else {
                    comboBoxActionControl.set(SAVE_TO_FILE);
                    comboBoxActionControl.enableUI(false);
                    if (actionControl2 != null) {
                        actionControl2.enableUI(false);
                    }
                    actionControl.enableUI(false);
                    actionControl3.enableUI(true);
                    this.validWhenLastChecked = true;
                    if (this.validityListener != null) {
                        this.validityListener.onChange(this.validWhenLastChecked);
                    }
                }
                if (jButton != null) {
                    string2 = actionControl2 != null ? actionControl2.getValue().get() : null;
                    jButton.setEnabled(string2 != null && !string2.equals(""));
                }
            }
            finally {
                this.inEnableControls = false;
            }
        }
    }

    private void setVisible(List<Component> list, boolean bl) {
        for (Component component : list) {
            component.setVisible(bl);
        }
    }

    private static String defaultFilePath(String string) {
        Object object;
        String string2 = Preferences.getPreferences().getProperties().getString(DEFAULT_SAVE_DIR);
        File file = null;
        file = string2 != null && !string2.equals("") ? new File(string2) : ((object = Ide.getTrueUserHomeDirectory()) != null ? new File((String)object) : new File("."));
        object = new File(file, string);
        return ((File)object).getAbsolutePath();
    }

    private static String getQuery(Connection connection, String string) {
        return Utils.getQuery(RMANScriptProcessorActionControl.class, (Connection)connection, (String)string);
    }

    public static interface ValidityListener {
        public void onChange(boolean var1);
    }
}

