/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.resourcemanagersettings;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class SelectActivePlan
extends ActionDialog {
    private static final String CURRENTLYACTIVE = "CurrentlyActive";
    private static final String PLANNAME = "PlanName";

    protected String getTitle() {
        return DbaNavigatorResources.getString("SELECT_ACTIVE_PLAN_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Object object;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        String string = "";
        HashMap hashMap = new HashMap();
        if (Connections.getInstance().lock(connection)) {
            textBoxActionControl = null;
            try {
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                textBoxActionControl = dBUtil.executeOracleQuery(this.getQuery(connection, "getActivePlan"), hashMap);
                if (textBoxActionControl != null) {
                    object = textBoxActionControl.getResultSet();
                    while (object.next()) {
                        string = object.getString("ACTIVE_PLAN");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (textBoxActionControl != null) {
                    textBoxActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        textBoxActionControl = new TextBoxActionControl(CURRENTLYACTIVE, DbaNavigatorResources.getString("CURRENTLY_ACTIVE_LABEL"), string);
        textBoxActionControl.setEditable(false);
        dBUtil = new SqlComboBoxActionControl(PLANNAME, DbaNavigatorResources.getString("NEW_ACTIVE_PLAN_LABEL"), connection, this.getQuery(connection, "getActivatablePlans"), hashMap, null);
        object = new ArrayList();
        ((ArrayList)object).add(textBoxActionControl);
        ((ArrayList)object).add(dBUtil);
        return object;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER SYSTEM SET");
        stringBuffer.append("\nRESOURCE_MANAGER_PLAN = '");
        stringBuffer.append(values.get(PLANNAME));
        stringBuffer.append("'");
        return stringBuffer.toString();
    }
}

