/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.recovery;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TableActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class BlockRecoveryAction
extends ActionDialog {
    public static final String METHOD = "METHOD";
    public static final String BLOCKS = "BLOCKS";
    public static final String CORRUPTION_LIST_METHOD = DbaNavigatorResources.getString("CORRUPTION_LIST_METHOD");
    public static final String DATAFILES_METHOD = DbaNavigatorResources.getString("DATAFILES_METHOD");
    public static final String TABLESPACES_METHOD = DbaNavigatorResources.getString("TABLESPACES_METHOD");

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("BLOCK_RECOVERY_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        ResultSet resultSet;
        Object object;
        Object object2;
        ResultSetWrapper resultSetWrapper;
        ResultSetWrapper resultSetWrapper2;
        ArrayList<BlockRow> arrayList = new ArrayList<BlockRow>();
        if (Connections.getInstance().lock(connection)) {
            resultSetWrapper2 = null;
            try {
                resultSetWrapper = new HashMap();
                object2 = DBUtil.getInstance((Connection)connection);
                object2.setRaiseError(true);
                resultSetWrapper2 = object2.executeOracleQuery(this.getQuery(connection, "getTablespacesBlockInfo"), resultSetWrapper);
                if (resultSetWrapper2 != null) {
                    object = resultSetWrapper2.getResultSet();
                    while (object.next()) {
                        arrayList.add(new BlockRow(object.getString("NAME"), object.getString("ITEMNO")));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper2 != null) {
                    resultSetWrapper2.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        resultSetWrapper2 = new ArrayList();
        if (Connections.getInstance().lock(connection)) {
            resultSetWrapper = null;
            try {
                object2 = new HashMap();
                object = DBUtil.getInstance((Connection)connection);
                object.setRaiseError(true);
                resultSetWrapper = object.executeOracleQuery(this.getQuery(connection, "getDatafilesBlockInfo"), (Map)object2);
                if (resultSetWrapper != null) {
                    resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        resultSetWrapper2.add(new BlockRow(resultSet.getString("NAME"), resultSet.getString("ITEMNO")));
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        resultSetWrapper = new ArrayList();
        object2 = new ArrayList();
        ((ArrayList)object2).add(DbaNavigatorResources.getString("ITEM_NAME_COL"));
        ((ArrayList)object2).add(DbaNavigatorResources.getString("ITEM_NUMBER_COL"));
        ((ArrayList)object2).add(DbaNavigatorResources.getString("BLOCK_IDS_COL"));
        object = new ComboBoxActionControl(METHOD, DbaNavigatorResources.getString("RECOVERY_METHOD_LABEL"), new String[]{CORRUPTION_LIST_METHOD, DATAFILES_METHOD, TABLESPACES_METHOD}, CORRUPTION_LIST_METHOD);
        resultSet = new TableActionControl(BLOCKS, DbaNavigatorResources.getString("BLOCK_IDS_LABEL"), (List)object2, (List)resultSetWrapper, 4);
        resultSet.setCellFormat(new TableActionControl.CellFormat(){

            public Object format(Object object, int n) {
                if (n != 2) {
                    return object;
                }
                StringBuffer stringBuffer = new StringBuffer();
                String string = object.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                boolean bl = true;
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        String string2 = stringTokenizer.nextToken().trim();
                        Integer.parseInt(string2);
                        if (bl) {
                            stringBuffer.append(string2);
                            bl = false;
                            continue;
                        }
                        stringBuffer.append(", ");
                        stringBuffer.append(string2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                return stringBuffer.toString();
            }
        });
        resultSet.enableUI(false);
        object.addPropertyChangeListener(new PropertyChangeListener((ActionControl)object, (TableActionControl)resultSet, (ArrayList)resultSetWrapper, (ArrayList)resultSetWrapper2, arrayList){
            final /* synthetic */ ActionControl val$methodCtl;
            final /* synthetic */ TableActionControl val$blocksCtl;
            final /* synthetic */ ArrayList val$noRows;
            final /* synthetic */ ArrayList val$datafileRows;
            final /* synthetic */ ArrayList val$tablespaceRows;
            {
                this.val$methodCtl = actionControl;
                this.val$blocksCtl = tableActionControl;
                this.val$noRows = arrayList;
                this.val$datafileRows = arrayList2;
                this.val$tablespaceRows = arrayList3;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = this.val$methodCtl.getValue().get();
                if (string.equals(CORRUPTION_LIST_METHOD)) {
                    this.val$blocksCtl.enableUI(false);
                    this.val$blocksCtl.setRows((List)this.val$noRows);
                } else if (string.equals(DATAFILES_METHOD)) {
                    this.val$blocksCtl.enableUI(true);
                    this.val$blocksCtl.setRows((List)this.val$datafileRows);
                } else if (string.equals(TABLESPACES_METHOD)) {
                    this.val$blocksCtl.enableUI(true);
                    this.val$blocksCtl.setRows((List)this.val$tablespaceRows);
                }
            }
        });
        ArrayList<ActionControl> arrayList2 = new ArrayList<ActionControl>();
        arrayList2.add((ActionControl)object);
        arrayList2.add((ActionControl)resultSet);
        arrayList2.add((ActionControl)new SeperatorActionControl());
        arrayList2.add(new RMANScriptProcessorActionControl(connection, "sqldev.rman", DbaUtil.isArchiveLogMode(connection)));
        return arrayList2;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RUN {\n");
        stringBuffer.append("RECOVER");
        String string = values.get(METHOD);
        if (string.equals(CORRUPTION_LIST_METHOD)) {
            stringBuffer.append(" CORRUPTION LIST;\n");
        } else if (string.equals(DATAFILES_METHOD)) {
            List list = values.getList(BLOCKS, DbaNavigatorResources.getString("ITEM_NUMBER_COL"));
            List list2 = values.getList(BLOCKS, DbaNavigatorResources.getString("BLOCK_IDS_COL"));
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list2.get(i);
                if (string2 == null || string2.equals("")) continue;
                stringBuffer.append(" DATAFILE ");
                stringBuffer.append((String)list.get(i));
                stringBuffer.append(" BLOCK ");
                stringBuffer.append(string2);
            }
            stringBuffer.append(";\n");
        } else if (string.equals(TABLESPACES_METHOD)) {
            List list = values.getList(BLOCKS, DbaNavigatorResources.getString("ITEM_NAME_COL"));
            List list3 = values.getList(BLOCKS, DbaNavigatorResources.getString("BLOCK_IDS_COL"));
            for (int i = 0; i < list.size(); ++i) {
                String string3 = (String)list3.get(i);
                if (string3 == null || string3.equals("")) continue;
                stringBuffer.append(" TABLESPACE ");
                stringBuffer.append((String)list.get(i));
                stringBuffer.append(" DBA ");
                stringBuffer.append(string3);
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    private class BlockRow
    implements TableActionControl.Row {
        private String[] _cols;

        BlockRow(String string, String string2) {
            this._cols = new String[]{string, string2, ""};
        }

        String[] getCols() {
            return this._cols;
        }

        public String getValue(int n) {
            return this._cols[n];
        }

        public boolean isValueEditable(int n) {
            return n == 2;
        }

        public void setValue(int n, String string) {
            this._cols[n] = string;
        }
    }
}

