/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class UnplugPdbsAction
extends ActionDialog {
    private static final String PDB_NAME = "PdbName";
    private static final String XML_FILE = "XmlFile";

    protected String getTitle() {
        return DbaNavigatorResources.getString("UNPLUG_PDB_TITLE");
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected List<ActionControl> createControls(Connection connection) {
        TextBoxActionControl textBoxActionControl;
        TextBoxActionControl textBoxActionControl2;
        Operation operation = this.getOperation();
        if (operation == Operation.PDBS) {
            textBoxActionControl2 = new TextBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), this.getObjectName());
            textBoxActionControl2.setEditable(false);
            textBoxActionControl = new TextBoxActionControl(XML_FILE, DbaNavigatorResources.getString("XML_FILE"), this.getObjectName() + ".XML");
        } else {
            textBoxActionControl2 = new SqlComboBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), connection, "select name from v$pdbs");
            textBoxActionControl = new TextBoxActionControl(XML_FILE, DbaNavigatorResources.getString("XML_FILE"), "PDB.XML");
        }
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER PLUGGABLE DATABASE " + values.get(PDB_NAME));
        stringBuffer.append(" UNPLUG INTO '");
        stringBuffer.append(values.get(XML_FILE) + "';\n");
        stringBuffer.append("DROP PLUGGABLE DATABASE " + values.get(PDB_NAME) + " KEEP DATAFILES;\n");
        return stringBuffer.toString();
    }

    private static enum Operation {
        CONTAINER,
        PDBS;

    }
}

