/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.FileNameConvertControl;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.PdbStorageControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class PlugPdbsAction
extends ActionDialog {
    private static final String PDB_NAME = "PdbName";
    private static final String AS_CLONE = "AsClone";
    private static final String FILE_NAME = "FileName";
    private static final String SOURCE_CONVERT = "SourceConvert";
    private static final String FILE_CONVERT = "FileConvert";
    private static final String PDB_ACTION = "PdbAction";
    private static final String PDB_STORAGE = "PdbStorage";

    protected String getTitle() {
        return DbaNavigatorResources.getString("PLUG_PDB_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), "NEW_PDB");
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(AS_CLONE, "AS CLONE", false);
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(FILE_NAME, DbaNavigatorResources.getString("XML_FILE"), "FileName.xml");
        FileNameConvertControl fileNameConvertControl = new FileNameConvertControl(SOURCE_CONVERT, DbaNavigatorResources.getString("SOURCE_FILE_NAME_CONVERT_LABEL"), connection, true);
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(PDB_ACTION, DbaNavigatorResources.getString("PDB_ACTION"), new String[]{"NOCOPY", "COPY", "MOVE"}, "NOCOPY");
        FileNameConvertControl fileNameConvertControl2 = new FileNameConvertControl(FILE_CONVERT, DbaNavigatorResources.getString("FILE_NAME_CONVERT_LABEL"), connection, true);
        fileNameConvertControl2.setEditable(false);
        PdbStorageControl pdbStorageControl = new PdbStorageControl(PDB_STORAGE, DbaNavigatorResources.getString("STORAGE_LABEL"));
        comboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)fileNameConvertControl2){
            final /* synthetic */ ActionControl val$fileNameConvert;
            {
                this.val$fileNameConvert = actionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (((ActionControl.Value)propertyChangeEvent.getNewValue()).get().equals("NOCOPY")) {
                    this.val$fileNameConvert.setEditable(false);
                } else {
                    this.val$fileNameConvert.setEditable(true);
                }
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)fileNameConvertControl);
        arrayList.add((ActionControl)comboBoxActionControl);
        arrayList.add((ActionControl)fileNameConvertControl2);
        arrayList.add((ActionControl)pdbStorageControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE PLUGGABLE DATABASE ");
        stringBuffer.append(values.get(PDB_NAME));
        if (values.get(AS_CLONE).equals("true")) {
            stringBuffer.append(" AS CLONE");
        }
        stringBuffer.append(" USING '");
        stringBuffer.append(values.get(FILE_NAME));
        stringBuffer.append("'\n");
        stringBuffer.append(FileNameConvertControl.getFileNameConvertClause(SOURCE_CONVERT, (ActionValuesLookup)values, true));
        stringBuffer.append(values.get(PDB_ACTION));
        stringBuffer.append("\n");
        if (!values.get(PDB_ACTION).equals("NOCOPY")) {
            stringBuffer.append(FileNameConvertControl.getFileNameConvertClause(FILE_CONVERT, (ActionValuesLookup)values, false));
        }
        stringBuffer.append(PdbStorageControl.getStorageClause(PDB_STORAGE, (ActionValuesLookup)values));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

