/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class DropPdbsAction
extends ActionDialog {
    private static final String PDB_NAME = "PdbName";
    private static final String DROP_TYPE = "DropType";

    protected String getTitle() {
        return DbaNavigatorResources.getString("DROP_PDBS");
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected List<ActionControl> createControls(Connection connection) {
        TextBoxActionControl textBoxActionControl;
        Operation operation = this.getOperation();
        if (operation == Operation.PDBS) {
            textBoxActionControl = new TextBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), this.getObjectName());
            textBoxActionControl.setEditable(false);
        } else {
            textBoxActionControl = new SqlComboBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), connection, "select name from v$pdbs");
        }
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(DROP_TYPE, DbaNavigatorResources.getString("PDBS_DATAFILE_ACTION"), new String[]{"KEEP", "INCLUDING"}, "KEEP");
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)comboBoxActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP PLUGGABLE DATABASE " + values.get(PDB_NAME) + "\n");
        stringBuffer.append(values.get(DROP_TYPE));
        stringBuffer.append(" DATAFILES");
        return stringBuffer.toString();
    }

    private static enum Operation {
        CONTAINER,
        PDBS;

    }
}

