/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.FileNameConvertControl;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.PdbStorageControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class ClonePdbsAction
extends ActionDialog {
    private static final String PDB_NAME = "PdbName";
    private static final String SRC_NAME = "SrcName";
    private static final String DB_LINK = "DbLink";
    private static final String PDB_STORAGE = "PdbStorage";
    private static final String FILE_CONVERT = "FileConvert";

    protected String getTitle() {
        return DbaNavigatorResources.getString("CLONE_PDB_TITLE");
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected List<ActionControl> createControls(Connection connection) {
        TextBoxActionControl textBoxActionControl;
        Operation operation = this.getOperation();
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), "NEW_PDB");
        SqlComboBoxActionControl sqlComboBoxActionControl = new SqlComboBoxActionControl(DB_LINK, DbaNavigatorResources.getString("LINK_LABEL"), connection, "select 'NONE' from dual union select db_link from all_db_links");
        ((JComboBox)sqlComboBoxActionControl.getUI()).setSelectedItem("NONE");
        if (operation == Operation.PDBS) {
            textBoxActionControl = new TextBoxActionControl(SRC_NAME, DbaNavigatorResources.getString("SOURCE_PDB"), this.getDBObjectName());
            textBoxActionControl.setEditable(false);
            sqlComboBoxActionControl.setEditable(false);
        } else {
            textBoxActionControl = new SqlComboBoxActionControl(SRC_NAME, DbaNavigatorResources.getString("SOURCE_PDB"), connection, "select name from v$pdbs");
        }
        FileNameConvertControl fileNameConvertControl = new FileNameConvertControl(FILE_CONVERT, DbaNavigatorResources.getString("FILE_NAME_CONVERT_LABEL"), connection, true);
        PdbStorageControl pdbStorageControl = new PdbStorageControl(PDB_STORAGE, DbaNavigatorResources.getString("STORAGE_LABEL"));
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)sqlComboBoxActionControl);
        arrayList.add((ActionControl)pdbStorageControl);
        arrayList.add((ActionControl)fileNameConvertControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE PLUGGABLE DATABASE ");
        stringBuffer.append(values.get(PDB_NAME));
        stringBuffer.append(" FROM ");
        stringBuffer.append(values.get(SRC_NAME));
        if (!values.get(DB_LINK).equals("NONE")) {
            stringBuffer.append("@" + values.get(DB_LINK));
        }
        stringBuffer.append("\n");
        stringBuffer.append(PdbStorageControl.getStorageClause(PDB_STORAGE, (ActionValuesLookup)values));
        stringBuffer.append(FileNameConvertControl.getFileNameConvertClause(FILE_CONVERT, (ActionValuesLookup)values, false));
        return stringBuffer.toString();
    }

    private static enum Operation {
        CONTAINER,
        PDBS;

    }
}

