/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.consumergroups;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;

public class AddUserAction
extends ActionDialog {
    private static final String USERNAME = "UserName";
    private static final String ADMIN = "Admin";

    protected String getTitle() {
        return DbaNavigatorResources.getString("ADD_USER_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        String string = this.getObjectName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NAME", string);
        SqlComboBoxActionControl sqlComboBoxActionControl = new SqlComboBoxActionControl(USERNAME, DbaNavigatorResources.getString("USER_NAME_LABEL"), connection, this.getQuery(connection, "getAddableUsers"), hashMap, null);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(ADMIN, DbaNavigatorResources.getString("GRANT_OPTION_LABEL"), false);
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)sqlComboBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN\n");
        stringBuffer.append("    DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP(\n        '\"");
        stringBuffer.append(values.get(USERNAME));
        stringBuffer.append("\"',\n        '");
        stringBuffer.append(this.getObjectName());
        if (Boolean.parseBoolean(values.get(ADMIN))) {
            stringBuffer.append("',\n        TRUE);\n");
        } else {
            stringBuffer.append("',\n        FALSE);\n");
        }
        stringBuffer.append("END;");
        return stringBuffer.toString();
    }
}

