/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backuptabs;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditDiskDeviceSettingsTab
extends ActionDialogTab {
    public static final String DISK_PARALLELISM = "DISK_PARALLELISM";
    public static final String DISK_BACKUP_TYPE = "DISK_BACKUP_TYPE";
    public static final String DISK_BACKUP_LOCATION = "DISK_BACKUP_LOCATION";
    public static final String BACKUP_SET_TYPE = DbaNavigatorResources.getString("BACKUP_SET_TYPE");
    public static final String COMPRESSED_BACKUP_SET_TYPE = DbaNavigatorResources.getString("COMPRESSED_BACKUP_SET_TYPE");
    public static final String IMAGE_COPY_TYPE = DbaNavigatorResources.getString("IMAGE_COPY_TYPE");
    private boolean _includeProcessorCtl;

    public EditDiskDeviceSettingsTab() {
        super(null, null);
        this._includeProcessorCtl = true;
    }

    public EditDiskDeviceSettingsTab(String string) {
        super(string, DbaNavigatorResources.getString("DISK_DEVICE_TAB"));
        this._includeProcessorCtl = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActionControl> createControls(Connection connection) {
        Object object;
        DBUtil dBUtil;
        ComboBoxActionControl comboBoxActionControl;
        TextBoxActionControl textBoxActionControl;
        int n = 0;
        String string = null;
        String string2 = null;
        if (Connections.getInstance().lock(connection)) {
            textBoxActionControl = null;
            try {
                comboBoxActionControl = new HashMap();
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                textBoxActionControl = dBUtil.executeOracleQuery(this.getQuery(connection, "getDiskDeviceSettings"), comboBoxActionControl);
                if (textBoxActionControl != null) {
                    object = textBoxActionControl.getResultSet();
                    while (object.next()) {
                        n = object.getInt(DISK_PARALLELISM);
                        string = object.getString(DISK_BACKUP_TYPE);
                        string2 = object.getString(DISK_BACKUP_LOCATION);
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (textBoxActionControl != null) {
                    textBoxActionControl.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        textBoxActionControl = new TextBoxActionControl(DISK_PARALLELISM, DbaNavigatorResources.getString("PARALLELISM_LABEL"), Integer.toString(n), TextBoxActionControl.getIntegerFormat());
        comboBoxActionControl = new ComboBoxActionControl(DISK_BACKUP_TYPE, DbaNavigatorResources.getString("BACKUP_TYPE_LABEL"), new String[]{BACKUP_SET_TYPE, COMPRESSED_BACKUP_SET_TYPE, IMAGE_COPY_TYPE}, string);
        dBUtil = new TextBoxActionControl(DISK_BACKUP_LOCATION, DbaNavigatorResources.getString("BACKUP_LOCATION_LABEL"), string2);
        object = new ArrayList();
        ((ArrayList)object).add(textBoxActionControl);
        ((ArrayList)object).add(comboBoxActionControl);
        ((ArrayList)object).add(dBUtil);
        if (this._includeProcessorCtl) {
            ((ArrayList)object).add(new SeperatorActionControl());
            ((ArrayList)object).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        }
        return object;
    }

    public static int getDiskParallelism(ActionDialog.Lookup lookup) {
        return Integer.parseInt(lookup.get(DISK_PARALLELISM));
    }

    public static boolean isBackupSetType(ActionDialog.Lookup lookup) {
        return lookup.get(DISK_BACKUP_TYPE).equals(BACKUP_SET_TYPE);
    }

    public static boolean isCompressedBackupSetType(ActionDialog.Lookup lookup) {
        return lookup.get(DISK_BACKUP_TYPE).equals(COMPRESSED_BACKUP_SET_TYPE);
    }

    public static boolean isImageCopyType(ActionDialog.Lookup lookup) {
        return lookup.get(DISK_BACKUP_TYPE).equals(IMAGE_COPY_TYPE);
    }

    public static String getDiskBackupLocation(ActionDialog.Lookup lookup) {
        return lookup.get(DISK_BACKUP_LOCATION);
    }
}

