/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backuptabs;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditCompressionAlgorithmSettingsTab
extends ActionDialogTab {
    public static final String COMPRESSION_ALGORITHM = "COMPRESSION_ALGORITHM";
    public static final String ALGORITHM_RELEASE = "ALGORITHM_RELEASE";
    public static final String OPTIMIZE_FOR_LOAD = "OPTIMIZE_FOR_LOAD";
    private boolean _includeProcessorAction;

    public EditCompressionAlgorithmSettingsTab() {
        super(null, null);
        this._includeProcessorAction = true;
    }

    public EditCompressionAlgorithmSettingsTab(String string) {
        super(string, DbaNavigatorResources.getString("COMPRESSION_TAB"));
        this._includeProcessorAction = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActionControl> createControls(Connection connection) {
        Object object;
        DBUtil dBUtil;
        Object object2;
        Object object3;
        Object object4;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("DEFAULT");
        try {
            stringArray = connection.getMetaData();
            int n = stringArray.getDatabaseMajorVersion();
            int n2 = stringArray.getDatabaseMinorVersion();
            arrayList.add(Integer.toString(n) + '.' + n2 + ".0.0.0");
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        String[] stringArray2 = new String[]{};
        if (DbaUtil.getDatabaseMajorVersion(connection) >= 11) {
            if (Connections.getInstance().lock(connection)) {
                ResultSetWrapper resultSetWrapper = null;
                try {
                    object4 = new HashMap();
                    DBUtil dBUtil2 = DBUtil.getInstance((Connection)connection);
                    dBUtil2.setRaiseError(true);
                    resultSetWrapper = dBUtil2.executeOracleQuery(this.getQuery(connection, "getCompressionAlgorithmNames"), object4);
                    object3 = new ArrayList();
                    if (resultSetWrapper != null) {
                        object2 = resultSetWrapper.getResultSet();
                        while (object2.next()) {
                            ((ArrayList)object3).add(object2.getString("ALGORITHM_NAME"));
                        }
                    }
                    stringArray2 = new String[((ArrayList)object3).size()];
                    ((ArrayList)object3).toArray(stringArray2);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    if (resultSetWrapper != null) {
                        resultSetWrapper.close();
                    }
                    Connections.getInstance().unlock(connection);
                }
            }
        } else {
            stringArray2 = new String[]{"BASIC"};
        }
        String string = null;
        object4 = null;
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            object3 = null;
            try {
                object2 = new HashMap();
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object3 = dBUtil.executeOracleQuery(this.getQuery(connection, "getCompressionAlgorithmSettings"), (Map)object2);
                if (object3 != null) {
                    object = object3.getResultSet();
                    while (object.next()) {
                        string = object.getString(COMPRESSION_ALGORITHM);
                        object4 = object.getString(ALGORITHM_RELEASE);
                        bl = object.getString(OPTIMIZE_FOR_LOAD).equals("TRUE");
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (object3 != null) {
                    object3.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
        object3 = new ComboBoxActionControl(COMPRESSION_ALGORITHM, DbaNavigatorResources.getString("BACKUP_ALGORITHM_NAME_LABEL"), stringArray2, string);
        object2 = new ComboBoxActionControl(ALGORITHM_RELEASE, DbaNavigatorResources.getString("BACKUP_RELEASE_LABEL"), stringArray, object4);
        dBUtil = new BooleanCheckBoxActionControl(OPTIMIZE_FOR_LOAD, DbaNavigatorResources.getString("OPTIMIZE_FOR_LOAD_LABEL"), bl);
        object = new ArrayList();
        ((ArrayList)object).add(object3);
        ((ArrayList)object).add(object2);
        ((ArrayList)object).add(dBUtil);
        if (this._includeProcessorAction) {
            ((ArrayList)object).add(new SeperatorActionControl());
            ((ArrayList)object).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        }
        return object;
    }

    public static String getCompressionAlgorithm(ActionDialog.Lookup lookup) {
        return lookup.get(COMPRESSION_ALGORITHM);
    }

    public static String getAlgorithmRelease(ActionDialog.Lookup lookup) {
        return lookup.get(ALGORITHM_RELEASE);
    }

    public static boolean isOptimizeForLoad(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(OPTIMIZE_FOR_LOAD));
    }
}

