/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.Databases;
import oracle.dbtools.raptor.dba.navigator.DbaConnection;
import oracle.dbtools.raptor.dba.navigator.DbaConnectionsFilter;
import oracle.dbtools.raptor.dba.navigator.DbaFilter;
import oracle.dbtools.raptor.dba.navigator.DbaNavWindow;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.NavActionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class DbaNavigatorManager
extends DatabaseNavigatorManager {
    private static final String DEFAULT_NAME = "DbaNavigatorName";
    public static final Logger LOGGER = Logger.getLogger(DbaNavigatorManager.class.getName());
    private static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.TOGGLE_TOOLBAR_CMD_ID");
    private static final String DBA_NAVIGATOR_WINDOW_ID = "DbaNavigatorWindow";
    private static final String DBA_NAV_CMD = "DbaNavigator.SHOW_NAVIGATOR";
    private static final int DBA_NAV_CMD_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.SHOW_NAVIGATOR");
    private static NavigatorManager s_instance;

    public static synchronized NavigatorManager getInstance() {
        if (s_instance == null) {
            s_instance = new DbaNavigatorManager();
        }
        return s_instance;
    }

    public DbaNavigatorManager() {
        this.registerFilter(DbaConnection.class, DbaFilter.class, null);
        this.registerFilter(Databases.class, DbaConnectionsFilter.class, null);
    }

    public void initialize() {
        super.initialize();
        ObjectActionController.addListener((IObjectActionListener)new NavActionListener((NavigatorManager)this));
    }

    protected DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new DbaNavWindow(context, viewId.getId(), this.getTabTitle());
    }

    protected NavigatorWindow createNavigatorWindow() {
        NavigatorWindow navigatorWindow = this.createNavigatorWindow((Folder)Databases.getInstance(), true, 0);
        return navigatorWindow;
    }

    protected IdeAction createShowNavigatorAction() {
        String string = DbaNavigatorResources.getString("DBA_NAVIGATOR_LABEL");
        return IdeAction.get((int)DBA_NAV_CMD_ID, null, (String)string, (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)DbaNavigatorResources.getInteger("DBA_NAVIGATOR_MNEMONIC"), (Icon)RaptorImagesArb.getIcon((String)"CONNECTIONS_FOLDER"), null, (boolean)true);
    }

    protected IdeAction createToggleToolbarAction() {
        return IdeAction.get((int)TOGGLE_TOOLBAR_CMD_ID, null, (String)DbaNavigatorResources.getString("DBA_NAVIGATOR_TOOLBAR_LABEL"), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)DbaNavigatorResources.getInteger("DBA_NAVIGATOR_TOOLBAR_MNEMONIC"), null, null, null, (boolean)true);
    }

    protected String getDefaultName() {
        return DEFAULT_NAME;
    }

    protected String getViewCategory() {
        return DBA_NAVIGATOR_WINDOW_ID;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idedbanavigator_html");
    }
}

