/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.dba.navigator.DbaConnectionRecognizer;
import oracle.dbtools.raptor.dba.navigator.DbaContextMenuListener;
import oracle.dbtools.raptor.dba.navigator.DbaNavigatorManager;
import oracle.dbtools.raptor.dba.navigator.displays.UndoDisplay;
import oracle.dbtools.raptor.dba.navigator.editors.DbControlEditorAddin;
import oracle.dbtools.raptor.dba.navigator.net.DbControlUrlFileSystemHelper;
import oracle.dbtools.raptor.dba.navigator.net.DbControlUrlStreamHandler;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.navigator.ConnectionRecognizer;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.ObjectFactoryRegistry;
import oracle.dbtools.raptor.navigator.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Addin;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;

public class DbaNavigatorAddin
implements Addin {
    static final Logger LOGGER = Logger.getLogger(DbaNavigatorAddin.class.getName());
    public static final String FACTORY_ID = "sqldev.dbanav";

    public void initialize() {
        URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new DbControlUrlStreamHandler());
        URLFileSystem.registerHelper((String)"sqldev.dbacontrol", (URLFileSystemHelper)new DbControlUrlFileSystemHelper());
        EditorManager.getEditorManager().registerDynamic((EditorAddin)new DbControlEditorAddin());
        DisplayRegistry.registerDisplay((String)"Undo", UndoDisplay.class, null, (Boolean)false, (Boolean)true);
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.raptor.dba.navigator.actions");
        ViewerAddin.registerPackage((String)"oracle.dbtools.raptor.dba.navigator.viewers");
        ObjectFactoryRegistry.getRegistry((String)FACTORY_ID).registerRecognizer((ConnectionRecognizer)new DbaConnectionRecognizer());
        DBURLFormatHelper.registerFormatHelper((String)FACTORY_ID, (DBURLFormatHelper)new NavigatorFormatHelper());
        NavigatorManager navigatorManager = DbaNavigatorManager.getInstance();
        navigatorManager.addContextMenuListener((ContextMenuListener)DbaContextMenuListener.getInstance(), null);
        navigatorManager.initialize();
    }

    private static class NavigatorFormatHelper
    extends DBURLFormatHelper {
        private static int CNAME_PART = 0;
        private static int CATALOG_PART = 1;
        private static int SCHEMA_PART = 2;
        private static int BASETYPE_PART = 3;
        private static int NAME_PART = 4;
        private static int CHILDTYPE_PART = 5;
        private static int CHILDNAME_PART = 6;
        private static Map<URL, String[]> s_parsedURLs = new WeakHashMap<URL, String[]>();

        private NavigatorFormatHelper() {
            super(DbaNavigatorAddin.FACTORY_ID);
        }

        protected String getConnectionNameImpl(URL uRL) {
            assert (uRL != null);
            assert (DbaNavigatorAddin.FACTORY_ID.equals(uRL.getProtocol()));
            return this.getPart(uRL, CNAME_PART);
        }

        protected String getCatalogImpl(URL uRL) {
            assert (uRL != null);
            assert (DbaNavigatorAddin.FACTORY_ID.equals(uRL.getProtocol()));
            return this.getPart(uRL, CATALOG_PART);
        }

        protected String getSchemaImpl(URL uRL) {
            assert (uRL != null);
            assert (DbaNavigatorAddin.FACTORY_ID.equals(uRL.getProtocol()));
            return this.getPart(uRL, SCHEMA_PART);
        }

        protected String getBaseTypeImpl(URL uRL) {
            assert (uRL != null);
            assert (DbaNavigatorAddin.FACTORY_ID.equals(uRL.getProtocol()));
            return this.getPart(uRL, BASETYPE_PART);
        }

        protected String getNameImpl(URL uRL) {
            assert (uRL != null);
            assert (DbaNavigatorAddin.FACTORY_ID.equals(uRL.getProtocol()));
            return this.getPart(uRL, NAME_PART);
        }

        protected Icon getIconImpl(URL uRL) {
            Icon icon = null;
            try {
                String string = this.getConnectionNameImpl(uRL);
                ObjectFactory objectFactory = ObjectFactory.getFactory((String)string, (Connection)Connections.getInstance().getConnection(string));
                DatabaseObject databaseObject = objectFactory.getObjectDescriptor(this.getBaseTypeImpl(uRL));
                if (databaseObject != null) {
                    icon = databaseObject.getIcon();
                }
            }
            catch (DBException dBException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
            return icon;
        }

        protected String getChildTypeImpl(URL uRL) {
            assert (uRL != null);
            assert (DbaNavigatorAddin.FACTORY_ID.equals(uRL.getProtocol()));
            return this.getPart(uRL, CHILDTYPE_PART);
        }

        protected String getChildNameImpl(URL uRL) {
            assert (uRL != null);
            assert (DbaNavigatorAddin.FACTORY_ID.equals(uRL.getProtocol()));
            return this.getPart(uRL, CHILDNAME_PART);
        }

        private String getPart(URL uRL, int n) {
            String string;
            if (uRL == null || !DbaNavigatorAddin.FACTORY_ID.equals(uRL.getProtocol())) {
                return null;
            }
            String[] stringArray = s_parsedURLs.get(uRL);
            if (stringArray == null) {
                String string2;
                int n2;
                stringArray = new String[CHILDNAME_PART + 1];
                string = URLFileSystem.getPath((URL)uRL);
                for (int i = 0; i < stringArray.length; ++i) {
                    n2 = string.indexOf(47);
                    if (n2 < 0) {
                        stringArray[i] = NavigatorFormatHelper.decode((String)string);
                        break;
                    }
                    stringArray[i] = NavigatorFormatHelper.decode((String)string.substring(0, n2));
                    string = string.substring(n2 + 1);
                }
                if (ModelUtil.hasLength((String)(string2 = uRL.getRef()))) {
                    n2 = string2.indexOf(47);
                    if (n2 >= 0) {
                        stringArray[NavigatorFormatHelper.CHILDTYPE_PART] = NavigatorFormatHelper.decode((String)string2.substring(0, n2));
                        stringArray[NavigatorFormatHelper.CHILDNAME_PART] = NavigatorFormatHelper.decode((String)string2.substring(n2 + 1));
                    } else {
                        stringArray[NavigatorFormatHelper.CHILDTYPE_PART] = NavigatorFormatHelper.decode((String)string2);
                    }
                }
                s_parsedURLs.put(uRL, stringArray);
            }
            return ModelUtil.hasLength((String)(string = stringArray[n])) ? string : null;
        }
    }
}

