/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.connections.AbstractConnectionListener;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.dba.navigator.DbaConnection;
import oracle.dbtools.raptor.dba.navigator.Messages;
import oracle.dbtools.raptor.navigator.DatabaseOverlayClient;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorHashStructureAdapter;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.db.model.ConnectionStoreNode;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.DatabaseConnectionStores;

public class Databases
extends DefaultContainer
implements ConnectionStoreNode {
    private static Databases INSTANCE;
    private ConnectionListener m_listener = new AbstractConnectionListener(){

        public void connectionRemoved(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            Databases.this.removeConnection(string);
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getOldName();
            String string2 = Connections.getStoreName((String)string);
            if (ModelUtil.areEqual((Object)string2, (Object)Databases.this.m_id)) {
                String string3 = connectionEvent.getConnectionName();
                if (ModelUtil.areDifferent((Object)string, (Object)string3)) {
                    DbaConnection dbaConnection = Databases.getConnectionNode(string, false);
                    if (dbaConnection != null) {
                        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.dbanav", (String)string3);
                        dbaConnection.setURL(uRL);
                        UpdateMessage.fireObjectRenamed((Subject)dbaConnection);
                    }
                } else {
                    DbaConnection dbaConnection = Databases.getConnectionNode(string3, false);
                    if (dbaConnection != null) {
                        UpdateMessage.firePropertiesChanged((Subject)dbaConnection, (PropertyChangeEvent[])new PropertyChangeEvent[0], null);
                    }
                }
            }
        }
    };
    private String m_id = "IdeConnections";
    private String m_label = Messages.getString("Databases.0");
    private String m_tooltip = Messages.getString("Databases.1");

    public static synchronized Databases getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Databases();
        }
        return INSTANCE;
    }

    public static DbaConnection getConnectionNode(String string, boolean bl) {
        DbaConnection dbaConnection = null;
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.dbanav", (String)string);
        dbaConnection = bl ? DbaConnection.findOrCreateConnectionNode(uRL) : DbaConnection.findConnectionNode(uRL);
        return dbaConnection;
    }

    private Databases() {
    }

    public String getStoreId() {
        return this.m_id;
    }

    public String getShortLabel() {
        return this.m_label;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return DatabaseConnectionStores.getInstance().getIcon(this.m_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        Connections connections = Connections.getInstance();
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            Settings settings = Settings.getInstance();
            for (String string : settings.getConnections(this.m_id)) {
                DbaConnection dbaConnection = Databases.getConnectionNode(string, true);
                if (dbaConnection == null) continue;
                this.updateOverlaysForNode(dbaConnection);
                this._children.add(dbaConnection);
            }
        }
        connections.addConnectionListener(this.m_listener);
    }

    protected void closeImpl() throws IOException {
        Connections.getInstance().removeConnectionListener(this.m_listener);
    }

    public boolean addConnection(String string) {
        DbaConnection dbaConnection;
        String string2;
        boolean bl = false;
        if (!Connections.isUnsharedWorksheetConnection((String)string) && ModelUtil.areEqual((Object)(string2 = Connections.getStoreName((String)string)), (Object)this.m_id) && (dbaConnection = Databases.getConnectionNode(string, true)) != null) {
            this.updateOverlaysForNode(dbaConnection);
            bl = this.add((Element)dbaConnection, true);
            Settings settings = Settings.getInstance();
            settings.addConnection(string2, Connections.getConnectionName((String)string));
        }
        return bl;
    }

    public boolean removeConnection(String string) {
        DbaConnection dbaConnection;
        boolean bl = false;
        String string2 = Connections.getStoreName((String)string);
        if (ModelUtil.areEqual((Object)string2, (Object)this.m_id) && (dbaConnection = Databases.getConnectionNode(string, false)) != null) {
            Object object;
            if (dbaConnection.isConnectionOpen()) {
                object = Context.newIdeContext((Element)dbaConnection);
                Command command = CommandProcessor.createCommand((String)"oracle.ide.cmd.CloseNodeCommand", (Context)object);
                try {
                    CommandProcessor.getInstance().invoke(command);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bl = this.remove((Element)dbaConnection, true);
            object = Settings.getInstance();
            ((Settings)((Object)object)).removeConnection(string2, Connections.getConnectionName((String)string));
        }
        return bl;
    }

    private void updateOverlaysForNode(DbaConnection dbaConnection) {
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay((Element)dbaConnection);
            iconOverlayTracker.repaintOverlays();
        }
    }

    public void markDirty(boolean bl) {
    }

    public String getToolTipText() {
        return this.m_tooltip;
    }

    public String getStoreName() {
        return this.m_id;
    }

    private static class Settings
    extends RaptorHashStructureAdapter {
        private static final String DATA_KEY = "DBA.Databases.Settings";

        static Settings getInstance() {
            return new Settings(Settings.findOrCreate((PropertyStorage)Preferences.getPreferences(), (String)DATA_KEY));
        }

        private Settings(HashStructure hashStructure) {
            super(hashStructure);
        }

        protected String getRootKey() {
            return "ACTIVE_CONNS";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<String> getConnections(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ListStructure listStructure = this.getRootHash().getOrCreateListStructure(Settings.encode((String)string));
            Object object = listStructure.iteratorLock();
            synchronized (object) {
                Iterator iterator = listStructure.iterator();
                while (iterator.hasNext()) {
                    String string2 = Settings.decode((String)((String)iterator.next()));
                    Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey((String)string, (String)string2);
                    arrayList.add(connectionKey.getQualifiedName());
                }
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addConnection(String string, String string2) {
            ListStructure listStructure = this.getRootHash().getOrCreateListStructure(Settings.encode((String)string));
            Object object = listStructure.iteratorLock();
            synchronized (object) {
                Iterator iterator = listStructure.iterator();
                while (iterator.hasNext()) {
                    if (!string2.equals(Settings.decode((String)((String)iterator.next())))) continue;
                    return false;
                }
            }
            return listStructure.add((Object)Settings.encode((String)string2));
        }

        boolean removeConnection(String string, String string2) {
            ListStructure listStructure = this.getRootHash().getOrCreateListStructure(Settings.encode((String)string));
            return listStructure.remove((Object)Settings.encode((String)string2));
        }
    }
}

