/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.text;

import ilog.views.util.text.IlvNFRuleSet;
import ilog.views.util.text.IlvNFSubstitution;
import ilog.views.util.text.IlvRuleBasedNumberFormat;
import java.text.CollationElementIterator;
import java.text.ParsePosition;
import java.text.RuleBasedCollator;

final class IlvNFRule {
    public static final int NEGATIVE_NUMBER_RULE = -1;
    public static final int IMPROPER_FRACTION_RULE = -2;
    public static final int PROPER_FRACTION_RULE = -3;
    public static final int MASTER_RULE = -4;
    private long a;
    private int b = 10;
    private short c = 0;
    private String d = null;
    private IlvNFSubstitution e = null;
    private IlvNFSubstitution f = null;
    private IlvRuleBasedNumberFormat g = null;

    public static Object makeRules(String string, IlvNFRuleSet ilvNFRuleSet, IlvNFRule ilvNFRule, IlvRuleBasedNumberFormat ilvRuleBasedNumberFormat) {
        IlvNFRule ilvNFRule2 = new IlvNFRule(ilvRuleBasedNumberFormat);
        string = ilvNFRule2.a(string);
        int n2 = string.indexOf("[");
        int n3 = string.indexOf("]");
        if (n2 == -1 || n3 == -1 || n2 > n3 || ilvNFRule2.getBaseValue() == -3L || ilvNFRule2.getBaseValue() == -1L) {
            ilvNFRule2.d = string;
            ilvNFRule2.a(ilvNFRuleSet, ilvNFRule, ilvRuleBasedNumberFormat);
            return ilvNFRule2;
        }
        IlvNFRule ilvNFRule3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (ilvNFRule2.a > 0L && (double)ilvNFRule2.a % Math.pow(ilvNFRule2.b, ilvNFRule2.c) == 0.0 || ilvNFRule2.a == -2L || ilvNFRule2.a == -4L) {
            ilvNFRule3 = new IlvNFRule(ilvRuleBasedNumberFormat);
            if (ilvNFRule2.a >= 0L) {
                ilvNFRule3.a = ilvNFRule2.a++;
                if (!ilvNFRuleSet.isFractionSet()) {
                    // empty if block
                }
            } else if (ilvNFRule2.a == -2L) {
                ilvNFRule3.a = -3L;
            } else if (ilvNFRule2.a == -4L) {
                ilvNFRule3.a = ilvNFRule2.a;
                ilvNFRule2.a = -2L;
            }
            ilvNFRule3.b = ilvNFRule2.b;
            ilvNFRule3.c = ilvNFRule2.c;
            stringBuffer.append(string.substring(0, n2));
            if (n3 + 1 < string.length()) {
                stringBuffer.append(string.substring(n3 + 1));
            }
            ilvNFRule3.d = stringBuffer.toString();
            ilvNFRule3.a(ilvNFRuleSet, ilvNFRule, ilvRuleBasedNumberFormat);
        }
        stringBuffer.setLength(0);
        stringBuffer.append(string.substring(0, n2));
        stringBuffer.append(string.substring(n2 + 1, n3));
        if (n3 + 1 < string.length()) {
            stringBuffer.append(string.substring(n3 + 1));
        }
        ilvNFRule2.d = stringBuffer.toString();
        ilvNFRule2.a(ilvNFRuleSet, ilvNFRule, ilvRuleBasedNumberFormat);
        if (ilvNFRule3 == null) {
            return ilvNFRule2;
        }
        return new IlvNFRule[]{ilvNFRule3, ilvNFRule2};
    }

    public IlvNFRule(IlvRuleBasedNumberFormat ilvRuleBasedNumberFormat) {
        this.g = ilvRuleBasedNumberFormat;
    }

    private String a(String string) {
        int n2 = string.indexOf(":");
        if (n2 == -1) {
            this.setBaseValue(0L);
        } else {
            String string2 = string.substring(0, n2);
            ++n2;
            while (n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            string = string.substring(n2);
            if (string2.equals("-x")) {
                this.setBaseValue(-1L);
            } else if (string2.equals("x.x")) {
                this.setBaseValue(-2L);
            } else if (string2.equals("0.x")) {
                this.setBaseValue(-3L);
            } else if (string2.equals("x.0")) {
                this.setBaseValue(-4L);
            } else if (string2.charAt(0) >= '0' && string2.charAt(0) <= '9') {
                StringBuffer stringBuffer = new StringBuffer();
                char c2 = ' ';
                for (n2 = 0; n2 < string2.length(); ++n2) {
                    c2 = string2.charAt(n2);
                    if (c2 >= '0' && c2 <= '9') {
                        stringBuffer.append(c2);
                        continue;
                    }
                    if (c2 == 47 || c2 == '>') break;
                    if (Character.isWhitespace(c2) || c2 == ',' || c2 == '.') continue;
                    throw new IllegalArgumentException("Illegal character in rule descriptor");
                }
                this.setBaseValue(Long.parseLong(stringBuffer.toString()));
                if (c2 == '/') {
                    stringBuffer.setLength(0);
                    ++n2;
                    while (n2 < string2.length()) {
                        c2 = string2.charAt(n2);
                        if (c2 >= '0' && c2 <= '9') {
                            stringBuffer.append(c2);
                        } else {
                            if (c2 == '>') break;
                            if (!Character.isWhitespace(c2) && c2 != ',' && c2 != '.') {
                                throw new IllegalArgumentException("Illegal character is rule descriptor");
                            }
                        }
                        ++n2;
                    }
                    this.b = Integer.parseInt(stringBuffer.toString());
                    if (this.b == 0) {
                        throw new IllegalArgumentException("Rule can't have radix of 0");
                    }
                    this.c = this.a();
                }
                if (c2 == '>') {
                    while (n2 < string2.length()) {
                        c2 = string2.charAt(n2);
                        if (c2 != '>' || this.c <= 0) {
                            throw new IllegalArgumentException("Illegal character in rule descriptor");
                        }
                        this.c = (short)(this.c - 1);
                        ++n2;
                    }
                }
            }
        }
        if (string.length() > 0 && string.charAt(0) == '\'') {
            string = string.substring(1);
        }
        return string;
    }

    private void a(IlvNFRuleSet ilvNFRuleSet, IlvNFRule ilvNFRule, IlvRuleBasedNumberFormat ilvRuleBasedNumberFormat) {
        this.e = this.b(ilvNFRuleSet, ilvNFRule, ilvRuleBasedNumberFormat);
        this.f = this.b(ilvNFRuleSet, ilvNFRule, ilvRuleBasedNumberFormat);
    }

    private IlvNFSubstitution b(IlvNFRuleSet ilvNFRuleSet, IlvNFRule ilvNFRule, IlvRuleBasedNumberFormat ilvRuleBasedNumberFormat) {
        IlvNFSubstitution ilvNFSubstitution = null;
        int n2 = this.a(new String[]{"<<", "<%", "<#", "<0", ">>", ">%", ">#", ">0", "=%", "=#", "=0"});
        if (n2 == -1) {
            return IlvNFSubstitution.makeSubstitution(this.d.length(), this, ilvNFRule, ilvNFRuleSet, ilvRuleBasedNumberFormat, "");
        }
        int n3 = this.d.substring(n2).startsWith(">>>") ? n2 + 2 : this.d.indexOf(this.d.charAt(n2), n2 + 1);
        if (n3 == -1) {
            return IlvNFSubstitution.makeSubstitution(this.d.length(), this, ilvNFRule, ilvNFRuleSet, ilvRuleBasedNumberFormat, "");
        }
        ilvNFSubstitution = IlvNFSubstitution.makeSubstitution(n2, this, ilvNFRule, ilvNFRuleSet, ilvRuleBasedNumberFormat, this.d.substring(n2, n3 + 1));
        this.d = this.d.substring(0, n2) + this.d.substring(n3 + 1);
        return ilvNFSubstitution;
    }

    public final void setBaseValue(long l2) {
        this.a = l2;
        if (this.a >= 1L) {
            this.b = 10;
            this.c = this.a();
            if (this.e != null) {
                this.e.setDivisor(this.b, this.c);
            }
            if (this.f != null) {
                this.f.setDivisor(this.b, this.c);
            }
        } else {
            this.b = 10;
            this.c = 0;
        }
    }

    private short a() {
        if (this.b == 0 || this.a < 1L) {
            return 0;
        }
        short s2 = (short)(Math.log(this.a) / Math.log(this.b));
        if (Math.pow(this.b, s2 + 1) <= (double)this.a) {
            return (short)(s2 + 1);
        }
        return s2;
    }

    private int a(String[] stringArray) {
        int n2 = -1;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            int n3 = this.d.indexOf(stringArray[i2]);
            if (n3 == -1 || n2 != -1 && n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object instanceof IlvNFRule) {
            IlvNFRule ilvNFRule = (IlvNFRule)object;
            return this.a == ilvNFRule.a && this.b == ilvNFRule.b && this.c == ilvNFRule.c && this.d.equals(ilvNFRule.d) && this.e.equals(ilvNFRule.e) && this.f.equals(ilvNFRule.f);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a == -1L) {
            stringBuffer.append("-x: ");
        } else if (this.a == -2L) {
            stringBuffer.append("x.x: ");
        } else if (this.a == -3L) {
            stringBuffer.append("0.x: ");
        } else if (this.a == -4L) {
            stringBuffer.append("x.0: ");
        } else {
            stringBuffer.append(String.valueOf(this.a));
            if (this.b != 10) {
                stringBuffer.append('/');
                stringBuffer.append(String.valueOf(this.b));
            }
            int n2 = this.a() - this.c;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append('>');
            }
            stringBuffer.append(": ");
        }
        if (this.d.startsWith(" ") && (this.e == null || this.e.getPos() != 0)) {
            stringBuffer.append("'");
        }
        StringBuffer stringBuffer2 = new StringBuffer(this.d);
        stringBuffer2.insert(this.f.getPos(), this.f.toString());
        stringBuffer2.insert(this.e.getPos(), this.e.toString());
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(';');
        return stringBuffer.toString();
    }

    public final long getBaseValue() {
        return this.a;
    }

    public double getDivisor() {
        return Math.pow(this.b, this.c);
    }

    public void doFormat(long l2, StringBuffer stringBuffer, int n2) {
        stringBuffer.insert(n2, this.d);
        this.f.doSubstitution(l2, stringBuffer, n2);
        this.e.doSubstitution(l2, stringBuffer, n2);
    }

    public void doFormat(double d2, StringBuffer stringBuffer, int n2) {
        stringBuffer.insert(n2, this.d);
        this.f.doSubstitution(d2, stringBuffer, n2);
        this.e.doSubstitution(d2, stringBuffer, n2);
    }

    public boolean shouldRollBack(double d2) {
        if (this.e.isModulusSubstitution() || this.f.isModulusSubstitution()) {
            return d2 % Math.pow(this.b, this.c) == 0.0 && (double)this.a % Math.pow(this.b, this.c) != 0.0;
        }
        return false;
    }

    public Number doParse(String string, ParsePosition parsePosition, boolean bl, double d2) {
        ParsePosition parsePosition2 = new ParsePosition(0);
        String string2 = new String(string);
        string2 = this.a(string2, this.d.substring(0, this.e.getPos()), parsePosition2);
        int n2 = string.length() - string2.length();
        if (parsePosition2.getIndex() == 0 && this.e.getPos() != 0) {
            return new Long(0L);
        }
        int n3 = 0;
        double d3 = 0.0;
        int n4 = 0;
        double d4 = Math.max(0L, this.a);
        do {
            parsePosition2.setIndex(0);
            double d5 = this.a(string2, n4, d4, this.d.substring(this.e.getPos(), this.f.getPos()), parsePosition2, this.e, d2).doubleValue();
            if (parsePosition2.getIndex() == 0 && !this.e.isNullSubstitution()) continue;
            n4 = parsePosition2.getIndex();
            String string3 = string2.substring(parsePosition2.getIndex());
            ParsePosition parsePosition3 = new ParsePosition(0);
            d5 = this.a(string3, 0, d5, this.d.substring(this.f.getPos()), parsePosition3, this.f, d2).doubleValue();
            if (parsePosition3.getIndex() == 0 && !this.f.isNullSubstitution() || n2 + parsePosition2.getIndex() + parsePosition3.getIndex() <= n3) continue;
            n3 = n2 + parsePosition2.getIndex() + parsePosition3.getIndex();
            d3 = d5;
        } while (this.e.getPos() != this.f.getPos() && parsePosition2.getIndex() > 0 && parsePosition2.getIndex() < string2.length() && parsePosition2.getIndex() != n4);
        parsePosition.setIndex(n3);
        if (bl && n3 > 0 && this.e.isNullSubstitution()) {
            d3 = 1.0 / d3;
        }
        if (d3 == (double)((long)d3)) {
            return new Long((long)d3);
        }
        return new Double(d3);
    }

    private String a(String string, String string2, ParsePosition parsePosition) {
        if (string2.length() == 0) {
            return string;
        }
        int n2 = this.a(string, string2);
        if (n2 != 0) {
            parsePosition.setIndex(parsePosition.getIndex() + n2);
            return string.substring(n2);
        }
        return string;
    }

    private Number a(String string, int n2, double d2, String string2, ParsePosition parsePosition, IlvNFSubstitution ilvNFSubstitution, double d3) {
        if (!this.b(string2)) {
            ParsePosition parsePosition2 = new ParsePosition(0);
            int[] nArray = this.a(string, string2, n2);
            int n3 = nArray[0];
            int n4 = nArray[1];
            while (n3 >= 0) {
                String string3 = string.substring(0, n3);
                if (string3.length() > 0) {
                    Number number = ilvNFSubstitution.doParse(string3, parsePosition2, d2, d3, this.g.isLenientParseMode());
                    if (parsePosition2.getIndex() == n3) {
                        parsePosition.setIndex(n3 + n4);
                        return number;
                    }
                }
                parsePosition2.setIndex(0);
                nArray = this.a(string, string2, n3 + n4);
                n3 = nArray[0];
                n4 = nArray[1];
            }
            parsePosition.setIndex(0);
            return new Long(0L);
        }
        ParsePosition parsePosition3 = new ParsePosition(0);
        Number number = new Long(0L);
        Number number2 = ilvNFSubstitution.doParse(string, parsePosition3, d2, d3, this.g.isLenientParseMode());
        if (parsePosition3.getIndex() != 0 || ilvNFSubstitution.isNullSubstitution()) {
            parsePosition.setIndex(parsePosition3.getIndex());
            if (number2 != null) {
                number = number2;
            }
        }
        return number;
    }

    private int a(String string, String string2) {
        if (string2.length() == 0) {
            return 0;
        }
        if (this.g.isLenientParseMode()) {
            RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)this.g.b();
            CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(string);
            CollationElementIterator collationElementIterator2 = ruleBasedCollator.getCollationElementIterator(string2);
            int n2 = collationElementIterator.next();
            int n3 = collationElementIterator2.next();
            while (n3 != -1) {
                while (CollationElementIterator.primaryOrder(n2) == 0 && n2 != -1) {
                    n2 = collationElementIterator.next();
                }
                while (CollationElementIterator.primaryOrder(n3) == 0 && n3 != -1) {
                    n3 = collationElementIterator2.next();
                }
                if (n3 == -1) break;
                if (n2 == -1) {
                    return 0;
                }
                if (CollationElementIterator.primaryOrder(n2) != CollationElementIterator.primaryOrder(n3)) {
                    return 0;
                }
                n2 = collationElementIterator.next();
                n3 = collationElementIterator2.next();
            }
            int n4 = collationElementIterator.getOffset();
            if (n2 != -1) {
                --n4;
            }
            return n4;
        }
        if (string.startsWith(string2)) {
            return string2.length();
        }
        return 0;
    }

    private int[] b(String string, String string2) {
        return this.a(string, string2, 0);
    }

    private int[] a(String string, String string2, int n2) {
        if (!this.g.isLenientParseMode()) {
            return new int[]{string.indexOf(string2, n2), string2.length()};
        }
        int n3 = 0;
        for (int i2 = n2; i2 < string.length() && n3 == 0; ++i2) {
            n3 = this.a(string.substring(i2), string2);
            if (n3 == 0) continue;
            return new int[]{i2, n3};
        }
        return new int[]{-1, 0};
    }

    private boolean b(String string) {
        if (string.length() == 0) {
            return true;
        }
        if (this.g.isLenientParseMode()) {
            RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)this.g.b();
            CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(string);
            int n2 = collationElementIterator.next();
            while (n2 != -1 && CollationElementIterator.primaryOrder(n2) == 0) {
                n2 = collationElementIterator.next();
            }
            return n2 == -1;
        }
        return false;
    }
}

