/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.calendar.plaf;

import ilog.views.util.swing.IlvArrow;
import ilog.views.util.swing.calendar.IlvCalendarModel;
import ilog.views.util.swing.calendar.IlvJMonthScroller;
import ilog.views.util.swing.calendar.event.CalendarModelEvent;
import ilog.views.util.swing.calendar.event.CalendarModelListener;
import ilog.views.util.swing.calendar.plaf.MonthScrollerUI;
import ilog.views.util.swing.layout.IlvTableLayout;
import ilog.views.util.time.IlvCalendarUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;

public class BasicMonthScrollerUI
extends MonthScrollerUI {
    protected IlvJMonthScroller monthScroller;
    protected JButton prevButton;
    protected JButton nextButton;
    protected JLabel monthLabel;
    protected PropertyChangeListener propertyChangeListener;
    protected CalendarModelListener modelListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMonthScrollerUI();
    }

    public void installUI(JComponent jComponent) {
        this.monthScroller = (IlvJMonthScroller)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.monthScroller = null;
    }

    protected void installComponents() {
        double[][] dArrayArray = new double[][]{{-2.0, -1.0, -2.0}, {-2.0}};
        this.monthScroller.setLayout(new IlvTableLayout(dArrayArray));
        Color color = this.monthScroller.getBackground();
        this.prevButton = new ArrowButton(7, 21);
        this.prevButton.setBackground(color);
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Calendar calendar = BasicMonthScrollerUI.this.monthScroller.getCalendar();
                calendar.add(2, -1);
                BasicMonthScrollerUI.this.monthScroller.setCalendar(calendar);
            }
        });
        this.monthScroller.add((Component)this.prevButton, "0, 0, c, c");
        this.monthLabel = new MonthLabel(this.monthScroller);
        this.monthScroller.add((Component)this.monthLabel, "1, 0");
        this.repaintMonthLabel();
        this.nextButton = new ArrowButton(3, 21);
        this.nextButton.setBackground(color);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Calendar calendar = BasicMonthScrollerUI.this.monthScroller.getCalendar();
                calendar.add(2, 1);
                BasicMonthScrollerUI.this.monthScroller.setCalendar(calendar);
            }
        });
        this.monthScroller.add((Component)this.nextButton, "2, 0, c, c");
    }

    protected void uninstallComponents() {
        this.monthScroller.remove(this.prevButton);
        this.monthScroller.remove(this.nextButton);
        this.monthScroller.remove(this.monthLabel);
    }

    protected void installDefaults() {
        this.monthScroller.setOpaque(true);
        LookAndFeel.installColorsAndFont(this.monthScroller, "MonthScroller.background", "MonthScroller.foreground", "MonthScroller.font");
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.modelListener = this.createCalendarModelListener();
        this.monthScroller.addPropertyChangeListener(this.propertyChangeListener);
        IlvCalendarModel ilvCalendarModel = this.monthScroller.getModel();
        if (ilvCalendarModel != null) {
            ilvCalendarModel.addCalendarModelListener(this.modelListener);
        }
    }

    protected void uninstallListeners() {
        this.monthScroller.removePropertyChangeListener(this.propertyChangeListener);
        IlvCalendarModel ilvCalendarModel = this.monthScroller.getModel();
        if (ilvCalendarModel != null) {
            ilvCalendarModel.removeCalendarModelListener(this.modelListener);
        }
        this.propertyChangeListener = null;
        this.modelListener = null;
    }

    protected CalendarModelListener createCalendarModelListener() {
        return new CalendarModelHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void repaintMonthLabel() {
        Date date = this.monthScroller.getCalendar().getTime();
        String string = this.monthScroller.getMonthFormat().format(date);
        this.monthLabel.setText(string);
    }

    static class ArrowButton
    extends JButton {
        private boolean a;
        private int b;

        ArrowButton(int n2, int n3) {
            this.b = n2;
            this.setPreferredSize(new Dimension(n3, n3));
            this.setMinimumSize(new Dimension(n3, n3));
            this.setMaximumSize(new Dimension(n3, n3));
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.a = true;
            this.updateUI();
        }

        private void a() {
            int n2;
            int n3 = this.getPreferredSize().width;
            int n4 = n3 - 4;
            int n5 = n3 - 4;
            Insets insets = new Insets(4, 4, 4, 4);
            if (this.b == 3 || this.b == 7) {
                n2 = n5 - insets.top - insets.bottom;
                int n6 = (n2 + 1) / 2;
                insets.left = (n4 - n6) / 2;
                insets.right = n4 - n6 - insets.left;
            } else {
                n2 = n4 - insets.left - insets.right;
                int n7 = (n2 + 1) / 2;
                insets.top = (n5 - n7) / 2;
                insets.bottom = n5 - n7 - insets.top;
            }
            --insets.left;
            ++insets.right;
            IlvArrow ilvArrow = new IlvArrow(this.b, this.getForeground(), this.getBackground(), n4, n5);
            ilvArrow.setInsets(insets);
            ilvArrow.setTransparent(true);
            this.setIcon(ilvArrow);
        }

        public void updateUI() {
            if (!this.a) {
                return;
            }
            super.updateUI();
            this.setBorder(null);
            this.a();
        }
    }

    static class MonthLabel
    extends JLabel {
        private IlvJMonthScroller a;

        MonthLabel(IlvJMonthScroller ilvJMonthScroller) {
            this.a = ilvJMonthScroller;
            this.updateUI();
            this.setHorizontalAlignment(0);
        }

        public void updateUI() {
            if (this.a == null) {
                return;
            }
            super.updateUI();
            this.setFont(this.a.getFont());
            this.setForeground(this.a.getForeground());
            this.setBackground(this.a.getBackground());
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                IlvCalendarModel ilvCalendarModel = (IlvCalendarModel)propertyChangeEvent.getOldValue();
                IlvCalendarModel ilvCalendarModel2 = (IlvCalendarModel)propertyChangeEvent.getNewValue();
                if (ilvCalendarModel != null) {
                    ilvCalendarModel.removeCalendarModelListener(BasicMonthScrollerUI.this.modelListener);
                }
                if (ilvCalendarModel2 != null) {
                    ilvCalendarModel2.addCalendarModelListener(BasicMonthScrollerUI.this.modelListener);
                }
                BasicMonthScrollerUI.this.repaintMonthLabel();
            } else if (string.equals("monthFormat")) {
                BasicMonthScrollerUI.this.repaintMonthLabel();
            } else if (string.equals("font")) {
                BasicMonthScrollerUI.this.monthLabel.setFont(BasicMonthScrollerUI.this.monthScroller.getFont());
            } else if (string.equals("foreground")) {
                BasicMonthScrollerUI.this.monthLabel.setForeground(BasicMonthScrollerUI.this.monthScroller.getForeground());
            } else if (string.equals("background")) {
                Color color = BasicMonthScrollerUI.this.monthScroller.getBackground();
                BasicMonthScrollerUI.this.prevButton.setBackground(color);
                BasicMonthScrollerUI.this.nextButton.setBackground(color);
                BasicMonthScrollerUI.this.monthLabel.setBackground(color);
            }
        }
    }

    public class CalendarModelHandler
    implements CalendarModelListener {
        public void calendarChanged(CalendarModelEvent calendarModelEvent) {
            if (IlvCalendarUtil.compareMonth(calendarModelEvent.getOldCalendar(), calendarModelEvent.getNewCalendar()) != 0) {
                BasicMonthScrollerUI.this.repaintMonthLabel();
            }
        }
    }
}

