/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.calendar.plaf;

import ilog.views.util.swing.calendar.IlvCalendarCellRenderer;
import ilog.views.util.swing.calendar.IlvCalendarHeaderRenderer;
import ilog.views.util.swing.calendar.IlvCalendarModel;
import ilog.views.util.swing.calendar.IlvJCalendarPanel;
import ilog.views.util.swing.calendar.event.CalendarModelEvent;
import ilog.views.util.swing.calendar.event.CalendarModelListener;
import ilog.views.util.swing.calendar.plaf.CalendarPanelUI;
import ilog.views.util.time.IlvCalendarUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.HashSet;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicCalendarPanelUI
extends CalendarPanelUI {
    protected IlvJCalendarPanel calendarPanel;
    protected CellRendererPane rendererPane;
    protected PropertyChangeListener propertyChangeListener;
    protected CalendarModelListener modelListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseListener;
    private static HashSet a = new HashSet();
    private static HashSet b;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicCalendarPanelUI();
    }

    public void installUI(JComponent jComponent) {
        this.calendarPanel = (IlvJCalendarPanel)jComponent;
        this.rendererPane = new CellRendererPane();
        this.calendarPanel.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.calendarPanel.remove(this.rendererPane);
        this.rendererPane = null;
        this.calendarPanel = null;
    }

    protected void installDefaults() {
        Font font;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Font font2;
        Color color5;
        Color color6;
        Color color7;
        this.calendarPanel.setLayout(null);
        this.calendarPanel.setOpaque(true);
        LookAndFeel.installColorsAndFont(this.calendarPanel, "CalendarPanel.background", "CalendarPanel.foreground", "CalendarPanel.font");
        Color color8 = this.calendarPanel.getSelectionForeground();
        if (color8 == null || color8 instanceof UIResource) {
            this.calendarPanel.setSelectionForeground(UIManager.getColor("CalendarPanel.selectionForeground"));
        }
        if ((color7 = this.calendarPanel.getSelectionBackground()) == null || color7 instanceof UIResource) {
            this.calendarPanel.setSelectionBackground(UIManager.getColor("CalendarPanel.selectionBackground"));
        }
        if ((color6 = this.calendarPanel.getWeekendForeground()) == null || color6 instanceof UIResource) {
            this.calendarPanel.setWeekendForeground(UIManager.getColor("CalendarPanel.weekendForeground"));
        }
        if ((color5 = this.calendarPanel.getWeekendBackground()) == null || color5 instanceof UIResource) {
            this.calendarPanel.setWeekendBackground(UIManager.getColor("CalendarPanel.weekendBackground"));
        }
        if ((font2 = this.calendarPanel.getWeekendFont()) == null || font2 instanceof UIResource) {
            this.calendarPanel.setWeekendFont(UIManager.getFont("CalendarPanel.weekendFont"));
        }
        if ((color4 = this.calendarPanel.getPreviousMonthForeground()) == null || color4 instanceof UIResource) {
            this.calendarPanel.setPreviousMonthForeground(UIManager.getColor("CalendarPanel.previousMonthForeground"));
        }
        if ((color3 = this.calendarPanel.getNextMonthForeground()) == null || color3 instanceof UIResource) {
            this.calendarPanel.setNextMonthForeground(UIManager.getColor("CalendarPanel.nextMonthForeground"));
        }
        if ((color2 = this.calendarPanel.getHeaderForeground()) == null || color2 instanceof UIResource) {
            this.calendarPanel.setHeaderForeground(UIManager.getColor("CalendarPanel.headerForeground"));
        }
        if ((color = this.calendarPanel.getHeaderBackground()) == null || color instanceof UIResource) {
            this.calendarPanel.setHeaderBackground(UIManager.getColor("CalendarPanel.headerBackground"));
        }
        if ((font = this.calendarPanel.getHeaderFont()) == null || font instanceof UIResource) {
            this.calendarPanel.setHeaderFont(UIManager.getFont("CalendarPanel.headerFont"));
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.mouseListener = this.createMouseListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.modelListener = this.createCalendarModelListener();
        this.calendarPanel.addFocusListener(this.focusListener);
        this.calendarPanel.addMouseListener(this.mouseListener);
        this.calendarPanel.addMouseMotionListener(this.mouseListener);
        this.calendarPanel.addPropertyChangeListener(this.propertyChangeListener);
        IlvCalendarModel ilvCalendarModel = this.calendarPanel.getModel();
        if (ilvCalendarModel != null) {
            ilvCalendarModel.addCalendarModelListener(this.modelListener);
        }
    }

    protected void uninstallListeners() {
        this.calendarPanel.removeFocusListener(this.focusListener);
        this.calendarPanel.removeMouseListener(this.mouseListener);
        this.calendarPanel.removeMouseMotionListener(this.mouseListener);
        this.calendarPanel.removePropertyChangeListener(this.propertyChangeListener);
        IlvCalendarModel ilvCalendarModel = this.calendarPanel.getModel();
        if (ilvCalendarModel != null) {
            ilvCalendarModel.removeCalendarModelListener(this.modelListener);
        }
        this.focusListener = null;
        this.mouseListener = null;
        this.propertyChangeListener = null;
        this.modelListener = null;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseInputListener createMouseListener() {
        return new MouseHandler();
    }

    protected CalendarModelListener createCalendarModelListener() {
        return new CalendarModelHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public int getRowCount(IlvJCalendarPanel ilvJCalendarPanel) {
        return 6;
    }

    public int getColumnCount(IlvJCalendarPanel ilvJCalendarPanel) {
        return 7;
    }

    public int getRowHeight(IlvJCalendarPanel ilvJCalendarPanel) {
        Insets insets = ilvJCalendarPanel.getInsets();
        int n2 = ilvJCalendarPanel.getHeaderHeight() + insets.top + insets.bottom;
        return (ilvJCalendarPanel.getHeight() - n2) / this.getRowCount(ilvJCalendarPanel);
    }

    public int getColumnWidth(IlvJCalendarPanel ilvJCalendarPanel) {
        Insets insets = ilvJCalendarPanel.getInsets();
        return (ilvJCalendarPanel.getWidth() - (insets.left + insets.right)) / this.getColumnCount(ilvJCalendarPanel);
    }

    public Rectangle getCellRect(IlvJCalendarPanel ilvJCalendarPanel, int n2, int n3) {
        if (n2 < -1 || n2 >= this.getRowCount(ilvJCalendarPanel) || n3 < 0 || n3 >= this.getColumnCount(ilvJCalendarPanel)) {
            return null;
        }
        Insets insets = ilvJCalendarPanel.getInsets();
        int n4 = this.getColumnWidth(ilvJCalendarPanel);
        int n5 = insets.left + n3 * n4;
        int n6 = insets.top;
        int n7 = 0;
        if (n2 == -1) {
            n7 = ilvJCalendarPanel.getHeaderHeight();
        } else {
            n7 = this.getRowHeight(ilvJCalendarPanel);
            n6 += ilvJCalendarPanel.getHeaderHeight() + n2 * n7;
        }
        return new Rectangle(n5, n6, n4, n7);
    }

    public int getRowAtPoint(IlvJCalendarPanel ilvJCalendarPanel, Point point) {
        Insets insets = ilvJCalendarPanel.getInsets();
        int n2 = point.y - insets.top;
        if (n2 < 0) {
            return -2;
        }
        if ((n2 -= ilvJCalendarPanel.getHeaderHeight()) < 0) {
            return -1;
        }
        int n3 = n2 / this.getRowHeight(ilvJCalendarPanel);
        if (n3 >= this.getRowCount(ilvJCalendarPanel)) {
            return -2;
        }
        return n3;
    }

    public int getColumnAtPoint(IlvJCalendarPanel ilvJCalendarPanel, Point point) {
        Insets insets = ilvJCalendarPanel.getInsets();
        int n2 = point.x - insets.left;
        if (n2 < 0) {
            return -1;
        }
        int n3 = n2 / this.getColumnWidth(ilvJCalendarPanel);
        if (n3 >= this.getColumnCount(ilvJCalendarPanel)) {
            return -1;
        }
        return n3;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = this.calendarPanel.getInsets();
        float f2 = this.calendarPanel.getFont().getSize2D();
        int n2 = Math.round((float)this.getColumnCount(this.calendarPanel) * 2.25f * f2) + insets.left + insets.right;
        int n3 = Math.round((float)this.getRowCount(this.calendarPanel) * 1.83f * f2) + this.calendarPanel.getHeaderHeight() + insets.top + insets.bottom;
        return new Dimension(n2, n3);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Insets insets = this.calendarPanel.getInsets();
        int n2 = this.getColumnCount(this.calendarPanel) * 10 + insets.left + insets.right;
        int n3 = this.getRowCount(this.calendarPanel) * 10 + this.calendarPanel.getHeaderHeight() + insets.top + insets.bottom;
        return new Dimension(n2, n3);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected final Calendar getFirstDayOfMonth() {
        Calendar calendar = this.calendarPanel.getCalendar();
        IlvCalendarUtil.monthFloor(calendar);
        return calendar;
    }

    protected final Calendar getFirstDayOfPanel() {
        Calendar calendar = this.getFirstDayOfMonth();
        int n2 = calendar.get(7);
        int n3 = calendar.getFirstDayOfWeek();
        int n4 = n3 - n2;
        if (n4 > 0) {
            n4 -= 7;
        }
        if (n4 != 0) {
            calendar.add(6, n4);
        }
        return calendar;
    }

    public Calendar getCellDate(IlvJCalendarPanel ilvJCalendarPanel, int n2, int n3) {
        if (n2 < 0 || n2 >= this.getRowCount(ilvJCalendarPanel) || n3 < 0 || n3 >= this.getColumnCount(ilvJCalendarPanel)) {
            return null;
        }
        Calendar calendar = this.getFirstDayOfPanel();
        if (n2 > 0 || n3 > 0) {
            calendar.add(6, n3 + n2 * this.getColumnCount(ilvJCalendarPanel));
        }
        return calendar;
    }

    protected void resizeAndRepaint() {
        this.calendarPanel.revalidate();
        this.calendarPanel.repaint();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.a(graphics);
        this.b(graphics);
    }

    private void a(Graphics graphics) {
        Calendar calendar = this.getFirstDayOfPanel();
        IlvCalendarHeaderRenderer ilvCalendarHeaderRenderer = this.calendarPanel.getHeaderRenderer();
        Rectangle rectangle = this.getCellRect(this.calendarPanel, -1, 0);
        int n2 = this.getColumnWidth(this.calendarPanel);
        int n3 = this.getColumnCount(this.calendarPanel);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.paintHeader(graphics, rectangle, i2, ilvCalendarHeaderRenderer, calendar);
            rectangle.x += n2;
            calendar.add(6, 1);
        }
    }

    protected void paintHeader(Graphics graphics, Rectangle rectangle, int n2, IlvCalendarHeaderRenderer ilvCalendarHeaderRenderer, Calendar calendar) {
        Component component = ilvCalendarHeaderRenderer.getCalendarHeaderRendererComponent(this.calendarPanel, calendar, n2);
        this.rendererPane.paintComponent(graphics, component, this.calendarPanel, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private void b(Graphics graphics) {
        Calendar calendar = this.calendarPanel.getCalendar();
        Calendar calendar2 = this.getFirstDayOfPanel();
        IlvCalendarCellRenderer ilvCalendarCellRenderer = this.calendarPanel.getCellRenderer();
        int n2 = this.getColumnWidth(this.calendarPanel);
        int n3 = this.getRowCount(this.calendarPanel);
        int n4 = this.getColumnCount(this.calendarPanel);
        for (int i2 = 0; i2 < n3; ++i2) {
            Rectangle rectangle = this.getCellRect(this.calendarPanel, i2, 0);
            for (int i3 = 0; i3 < n4; ++i3) {
                int n5 = IlvCalendarUtil.compareMonth(calendar2, calendar);
                boolean bl = n5 == 0 ? IlvCalendarUtil.compareDay(calendar, calendar2) == 0 : false;
                this.paintCell(graphics, rectangle, i2, i3, ilvCalendarCellRenderer, calendar2, n5 < 0, n5 > 0, bl);
                rectangle.x += n2;
                calendar2.add(6, 1);
            }
        }
    }

    protected void paintCell(Graphics graphics, Rectangle rectangle, int n2, int n3, IlvCalendarCellRenderer ilvCalendarCellRenderer, Calendar calendar, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.calendarPanel.hasFocus();
        Component component = ilvCalendarCellRenderer.getCalendarCellRendererComponent(this.calendarPanel, calendar, n2, n3, bl, bl2, bl3, bl4);
        this.rendererPane.paintComponent(graphics, component, this.calendarPanel, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    static {
        a.add("cellRenderer");
        a.add("headerRenderer");
        a.add("selectionForeground");
        a.add("selectionBackground");
        a.add("weekendForeground");
        a.add("weekendBackground");
        a.add("weekendFont");
        a.add("previousMonthForeground");
        a.add("nextMonthForeground");
        a.add("headerForeground");
        a.add("headerBackground");
        a.add("headerFont");
        b = new HashSet();
        b.add("font");
        b.add("foreground");
        b.add("background");
        b.add("headerHeight");
    }

    public static class SelectionBorder
    implements Border,
    UIResource {
        private Border a;
        private JButton b;

        public SelectionBorder(Border border) {
            this.a = border;
            this.b = new JButton(""){

                public boolean isDefaultButton() {
                    return true;
                }

                public boolean isDefaultCapable() {
                    return true;
                }
            };
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            this.a.paintBorder(this.b, graphics, n2, n3, n4, n5);
        }

        public Insets getBorderInsets(Component component) {
            return this.a.getBorderInsets(component);
        }

        public boolean isBorderOpaque() {
            return this.a.isBorderOpaque();
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                IlvCalendarModel ilvCalendarModel = (IlvCalendarModel)propertyChangeEvent.getOldValue();
                IlvCalendarModel ilvCalendarModel2 = (IlvCalendarModel)propertyChangeEvent.getNewValue();
                if (ilvCalendarModel != null) {
                    ilvCalendarModel.removeCalendarModelListener(BasicCalendarPanelUI.this.modelListener);
                }
                if (ilvCalendarModel2 != null) {
                    ilvCalendarModel2.addCalendarModelListener(BasicCalendarPanelUI.this.modelListener);
                }
                BasicCalendarPanelUI.this.calendarPanel.repaint();
            } else if (a.contains(string)) {
                BasicCalendarPanelUI.this.calendarPanel.repaint();
            } else if (b.contains(string)) {
                BasicCalendarPanelUI.this.resizeAndRepaint();
            }
        }
    }

    public class CalendarModelHandler
    implements CalendarModelListener {
        public void calendarChanged(CalendarModelEvent calendarModelEvent) {
            if (IlvCalendarUtil.compareDay(calendarModelEvent.getOldCalendar(), calendarModelEvent.getNewCalendar()) != 0) {
                BasicCalendarPanelUI.this.calendarPanel.repaint();
            }
        }
    }

    public class MouseHandler
    implements MouseInputListener {
        public void mousePressed(MouseEvent mouseEvent) {
            int n2;
            Point point;
            int n3;
            Calendar calendar;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicCalendarPanelUI.this.calendarPanel.isEnabled()) {
                return;
            }
            if (!BasicCalendarPanelUI.this.calendarPanel.hasFocus()) {
                BasicCalendarPanelUI.this.calendarPanel.requestFocus();
            }
            if ((calendar = BasicCalendarPanelUI.this.getCellDate(BasicCalendarPanelUI.this.calendarPanel, n3 = BasicCalendarPanelUI.this.getRowAtPoint(BasicCalendarPanelUI.this.calendarPanel, point = mouseEvent.getPoint()), n2 = BasicCalendarPanelUI.this.getColumnAtPoint(BasicCalendarPanelUI.this.calendarPanel, point))) != null) {
                Calendar calendar2 = BasicCalendarPanelUI.this.calendarPanel.getModel().getCalendar();
                calendar.add(11, calendar2.get(11));
                calendar.add(12, calendar2.get(12));
                calendar.add(13, calendar2.get(13));
                BasicCalendarPanelUI.this.calendarPanel.getModel().setCalendar(calendar);
                BasicCalendarPanelUI.this.calendarPanel.fireDateSelected();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            BasicCalendarPanelUI.this.calendarPanel.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicCalendarPanelUI.this.calendarPanel.repaint();
        }
    }
}

