/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d.internal;

import ilog.views.util.IlvResourceUtil;
import ilog.views.util.java2d.internal.DefaultLineStyleSelectionModel;
import ilog.views.util.java2d.internal.LineStyleSelectionModel;
import ilog.views.util.swing.SwingFactories;
import ilog.views.util.swing.layout.IlvTableLayout;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IlvLineStyleChooser
extends JPanel {
    private static ResourceBundle a = IlvResourceUtil.getBundle("messages", IlvLineStyleChooser.class, Locale.getDefault());
    private static Color b = UIManager.getColor("Button.foreground");
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private LineStyleSelectionModel c;
    private JComboBox d;
    private JCheckBox e;
    private JTextField f;
    private LineStyle g;
    private boolean h = false;
    private boolean i = false;
    private static final Object[] j = new Object[]{null, new float[]{4.0f, 4.0f}, new float[]{8.0f, 8.0f}, new float[]{8.0f, 4.0f, 4.0f, 4.0f}, new float[]{8.0f, 4.0f, 4.0f, 4.0f, 4.0f}, new float[]{1.0f, 1.0f}, new float[]{12.0f, 4.0f}, new float[]{4.0f, 4.0f, 4.0f, 13.0f}};
    private static final BasicStroke[] k = IlvLineStyleChooser.d();

    private static BasicStroke[] d() {
        BasicStroke[] basicStrokeArray = new BasicStroke[8];
        for (int i2 = 0; i2 < j.length; ++i2) {
            basicStrokeArray[i2] = new BasicStroke(3.0f, 0, 0, 10.0f, (float[])j[i2], 0.0f);
        }
        return basicStrokeArray;
    }

    private static void b(String string, Container container) {
        JOptionPane.showMessageDialog(container, string, a.getString("IlvLineStyleChooser.error.titleWindow"), 0);
    }

    public IlvLineStyleChooser() {
        this(new DefaultLineStyleSelectionModel(null));
    }

    public IlvLineStyleChooser(float[] fArray) {
        this(new DefaultLineStyleSelectionModel(fArray));
    }

    public IlvLineStyleChooser(LineStyleSelectionModel lineStyleSelectionModel) {
        this.c = lineStyleSelectionModel;
        this.c.addChangeListener(new PreviewListener());
        this.setLayout(new BorderLayout());
        this.setName(a.getString("IlvLineStyleChooser.Name"));
        LineStyleListener lineStyleListener = new LineStyleListener();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), a.getString("IlvLineStyleChooser.Style")));
        double[][] dArrayArray = new double[][]{{5.0, -2.0, 10.0, -2.0, 5.0}, {5.0, -2.0, 5.0, -2.0, 5.0}};
        jPanel2.setLayout(new IlvTableLayout(dArrayArray));
        jPanel2.add((Component)new JLabel(a.getString("IlvLineStyleChooser.Predefined")), "1,1,1,1");
        this.d = new JComboBox();
        jPanel2.add(this.d, "3,1,1,1");
        this.d.setRenderer(new LineStyleCellRenderer());
        for (int i2 = 0; i2 < j.length; ++i2) {
            this.d.addItem(k[i2]);
        }
        this.d.addActionListener(lineStyleListener);
        this.e = new JCheckBox(a.getString("IlvLineStyleChooser.Custom"));
        jPanel2.add((Component)this.e, "1,3,1,1");
        this.e.addActionListener(lineStyleListener);
        this.f = SwingFactories.createTextField(null, null, 15);
        jPanel2.add((Component)this.f, "3,3,1,1");
        this.f.setText("");
        this.f.addActionListener(lineStyleListener);
        jPanel.add((Component)jPanel2, "Center");
        this.add((Component)jPanel, "Center");
        jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), a.getString("chooser.preview")));
        this.g = new LineStyle(lineStyleSelectionModel.getSelectedLineStyle());
        jPanel2.add(this.g);
        this.add((Component)jPanel2, "South");
        this.updateChooser();
    }

    public float[] getLineStyle() {
        return this.c.getSelectedLineStyle();
    }

    public void setLineStyle(float[] fArray) {
        this.c.setSelectedLineStyle(fArray);
    }

    public LineStyleSelectionModel getSelectionModel() {
        return this.c;
    }

    public void setSelectionMode(LineStyleSelectionModel lineStyleSelectionModel) {
        this.c = lineStyleSelectionModel;
    }

    protected void updateChooser() {
        this.h = true;
        float[] fArray = this.c.getSelectedLineStyle();
        int n2 = this.a(fArray);
        if (n2 != -1) {
            this.e.setSelected(false);
            this.f.setEnabled(false);
            this.d.setEnabled(true);
            this.d.setSelectedIndex(n2);
        } else {
            this.e.setSelected(true);
            this.f.setEnabled(true);
            this.d.setEnabled(false);
        }
        if (fArray != null) {
            this.f.setText(this.b(fArray));
        } else {
            this.f.setText("0");
        }
        this.h = false;
    }

    private int a(float[] fArray) {
        int n2 = -1;
        for (int i2 = 0; i2 < j.length; ++i2) {
            if (!Arrays.equals((float[])j[i2], fArray)) continue;
            n2 = i2;
        }
        return n2;
    }

    private String b(float[] fArray) {
        if (fArray == null || fArray.length == 0) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            stringBuffer.append(fArray[i2]);
            if (i2 >= fArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private class LineStyleCellRenderer
    extends LineStyle
    implements ListCellRenderer {
        public LineStyleCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            if (object != null) {
                this.setLineStyle(((BasicStroke)object).getDashArray());
            } else {
                this.setLineStyle(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private class LineStyle
    extends JLabel {
        private float[] a;
        private Rectangle b = new Rectangle(0, 0, 100, 12);
        private Stroke c = new BasicStroke();

        public LineStyle() {
            new LineStyle(null);
        }

        public LineStyle(float[] fArray) {
            this.setForeground(b);
            this.setBorder(noFocusBorder);
            this.setLineStyle(fArray);
        }

        public void setLineStyle(float[] fArray) {
            this.a = fArray;
            if (this.a != null) {
                try {
                    this.c = new BasicStroke(3.0f, 0, 0, 10.0f, this.a, 0.0f);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.c = new BasicStroke(3.0f, 0, 0, 10.0f);
                }
            } else {
                this.c = new BasicStroke(3.0f, 0, 0, 10.0f);
            }
            Shape shape = this.c.createStrokedShape(this.b);
            this.setPreferredSize(new Dimension(100, shape.getBounds().height));
            this.revalidate();
            this.repaint();
        }

        public float[] getLineStyle() {
            return this.a;
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.c != null) {
                graphics2D.setStroke(this.c);
            }
            Insets insets = this.getInsets();
            Rectangle rectangle = this.getBounds();
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(insets.left, insets.bottom, rectangle.width, rectangle.height);
            graphics2D.setColor(this.getForeground());
            graphics2D.draw(new Line2D.Float(insets.left, insets.top + rectangle.height / 2 - insets.bottom, rectangle.width - insets.right, insets.top + rectangle.height / 2 - insets.bottom));
            graphics2D.dispose();
        }
    }

    private class PreviewListener
    implements ChangeListener {
        private PreviewListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            IlvLineStyleChooser.this.g.setLineStyle(IlvLineStyleChooser.this.c.getSelectedLineStyle());
            if (!IlvLineStyleChooser.this.i) {
                IlvLineStyleChooser.this.updateChooser();
            }
        }
    }

    private class LineStyleListener
    implements ActionListener {
        private LineStyleListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (IlvLineStyleChooser.this.h) {
                return;
            }
            if (actionEvent.getSource() == IlvLineStyleChooser.this.e) {
                if (IlvLineStyleChooser.this.e.isSelected()) {
                    IlvLineStyleChooser.this.d.setEnabled(false);
                    IlvLineStyleChooser.this.f.setEnabled(true);
                } else {
                    IlvLineStyleChooser.this.d.setEnabled(true);
                    IlvLineStyleChooser.this.f.setEnabled(false);
                }
            }
            float[] fArray = null;
            if (IlvLineStyleChooser.this.e.isSelected()) {
                try {
                    fArray = this.a(IlvLineStyleChooser.this.f.getText());
                }
                catch (Exception exception) {
                    fArray = null;
                    IlvLineStyleChooser.this.f.setText("0");
                }
                int n2 = IlvLineStyleChooser.this.a(fArray);
                if (n2 != -1) {
                    IlvLineStyleChooser.this.d.setSelectedItem(k[n2]);
                }
            } else {
                fArray = ((BasicStroke)IlvLineStyleChooser.this.d.getSelectedItem()).getDashArray();
                String string = fArray != null ? IlvLineStyleChooser.this.b(fArray) : "0";
                IlvLineStyleChooser.this.f.setText(string);
            }
            IlvLineStyleChooser.this.i = true;
            IlvLineStyleChooser.this.c.setSelectedLineStyle(fArray);
            IlvLineStyleChooser.this.i = false;
        }

        private float[] a(String string) throws Exception {
            if (string == null || string == "" || string == "0") {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2++] = stringTokenizer.nextToken();
            }
            float[] fArray = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                try {
                    fArray[i2] = Float.parseFloat(stringArray[i2]);
                    continue;
                }
                catch (Exception exception) {
                    IlvLineStyleChooser.b(a.getString("IlvLineStyleChooser.error.badDashesInput"), IlvLineStyleChooser.this.getTopLevelAncestor());
                }
            }
            return fArray;
        }
    }
}

