/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d;

import ilog.views.util.internal.IlvInternalError;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class IlvPolygon2D
implements Shape,
Cloneable {
    private transient GeneralPath a;

    protected IlvPolygon2D() {
    }

    public abstract int getNumberOfPoints();

    public abstract Point2D getPoint(int var1);

    public abstract Point2D[] getPoints();

    private GeneralPath a() {
        if (this.a == null) {
            int n2 = this.getNumberOfPoints();
            GeneralPath generalPath = new GeneralPath(0, n2);
            Point2D point2D = this.getPoint(0);
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            for (int i2 = 1; i2 < n2; ++i2) {
                point2D = this.getPoint(i2);
                generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
            }
            generalPath.closePath();
            this.a = generalPath;
        }
        return this.a;
    }

    public Rectangle getBounds() {
        int n2 = this.getNumberOfPoints();
        assert (n2 > 0);
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < n2; ++i2) {
            Point2D point2D = this.getPoint(i2);
            double d2 = point2D.getX();
            double d3 = point2D.getY();
            if ((double)n3 > d2) {
                n3 = (int)Math.floor(d2);
            }
            if ((double)n4 < d2) {
                n4 = (int)Math.ceil(d2);
            }
            if ((double)n5 > d3) {
                n5 = (int)Math.floor(d3);
            }
            if (!((double)n6 < d3)) continue;
            n6 = (int)Math.ceil(d3);
        }
        return new Rectangle(n3, n5, n4 - n3, n6 - n5);
    }

    public abstract Rectangle2D getBounds2D();

    private int a(double d2, double d3) {
        Rectangle2D rectangle2D = this.getBounds2D();
        if (d2 < rectangle2D.getMinX() || d2 > rectangle2D.getMaxX() || d3 < rectangle2D.getMinY() || d3 > rectangle2D.getMaxY()) {
            return 0;
        }
        int n2 = this.getNumberOfPoints();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4;
            int n4 = i2 == 0 ? n2 - 1 : i2 - 1;
            Point2D point2D = this.getPoint(n4);
            double d5 = point2D.getX();
            double d6 = point2D.getY();
            point2D = this.getPoint(i2);
            double d7 = point2D.getX();
            double d8 = point2D.getY();
            if (d6 > d3) {
                if (d8 > d3) continue;
                if (d8 == d3) {
                    if (d7 == d2) {
                        return 1;
                    }
                    n3 += d7 < d2 ? 1 : -1;
                    continue;
                }
            } else if (d6 < d3) {
                if (d8 < d3) continue;
                if (d8 == d3) {
                    if (d7 == d2) {
                        return 1;
                    }
                    n3 += d7 < d2 ? -1 : 1;
                    continue;
                }
            } else {
                if (d5 == d2) {
                    return 1;
                }
                if (d8 < d3) {
                    n3 += d5 < d2 ? 1 : -1;
                    continue;
                }
                if (d8 > d3) {
                    n3 += d5 < d2 ? -1 : 1;
                    continue;
                }
                if (d5 < d2 && d7 < d2 || d5 > d2 && d7 > d2) continue;
                return 1;
            }
            if ((d4 = (d5 - d2) * (d8 - d3) - (d7 - d2) * (d6 - d3)) == 0.0) {
                return 1;
            }
            n3 += d4 > 0.0 ? 2 : -2;
        }
        if (n3 & true) {
            throw new IlvInternalError("error in IlvPolygon2D.windingNumber");
        }
        return n3 >> 1;
    }

    public boolean containsInInterior(double d2, double d3) {
        int n2 = this.a(d2, d3);
        if ((n2 & 1) != 0) {
            return false;
        }
        return ((n2 >>= 1) & 1) != 0;
    }

    public boolean containsInClosure(double d2, double d3) {
        int n2 = this.a(d2, d3);
        if ((n2 & 1) != 0) {
            return true;
        }
        return ((n2 >>= 1) & 1) != 0;
    }

    public boolean contains(double d2, double d3) {
        return this.containsInInterior(d2, d3);
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        return this.a().intersects(d2, d3, d4, d5);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return this.a().contains(d2, d3, d4, d5);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(final AffineTransform affineTransform) {
        return new PathIterator(){
            private int a = 0;

            public int currentSegment(double[] dArray) {
                if (this.a < IlvPolygon2D.this.getNumberOfPoints()) {
                    Point2D point2D = IlvPolygon2D.this.getPoint(this.a);
                    dArray[0] = point2D.getX();
                    dArray[1] = point2D.getY();
                    if (affineTransform != null) {
                        affineTransform.transform(dArray, 0, dArray, 0, 1);
                    }
                    return this.a == 0 ? 0 : 1;
                }
                return 4;
            }

            public int currentSegment(float[] fArray) {
                if (this.a < IlvPolygon2D.this.getNumberOfPoints()) {
                    Point2D point2D = IlvPolygon2D.this.getPoint(this.a);
                    fArray[0] = (float)point2D.getX();
                    fArray[1] = (float)point2D.getY();
                    if (affineTransform != null) {
                        affineTransform.transform(fArray, 0, fArray, 0, 1);
                    }
                    return this.a == 0 ? 0 : 1;
                }
                return 4;
            }

            public int getWindingRule() {
                return 0;
            }

            public boolean isDone() {
                return this.a > IlvPolygon2D.this.getNumberOfPoints();
            }

            public void next() {
                ++this.a;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return this.getPathIterator(affineTransform);
    }

    private static double b(double d2, double d3) {
        if (d2 > 0.0 && d3 >= 0.0) {
            return d3 / (d2 + d3);
        }
        if (d3 > 0.0 && d2 <= 0.0) {
            return 1.0 + d2 / (d2 - d3);
        }
        if (d2 < 0.0 && d3 <= 0.0) {
            return 2.0 + d3 / (d2 + d3);
        }
        if (d3 < 0.0 && d2 >= 0.0) {
            return 3.0 + d2 / (d2 - d3);
        }
        throw new IlvInternalError("ilog.views.util.java2d.IlvPolygon2D.Angle");
    }

    private static double a(double d2) {
        if (d2 >= 2.0) {
            return d2 - 2.0;
        }
        return d2 + 2.0;
    }

    public boolean containsInConvexHull(Point2D point2D) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        CircularInterval circularInterval = new CircularInterval();
        int n2 = this.getNumberOfPoints();
        for (int i2 = 0; i2 < n2; ++i2) {
            Point2D point2D2 = this.getPoint(i2);
            double d4 = point2D2.getX() - d2;
            double d5 = point2D2.getY() - d3;
            if (d4 == 0.0 && d5 == 0.0) {
                return true;
            }
            double d6 = IlvPolygon2D.b(d4, d5);
            if (!circularInterval.add(d6, IlvPolygon2D.a(d6))) continue;
            return true;
        }
        return false;
    }

    public double getArea() {
        int n2 = this.getNumberOfPoints();
        if (n2 <= 2) {
            return 0.0;
        }
        Point2D point2D = this.getPoint(0);
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = 0.0;
        for (int i2 = 2; i2 < n2; ++i2) {
            point2D = this.getPoint(i2 - 1);
            double d5 = point2D.getX();
            double d6 = point2D.getY();
            point2D = this.getPoint(i2);
            double d7 = point2D.getX();
            double d8 = point2D.getY();
            d4 += (d5 -= d2) * (d8 -= d3) - (d7 -= d2) * (d6 -= d3);
        }
        return 0.5 * d4;
    }

    public Point2D getGravity0() {
        int n2 = this.getNumberOfPoints();
        assert (n2 > 0);
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Point2D point2D = this.getPoint(i2);
            d2 += point2D.getX();
            d3 += point2D.getY();
        }
        return new Point2D.Double(d2 / (double)n2, d3 / (double)n2);
    }

    public Point2D getGravity1() {
        int n2 = this.getNumberOfPoints();
        assert (n2 > 0);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Point2D point2D = this.getPoint(i2);
            Point2D point2D2 = this.getPoint(i2 == n2 - 1 ? 0 : i2 + 1);
            double d5 = point2D.getX();
            double d6 = point2D.getY();
            double d7 = point2D2.getX();
            double d8 = point2D2.getY();
            double d9 = d7 - d5;
            double d10 = d8 - d6;
            double d11 = d9 == 0.0 ? Math.abs(d10) : (d10 == 0.0 ? Math.abs(d9) : Math.sqrt(d9 * d9 + d10 * d10));
            d2 += (d5 + d7) * d11;
            d3 += d6 + d8 + d11;
            d4 += d11;
        }
        if (d4 >= 1.0E-10) {
            d4 = 2.0 * d4;
            return new Point2D.Double(d2 / d4, d3 / d4);
        }
        return this.getGravity0();
    }

    public Point2D getGravity2() {
        int n2 = this.getNumberOfPoints();
        Point2D point2D = this.getPoint(0);
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i2 = 2; i2 < n2; ++i2) {
            point2D = this.getPoint(i2 - 1);
            double d7 = point2D.getX();
            double d8 = point2D.getY();
            point2D = this.getPoint(i2);
            double d9 = point2D.getX();
            double d10 = point2D.getY();
            double d11 = (d7 -= d2) * (d10 -= d3) - (d9 -= d2) * (d8 -= d3);
            d4 += (d7 + d9) * d11;
            d5 += (d8 + d10) * d11;
            d6 += d11;
        }
        if (Math.abs(d6) >= 1.0E-10) {
            d6 = 3.0 * d6;
            return new Point2D.Double(d2 + d4 / d6, d3 + d5 / d6);
        }
        return this.getGravity1();
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            IlvPolygon2D ilvPolygon2D = (IlvPolygon2D)object;
            int n2 = this.getNumberOfPoints();
            if (n2 == ilvPolygon2D.getNumberOfPoints()) {
                Point2D[] point2DArray = this.getPoints();
                Point2D[] point2DArray2 = ilvPolygon2D.getPoints();
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (point2DArray[i2].equals(point2DArray2[i2])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        int n2 = this.getNumberOfPoints();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append("-");
            }
            stringBuffer.append("(");
            stringBuffer.append(this.getPoint(i2).getX());
            stringBuffer.append(",");
            stringBuffer.append(this.getPoint(i2).getY());
            stringBuffer.append(")");
        }
        stringBuffer.append("-]");
        return stringBuffer.toString();
    }

    private static class CircularInterval {
        private boolean a = false;
        private double b;
        private double c;

        public boolean contains(double d2) {
            if (this.a) {
                if (this.b <= this.c) {
                    return this.b <= d2 && d2 <= this.c;
                }
                return this.b <= d2 || d2 <= this.c;
            }
            return false;
        }

        public boolean containsInterval(double d2, double d3) {
            if (this.a) {
                if (this.b <= this.c) {
                    return this.b <= d2 && d2 <= d3 && d3 <= this.c;
                }
                if (d2 <= d3) {
                    return this.b <= d2 || d3 <= this.c;
                }
                return this.b <= d2 && d3 <= this.c;
            }
            return false;
        }

        public boolean add(double d2, double d3) {
            if (this.a) {
                boolean bl = this.contains(d2);
                boolean bl2 = this.contains(d3);
                if (!bl && !bl2) {
                    throw new IlvInternalError("ilog.views.util.java2d.IlvPolygon2D.containsInConvexHull");
                }
                if (bl && bl2 && !this.containsInterval(d2, d3)) {
                    return true;
                }
                if (!bl) {
                    this.b = d2;
                }
                if (!bl2) {
                    this.c = d3;
                }
                return false;
            }
            this.a = true;
            this.b = d2;
            this.c = d3;
            return false;
        }
    }

    public static class Double
    extends IlvPolygon2D {
        private int a;
        private Point2D.Double[] b;

        public Double(Point2D[] point2DArray) {
            int n2 = point2DArray.length;
            if (n2 == 0) {
                throw new IllegalArgumentException("points should not be empty");
            }
            this.a = n2;
            this.b = new Point2D.Double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Point2D point2D = point2DArray[i2];
                this.b[i2] = new Point2D.Double(point2D.getX(), point2D.getY());
            }
        }

        public Double(double[] dArray, double[] dArray2, int n2) {
            if (n2 == 0) {
                throw new IllegalArgumentException("polygon cannot be empty");
            }
            this.a = n2;
            this.b = new Point2D.Double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b[i2] = new Point2D.Double(dArray[i2], dArray2[i2]);
            }
        }

        public Double(float[] fArray, float[] fArray2, int n2) {
            if (n2 == 0) {
                throw new IllegalArgumentException("polygon cannot be empty");
            }
            this.a = n2;
            this.b = new Point2D.Double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b[i2] = new Point2D.Double(fArray[i2], fArray2[i2]);
            }
        }

        public Double(int[] nArray, int[] nArray2, int n2) {
            if (n2 == 0) {
                throw new IllegalArgumentException("polygon cannot be empty");
            }
            this.a = n2;
            this.b = new Point2D.Double[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b[i2] = new Point2D.Double(nArray[i2], nArray2[i2]);
            }
        }

        public int getNumberOfPoints() {
            return this.a;
        }

        public Point2D getPoint(int n2) {
            return this.b[n2];
        }

        public Point2D[] getPoints() {
            return this.b;
        }

        public Rectangle2D getBounds2D() {
            int n2 = this.a;
            assert (n2 > 0);
            double d2 = java.lang.Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            double d4 = java.lang.Double.MAX_VALUE;
            double d5 = -1.7976931348623157E308;
            for (int i2 = 0; i2 < n2; ++i2) {
                Point2D.Double double_ = this.b[i2];
                if (d2 > double_.x) {
                    d2 = double_.x;
                }
                if (d3 < double_.x) {
                    d3 = double_.x;
                }
                if (d4 > double_.y) {
                    d4 = double_.y;
                }
                if (!(d5 < double_.y)) continue;
                d5 = double_.y;
            }
            return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
        }

        public Object clone() {
            try {
                Double double_ = (Double)super.clone();
                int n2 = this.a;
                double_.b = new Point2D.Double[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    double_.b[i2] = (Point2D.Double)this.b[i2].clone();
                }
                return double_;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public int hashCode() {
            int n2 = this.a;
            long l2 = -n2 << 3;
            long l3 = this.getClass().hashCode();
            for (int i2 = 0; i2 < n2; ++i2) {
                l2 += java.lang.Double.doubleToLongBits(this.b[i2].x);
                l3 += java.lang.Double.doubleToLongBits(this.b[i2].y);
            }
            return (int)l2 + (int)(l2 >>> 32) + (int)(l3 << 1) + (int)(l3 >>> 31);
        }
    }

    public static class Float
    extends IlvPolygon2D {
        private int a;
        private Point2D.Float[] b;

        public Float(Point2D[] point2DArray) {
            int n2 = point2DArray.length;
            if (n2 == 0) {
                throw new IllegalArgumentException("points should not be empty");
            }
            this.a = n2;
            this.b = new Point2D.Float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                Point2D point2D = point2DArray[i2];
                this.b[i2] = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
            }
        }

        public Float(float[] fArray, float[] fArray2, int n2) {
            if (n2 == 0) {
                throw new IllegalArgumentException("polygon cannot be empty");
            }
            this.a = n2;
            this.b = new Point2D.Float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.b[i2] = new Point2D.Float(fArray[i2], fArray2[i2]);
            }
        }

        public int getNumberOfPoints() {
            return this.a;
        }

        public Point2D getPoint(int n2) {
            return this.b[n2];
        }

        public Point2D[] getPoints() {
            return this.b;
        }

        public Rectangle2D getBounds2D() {
            int n2 = this.a;
            assert (n2 > 0);
            float f2 = java.lang.Float.MAX_VALUE;
            float f3 = -3.4028235E38f;
            float f4 = java.lang.Float.MAX_VALUE;
            float f5 = -3.4028235E38f;
            for (int i2 = 0; i2 < n2; ++i2) {
                Point2D.Float float_ = this.b[i2];
                if (f2 > float_.x) {
                    f2 = float_.x;
                }
                if (f3 < float_.x) {
                    f3 = float_.x;
                }
                if (f4 > float_.y) {
                    f4 = float_.y;
                }
                if (!(f5 < float_.y)) continue;
                f5 = float_.y;
            }
            return new Rectangle2D.Float(f2, f4, f3 - f2, f5 - f4);
        }

        public Object clone() {
            try {
                Float float_ = (Float)super.clone();
                int n2 = this.a;
                float_.b = new Point2D.Float[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    float_.b[i2] = (Point2D.Float)this.b[i2].clone();
                }
                return float_;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public int hashCode() {
            int n2 = this.a;
            int n3 = -n2 << 3;
            int n4 = this.getClass().hashCode();
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 += java.lang.Float.floatToIntBits(this.b[i2].x);
                n4 += java.lang.Float.floatToIntBits(this.b[i2].y);
            }
            return n3 + (n4 << 1);
        }
    }
}

