/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.event;

import ilog.views.util.collections.IlvCollections;
import ilog.views.util.event.IlvEventListenerCollection;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IlvAbstractEventListenerCollection<L extends EventListener>
implements IlvEventListenerCollection<L>,
Serializable {
    Collection<L> a = null;

    protected abstract void initListeners();

    protected abstract Collection<L> cloneListeners();

    @Override
    public synchronized void addListener(L l2) {
        if (this.a == null) {
            this.initListeners();
        }
        Collection<L> collection = this.cloneListeners();
        collection.add(l2);
        this.a = collection;
    }

    @Override
    public synchronized void removeListener(L l2) {
        if (this.a != null) {
            Collection<L> collection = this.cloneListeners();
            collection.remove(l2);
            this.a = collection.isEmpty() ? null : collection;
        }
    }

    @Override
    public synchronized Iterator<L> getListeners() {
        if (this.a == null) {
            return IlvCollections.emptyIterator();
        }
        return this.a.iterator();
    }

    public synchronized int size() {
        return this.a == null ? 0 : this.a.size();
    }

    @Override
    public synchronized boolean contains(L l2) {
        return this.a.contains(l2);
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream, String string) throws IOException {
        Iterator<L> iterator = this.getListeners();
        while (iterator.hasNext()) {
            EventListener eventListener = (EventListener)iterator.next();
            if (!(eventListener instanceof Serializable)) continue;
            objectOutputStream.writeObject(string);
            objectOutputStream.writeObject(eventListener);
        }
    }
}

